/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Arrays;
import org.drools.FactHandle;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;

final class FactHandleList
implements Serializable {
    private static final long serialVersionUID = -6767210501355521967L;
    static final FactHandleList EMPTY_LIST = new FactHandleList();
    private final InternalFactHandle[] handles;
    private final int hashCode;

    private FactHandleList() {
        this.handles = new DefaultFactHandle[0];
        this.hashCode = 0;
    }

    public FactHandleList(FactHandleList factHandleList, InternalFactHandle internalFactHandle) {
        this.handles = new DefaultFactHandle[factHandleList.handles.length + 1];
        System.arraycopy(factHandleList.handles, 0, this.handles, 0, factHandleList.handles.length);
        this.handles[factHandleList.handles.length] = internalFactHandle;
        this.hashCode = factHandleList.hashCode + internalFactHandle.hashCode();
    }

    public FactHandleList(DefaultFactHandle defaultFactHandle) {
        this.handles = new DefaultFactHandle[]{defaultFactHandle};
        this.hashCode = defaultFactHandle.hashCode();
    }

    public InternalFactHandle get(int n) {
        return this.handles[n];
    }

    public boolean contains(FactHandle factHandle) {
        for (int i = this.handles.length - 1; i >= 0; --i) {
            if (!factHandle.equals(this.handles[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(FactHandleList factHandleList) {
        if (factHandleList.handles.length > this.handles.length) {
            return false;
        }
        for (int i = factHandleList.handles.length - 1; i >= 0; --i) {
            InternalFactHandle internalFactHandle = factHandleList.handles[i];
            if (internalFactHandle == null || internalFactHandle.equals(this.handles[i])) continue;
            return false;
        }
        return true;
    }

    InternalFactHandle[] getHandles() {
        return this.handles;
    }

    public int size() {
        return this.handles.length;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.handles, ((FactHandleList)object).handles);
    }
}

