/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps.util;

import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Iterator;
import org.drools.leaps.Token;
import org.drools.leaps.util.TableRecord;
import org.drools.util.PrimitiveLongMap;

public class TokenStack
implements Serializable {
    protected TableRecord tailRecord = null;
    private final PrimitiveLongMap map = new PrimitiveLongMap();

    public boolean empty() {
        return this.tailRecord == null;
    }

    public Object peek() {
        if (this.tailRecord != null) {
            return this.tailRecord.object;
        }
        throw new EmptyStackException();
    }

    public Object pop() {
        if (this.tailRecord != null) {
            Object object = this.tailRecord.object;
            TableRecord tableRecord = this.tailRecord;
            this.tailRecord = tableRecord.left;
            if (tableRecord.left != null) {
                this.tailRecord.right = null;
            }
            tableRecord.left = null;
            this.map.remove(((Token)object).getDominantFactHandle().getId());
            return object;
        }
        throw new EmptyStackException();
    }

    public void remove(long l) {
        TableRecord tableRecord;
        if (this.tailRecord != null && (tableRecord = (TableRecord)this.map.remove(l)) != null) {
            if (tableRecord == this.tailRecord) {
                this.tailRecord = tableRecord.left;
            }
            if (tableRecord.left != null) {
                tableRecord.left.right = tableRecord.right;
            }
            if (tableRecord.right != null) {
                tableRecord.right.left = tableRecord.left;
            }
            tableRecord.left = null;
            tableRecord.right = null;
        }
    }

    public Object push(Object object) {
        TableRecord tableRecord = new TableRecord(object);
        if (this.tailRecord != null) {
            this.tailRecord.right = tableRecord;
            tableRecord.left = this.tailRecord;
        }
        this.tailRecord = tableRecord;
        this.map.put(((Token)object).getDominantFactHandle().getId(), tableRecord);
        return object;
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator it;
            {
                this.it = TokenStack.this.map.values().iterator();
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
            }

            public Object next() {
                return this.it.next();
            }
        };
    }
}

