/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.drools.WorkingMemory;
import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.util.ConstrainedIteratorFromPositionToTableStart;
import org.drools.leaps.util.IteratorFromPositionToTableEnd;
import org.drools.leaps.util.IteratorFromPositionToTableStart;
import org.drools.leaps.util.RecordComparator;
import org.drools.leaps.util.TableIterator;
import org.drools.leaps.util.TableRecord;

public class Table
implements Serializable {
    private static final long serialVersionUID = 2614082619270512055L;
    private final TreeSet set;
    protected TableRecord headRecord;
    protected TableRecord tailRecord;
    private boolean empty = true;
    private int count = 0;

    public Table(Comparator comparator) {
        this.set = new TreeSet(new RecordComparator(comparator));
    }

    protected void clear() {
        this.headRecord = new TableRecord(null);
        this.empty = true;
        this.count = 0;
        this.set.clear();
    }

    public void add(Object object) {
        TableRecord tableRecord = new TableRecord(object);
        if (this.empty) {
            this.headRecord = tableRecord;
            this.empty = false;
        } else {
            try {
                TableRecord tableRecord2 = this.set.headSet(tableRecord).last();
                if (tableRecord2.right != null) {
                    tableRecord2.right.left = tableRecord;
                }
                tableRecord.right = tableRecord2.right;
                tableRecord2.right = tableRecord;
                tableRecord.left = tableRecord2;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.headRecord.left = tableRecord;
                tableRecord.right = this.headRecord;
                this.headRecord = tableRecord;
            }
        }
        if (tableRecord.right == null) {
            this.tailRecord = tableRecord;
        }
        ++this.count;
        this.set.add(tableRecord);
    }

    public void remove(Object object) {
        if (!this.empty) {
            try {
                TableRecord tableRecord = this.set.tailSet(new TableRecord(object)).first();
                if (tableRecord != null) {
                    if (tableRecord == this.headRecord) {
                        if (tableRecord.right != null) {
                            this.headRecord = tableRecord.right;
                            this.headRecord.left = null;
                        } else {
                            this.tailRecord = this.headRecord = new TableRecord(null);
                            this.empty = true;
                        }
                    } else if (tableRecord == this.tailRecord) {
                        this.tailRecord = tableRecord.left;
                        this.tailRecord.right = null;
                    } else {
                        tableRecord.left.right = tableRecord.right;
                        tableRecord.right.left = tableRecord.left;
                    }
                    tableRecord.left = null;
                    tableRecord.right = null;
                }
                --this.count;
                this.set.remove(tableRecord);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public boolean contains(Object object) {
        boolean bl = false;
        if (!this.empty) {
            bl = this.set.contains(new TableRecord(object));
        }
        return bl;
    }

    public TableIterator iterator() {
        IteratorFromPositionToTableStart iteratorFromPositionToTableStart = this.empty ? new IteratorFromPositionToTableStart(null, null) : new IteratorFromPositionToTableStart(this.headRecord, this.headRecord);
        return iteratorFromPositionToTableStart;
    }

    public TableIterator reverseOrderIterator() {
        IteratorFromPositionToTableEnd iteratorFromPositionToTableEnd = this.empty ? new IteratorFromPositionToTableEnd(null, null) : new IteratorFromPositionToTableEnd(this.tailRecord, this.tailRecord);
        return iteratorFromPositionToTableEnd;
    }

    public TableIterator constrainedIteratorFromPositionToTableStart(WorkingMemory workingMemory, ColumnConstraints columnConstraints, Object object, Object object2) {
        return this.getIteratorFromPositionToTableStart(true, workingMemory, columnConstraints, object, object2);
    }

    public TableIterator iteratorFromPositionToTableStart(Object object, Object object2) {
        return this.getIteratorFromPositionToTableStart(false, null, null, object, object2);
    }

    public TableIterator iteratorFromPositionToTableEnd(Object object) {
        TableRecord tableRecord = null;
        try {
            tableRecord = this.set.headSet(new TableRecord(object)).last();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return new IteratorFromPositionToTableEnd(tableRecord, tableRecord);
    }

    private TableIterator getIteratorFromPositionToTableStart(boolean bl, WorkingMemory workingMemory, ColumnConstraints columnConstraints, Object object, Object object2) {
        TableRecord tableRecord = null;
        TableRecord tableRecord2 = null;
        TableRecord tableRecord3 = new TableRecord(object);
        if (!this.empty) {
            try {
                tableRecord = this.set.tailSet(tableRecord3).first();
                if (object == object2) {
                    tableRecord2 = tableRecord;
                } else {
                    try {
                        tableRecord2 = this.set.tailSet(new TableRecord(object2)).first();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        tableRecord2 = tableRecord;
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (bl) {
            return new ConstrainedIteratorFromPositionToTableStart(workingMemory, columnConstraints, tableRecord, tableRecord2);
        }
        return new IteratorFromPositionToTableStart(tableRecord, tableRecord2);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String toString() {
        String string = "";
        TableIterator tableIterator = this.iterator();
        while (tableIterator.hasNext()) {
            string = string + tableIterator.next() + "\n";
        }
        return string;
    }

    public int size() {
        return this.count;
    }

    public Object top() {
        return this.headRecord.object;
    }

    public Object bottom() {
        return this.tailRecord.object;
    }

    public static TableIterator singleItemIterator(Object object) {
        return new IteratorFromPositionToTableStart(new TableRecord(object));
    }
}

