/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.Serializable;
import java.util.Iterator;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.leaps.LeapsFactHandle;
import org.drools.leaps.LeapsRuleHandle;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.LeapsWorkingMemory;
import org.drools.leaps.util.TableIterator;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;

public class Token
implements Tuple,
Serializable {
    private static final long serialVersionUID = 1L;
    private LeapsWorkingMemory workingMemory;
    private final InternalFactHandle dominantFactHandle;
    private LeapsRuleHandle currentRuleHandle = null;
    private LeapsFactHandle[] currentFactHandles = new LeapsFactHandle[0];
    boolean resume = false;
    private Iterator rules = null;
    private final PropagationContext propagationContext;

    public Token(LeapsWorkingMemory leapsWorkingMemory, InternalFactHandle internalFactHandle, PropagationContext propagationContext) {
        this.workingMemory = leapsWorkingMemory;
        this.dominantFactHandle = internalFactHandle;
        this.propagationContext = propagationContext;
    }

    private Iterator rulesIterator() {
        if (this.rules == null && this.dominantFactHandle != null) {
            this.rules = this.workingMemory.getFactTable(this.dominantFactHandle.getObject().getClass()).getRulesIterator();
        }
        return this.rules;
    }

    public LeapsRuleHandle nextRuleHandle() {
        this.currentRuleHandle = (LeapsRuleHandle)this.rules.next();
        this.currentFactHandles = new LeapsFactHandle[this.currentRuleHandle.getLeapsRule().getNumberOfColumns()];
        return this.currentRuleHandle;
    }

    public boolean hasNextRuleHandle() {
        boolean bl = false;
        if (this.rulesIterator() != null) {
            long l = this.workingMemory.getIdLastFireAllAt();
            if (this.dominantFactHandle == null || this.dominantFactHandle.getRecency() >= l) {
                bl = this.rules.hasNext();
            } else {
                boolean bl2 = false;
                while (!bl2) {
                    if (this.rules.hasNext()) {
                        if (((LeapsRuleHandle)((TableIterator)this.rules).peekNext()).getRecency() > l) {
                            bl = true;
                            bl2 = true;
                            continue;
                        }
                        this.rules.next();
                        continue;
                    }
                    bl = false;
                    bl2 = true;
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        if (this.dominantFactHandle != null) {
            return this.dominantFactHandle.hashCode();
        }
        return 0;
    }

    public void set(int n, LeapsFactHandle leapsFactHandle) {
        this.currentFactHandles[n] = leapsFactHandle;
    }

    public InternalFactHandle getDominantFactHandle() {
        return this.dominantFactHandle;
    }

    public LeapsRuleHandle getCurrentRuleHandle() {
        return this.currentRuleHandle;
    }

    public boolean isResume() {
        return this.resume;
    }

    public void setResume(boolean bl) {
        this.resume = bl;
    }

    public boolean equals(Object object) {
        return this.dominantFactHandle.getId() == ((Token)object).dominantFactHandle.getId();
    }

    public InternalFactHandle get(int n) {
        return this.currentFactHandles[n];
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getColumn());
    }

    public InternalFactHandle[] getFactHandles() {
        return this.currentFactHandles;
    }

    public long getRecency() {
        return 0L;
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public String toString() {
        String string = "TOKEN [" + this.dominantFactHandle + "]\n" + "\tRULE : " + this.currentRuleHandle + "\n";
        if (this.currentFactHandles != null) {
            int n = this.currentFactHandles.length;
            for (int i = 0; i < n; ++i) {
                string = string + (i == this.currentRuleHandle.getDominantPosition() ? "***" : "") + "\t" + i + " -> " + this.currentFactHandles[i].getObject() + "\n";
            }
        }
        return string;
    }

    LeapsTuple getTuple() {
        return new LeapsTuple(this.currentFactHandles, this.currentRuleHandle.getLeapsRule(), this.propagationContext);
    }

    public boolean dependsOn(FactHandle factHandle) {
        int n = this.currentFactHandles.length;
        for (int i = 0; i < n; ++i) {
            if (!this.currentFactHandles[i].equals(factHandle)) continue;
            return true;
        }
        return false;
    }

    public void setActivation(Activation activation) {
    }

    public PropagationContext getPropagationContext() {
        return this.propagationContext;
    }
}

