/*
 * Decompiled with CFR 0.152.
 */
package org.drools.asm.tree.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.asm.Opcodes;
import org.drools.asm.Type;
import org.drools.asm.tree.AbstractInsnNode;
import org.drools.asm.tree.FieldInsnNode;
import org.drools.asm.tree.LdcInsnNode;
import org.drools.asm.tree.MethodInsnNode;
import org.drools.asm.tree.analysis.DataflowValue;
import org.drools.asm.tree.analysis.Interpreter;
import org.drools.asm.tree.analysis.SmallSet;
import org.drools.asm.tree.analysis.Value;

public class DataflowInterpreter
implements Opcodes,
Interpreter {
    public Value newValue(Type type) {
        return new DataflowValue(type == null ? 1 : type.getSize());
    }

    public Value newOperation(AbstractInsnNode abstractInsnNode) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                n = 2;
                break;
            }
            case 18: {
                Object object = ((LdcInsnNode)abstractInsnNode).cst;
                n = object instanceof Long || object instanceof Double ? 2 : 1;
                break;
            }
            case 178: {
                n = Type.getType(((FieldInsnNode)abstractInsnNode).desc).getSize();
                break;
            }
            default: {
                n = 1;
            }
        }
        return new DataflowValue(n, abstractInsnNode);
    }

    public Value copyOperation(AbstractInsnNode abstractInsnNode, Value value) {
        return new DataflowValue(value.getSize(), abstractInsnNode);
    }

    public Value unaryOperation(AbstractInsnNode abstractInsnNode, Value value) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                n = 2;
                break;
            }
            case 180: {
                n = Type.getType(((FieldInsnNode)abstractInsnNode).desc).getSize();
                break;
            }
            default: {
                n = 1;
            }
        }
        return new DataflowValue(n, abstractInsnNode);
    }

    public Value binaryOperation(AbstractInsnNode abstractInsnNode, Value value, Value value2) {
        int n;
        switch (abstractInsnNode.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                n = 2;
                break;
            }
            default: {
                n = 1;
            }
        }
        return new DataflowValue(n, abstractInsnNode);
    }

    public Value ternaryOperation(AbstractInsnNode abstractInsnNode, Value value, Value value2, Value value3) {
        return new DataflowValue(1, abstractInsnNode);
    }

    public Value naryOperation(AbstractInsnNode abstractInsnNode, List list) {
        int n = abstractInsnNode.getOpcode() == 197 ? 1 : Type.getReturnType(((MethodInsnNode)abstractInsnNode).desc).getSize();
        return new DataflowValue(n, abstractInsnNode);
    }

    public Value merge(Value value, Value value2) {
        DataflowValue dataflowValue = (DataflowValue)value;
        DataflowValue dataflowValue2 = (DataflowValue)value2;
        if (dataflowValue.insns instanceof SmallSet && dataflowValue2.insns instanceof SmallSet) {
            Set set = ((SmallSet)dataflowValue.insns).union((SmallSet)dataflowValue2.insns);
            if (set == dataflowValue.insns && dataflowValue.size == dataflowValue2.size) {
                return value;
            }
            return new DataflowValue(Math.min(dataflowValue.size, dataflowValue2.size), set);
        }
        if (dataflowValue.size != dataflowValue2.size || !dataflowValue.insns.containsAll(dataflowValue2.insns)) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(dataflowValue.insns);
            hashSet.addAll(dataflowValue2.insns);
            return new DataflowValue(Math.min(dataflowValue.size, dataflowValue2.size), hashSet);
        }
        return value;
    }
}

