/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.drools.QueryResult;
import org.drools.WorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Query;
import org.drools.spi.Tuple;

public class QueryResults {
    private Query query;
    private Map declarations;
    protected List results;
    protected WorkingMemory workingMemory;

    public QueryResults(List list, Query query, WorkingMemory workingMemory) {
        this.results = list;
        this.query = query;
        this.workingMemory = workingMemory;
    }

    public QueryResult get(int n) {
        if (n > this.results.size()) {
            throw new NoSuchElementException();
        }
        return new QueryResult((Tuple)this.results.get(n), this.workingMemory, this);
    }

    public Iterator iterator() {
        return new QueryResultsIterator(this.results.iterator());
    }

    public Map getDeclarations() {
        Declaration[] declarationArray = this.query.getDeclarations();
        HashMap<String, Declaration> hashMap = new HashMap<String, Declaration>(declarationArray.length);
        int n = declarationArray.length;
        for (int i = 0; i < n; ++i) {
            hashMap.put(declarationArray[i].getIdentifier(), declarationArray[i]);
        }
        this.declarations = hashMap;
        return this.declarations;
    }

    public int size() {
        return this.results.size();
    }

    class QueryResultsIterator
    implements Iterator {
        private Iterator iterator;

        public QueryResultsIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return new QueryResult((Tuple)this.iterator.next(), QueryResults.this.workingMemory, QueryResults.this);
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

