/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.CallStack;
import bsh.CommandLineReader;
import bsh.ConsoleInterface;
import bsh.EvalError;
import bsh.InterpreterError;
import bsh.JJTParserState;
import bsh.JavaCharStream;
import bsh.LHS;
import bsh.Name;
import bsh.NameSpace;
import bsh.ParseException;
import bsh.Parser;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.This;
import bsh.TokenMgrError;
import bsh.UtilEvalError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;

public class Interpreter
implements Runnable,
ConsoleInterface,
Serializable {
    public static final String VERSION = "1.3.0";
    public static boolean DEBUG;
    public static boolean TRACE;
    public static boolean LOCALSCOPING;
    static transient PrintStream debug;
    static String systemLineSeparator;
    static This sharedObject;
    private boolean strictJava = false;
    transient Parser parser;
    NameSpace globalNameSpace;
    transient Reader in;
    transient PrintStream out;
    transient PrintStream err;
    ConsoleInterface console;
    Interpreter parent;
    String sourceFileInfo;
    private boolean exitOnEOF = true;
    protected boolean evalOnly;
    protected boolean interactive;

    public Interpreter(Reader reader, PrintStream printStream, PrintStream printStream2, boolean bl, NameSpace nameSpace, Interpreter interpreter, String string) {
        this.parser = new Parser(reader);
        long l = System.currentTimeMillis();
        this.in = reader;
        this.out = printStream;
        this.err = printStream2;
        this.interactive = bl;
        debug = printStream2;
        this.parent = interpreter;
        if (interpreter != null) {
            this.setStrictJava(interpreter.getStrictJava());
        }
        this.sourceFileInfo = string;
        this.globalNameSpace = nameSpace == null ? new NameSpace(BshClassManager.createClassManager(), "global") : nameSpace;
        if (!(this.getu("bsh") instanceof This)) {
            this.initRootSystemObject();
        }
        if (bl) {
            this.loadRCFiles();
        }
        long l2 = System.currentTimeMillis();
        if (DEBUG) {
            Interpreter.debug("Time to initialize interpreter: " + (l2 - l));
        }
    }

    public Interpreter(Reader reader, PrintStream printStream, PrintStream printStream2, boolean bl, NameSpace nameSpace) {
        this(reader, printStream, printStream2, bl, nameSpace, null, null);
    }

    public Interpreter(Reader reader, PrintStream printStream, PrintStream printStream2, boolean bl) {
        this(reader, printStream, printStream2, bl, null);
    }

    public Interpreter(ConsoleInterface consoleInterface, NameSpace nameSpace) {
        this(consoleInterface.getIn(), consoleInterface.getOut(), consoleInterface.getErr(), true, nameSpace);
        this.setConsole(consoleInterface);
    }

    public Interpreter(ConsoleInterface consoleInterface) {
        this(consoleInterface, null);
    }

    public Interpreter() {
        this(new StringReader(""), System.out, System.err, false, null);
        this.evalOnly = true;
        this.setu("bsh.evalOnly", new Primitive(true));
    }

    public void setConsole(ConsoleInterface consoleInterface) {
        this.console = consoleInterface;
        this.setu("bsh.console", consoleInterface);
        this.setOut(consoleInterface.getOut());
        this.setErr(consoleInterface.getErr());
    }

    private void initRootSystemObject() {
        BshClassManager bshClassManager = this.getClassManager();
        this.setu("bsh", new NameSpace(bshClassManager, "Bsh Object").getThis(this));
        if (sharedObject == null) {
            sharedObject = new NameSpace(bshClassManager, "Bsh Shared System Object").getThis(this);
        }
        this.setu("bsh.system", sharedObject);
        this.setu("bsh.shared", sharedObject);
        This this_ = new NameSpace(bshClassManager, "Bsh Command Help Text").getThis(this);
        this.setu("bsh.help", this_);
        try {
            this.setu("bsh.cwd", System.getProperty("user.dir"));
        }
        catch (SecurityException securityException) {
            this.setu("bsh.cwd", ".");
        }
        this.setu("bsh.interactive", new Primitive(this.interactive));
        this.setu("bsh.evalOnly", new Primitive(this.evalOnly));
    }

    public void setNameSpace(NameSpace nameSpace) {
        this.globalNameSpace = nameSpace;
    }

    public NameSpace getNameSpace() {
        return this.globalNameSpace;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            String[] stringArray2;
            String string = stringArray[0];
            if (stringArray.length > 1) {
                stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
            } else {
                stringArray2 = new String[]{};
            }
            Interpreter interpreter = new Interpreter();
            interpreter.setu("bsh.args", stringArray2);
            try {
                interpreter.source(string, interpreter.globalNameSpace);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File not found: " + fileNotFoundException);
            }
            catch (TargetError targetError) {
                System.out.println("Script threw exception: " + targetError);
                if (targetError.inNativeCode()) {
                    targetError.printStackTrace(DEBUG, System.err);
                }
            }
            catch (EvalError evalError) {
                System.out.println("Evaluation Error: " + evalError);
            }
            catch (IOException iOException) {
                System.out.println("I/O Error: " + iOException);
            }
        } else {
            InputStream inputStream = System.getProperty("os.name").startsWith("Windows") && System.getProperty("java.version").startsWith("1.1.") ? new FilterInputStream(System.in){

                public int available() throws IOException {
                    return 0;
                }
            } : System.in;
            CommandLineReader commandLineReader = new CommandLineReader(new InputStreamReader(inputStream));
            Interpreter interpreter = new Interpreter(commandLineReader, System.out, System.err, true);
            interpreter.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.evalOnly) {
            throw new RuntimeException("bsh Interpreter: No stream");
        }
        if (this.interactive) {
            try {
                this.eval("printBanner();");
            }
            catch (EvalError evalError) {
                this.println("BeanShell 1.3.0 - by Pat Niemeyer (pat@pat.net)");
            }
        }
        CallStack callStack = new CallStack(this.globalNameSpace);
        boolean bl = false;
        while (!bl) {
            Object var7_13;
            try {
                block32: {
                    try {
                        System.out.flush();
                        System.err.flush();
                        Thread.yield();
                        if (this.interactive) {
                            this.print(this.getBshPrompt());
                        }
                        bl = this.Line();
                        if (this.get_jjtree().nodeArity() <= 0) break block32;
                        SimpleNode simpleNode = (SimpleNode)this.get_jjtree().rootNode();
                        if (DEBUG) {
                            simpleNode.dump(">");
                        }
                        Object object = simpleNode.eval(callStack, this);
                        if (callStack.depth() > 1) {
                            throw new InterpreterError("Callstack growing: " + callStack);
                        }
                        if (object instanceof ReturnControl) {
                            object = ((ReturnControl)object).value;
                        }
                        if (object == Primitive.VOID) break block32;
                        this.setu("$_", object);
                        Object object2 = this.getu("bsh.show");
                        if (!(object2 instanceof Boolean) || !((Boolean)object2).booleanValue()) break block32;
                        this.println("<" + object + ">");
                    }
                    catch (ParseException parseException) {
                        this.error("Parser Error: " + parseException.getMessage(DEBUG));
                        if (DEBUG) {
                            parseException.printStackTrace();
                        }
                        if (!this.interactive) {
                            bl = true;
                        }
                        this.parser.reInitInput(this.in);
                        var7_13 = null;
                        this.get_jjtree().reset();
                        if (callStack.depth() <= 1) continue;
                        callStack.clear();
                        callStack.push(this.globalNameSpace);
                        continue;
                    }
                    catch (InterpreterError interpreterError) {
                        this.error("Internal Error: " + interpreterError.getMessage());
                        interpreterError.printStackTrace();
                        if (!this.interactive) {
                            bl = true;
                        }
                        var7_13 = null;
                        this.get_jjtree().reset();
                        if (callStack.depth() <= 1) continue;
                        callStack.clear();
                        callStack.push(this.globalNameSpace);
                        continue;
                    }
                    catch (TargetError targetError) {
                        this.error("// Uncaught Exception: " + targetError);
                        if (targetError.inNativeCode()) {
                            targetError.printStackTrace(DEBUG, this.err);
                        }
                        if (!this.interactive) {
                            bl = true;
                        }
                        this.setu("$_e", targetError.getTarget());
                        var7_13 = null;
                        this.get_jjtree().reset();
                        if (callStack.depth() <= 1) continue;
                        callStack.clear();
                        callStack.push(this.globalNameSpace);
                        continue;
                    }
                    catch (EvalError evalError) {
                        if (this.interactive) {
                            this.error("EvalError: " + evalError.toString());
                        } else {
                            this.error("EvalError: " + evalError.getMessage());
                        }
                        if (DEBUG) {
                            evalError.printStackTrace();
                        }
                        if (!this.interactive) {
                            bl = true;
                        }
                        var7_13 = null;
                        this.get_jjtree().reset();
                        if (callStack.depth() <= 1) continue;
                        callStack.clear();
                        callStack.push(this.globalNameSpace);
                        continue;
                    }
                    catch (Exception exception) {
                        this.error("Unknown error: " + exception);
                        if (DEBUG) {
                            exception.printStackTrace();
                        }
                        if (!this.interactive) {
                            bl = true;
                        }
                        var7_13 = null;
                        this.get_jjtree().reset();
                        if (callStack.depth() <= 1) continue;
                        callStack.clear();
                        callStack.push(this.globalNameSpace);
                        continue;
                    }
                    catch (TokenMgrError tokenMgrError) {
                        this.error("Error parsing input: " + tokenMgrError);
                        this.parser.reInitTokenInput(this.in);
                        if (!this.interactive) {
                            bl = true;
                        }
                        var7_13 = null;
                        this.get_jjtree().reset();
                        if (callStack.depth() <= 1) continue;
                        callStack.clear();
                        callStack.push(this.globalNameSpace);
                        continue;
                    }
                }
                var7_13 = null;
                this.get_jjtree().reset();
                if (callStack.depth() <= 1) continue;
                callStack.clear();
                callStack.push(this.globalNameSpace);
            }
            catch (Throwable throwable) {
                var7_13 = null;
                this.get_jjtree().reset();
                if (callStack.depth() > 1) {
                    callStack.clear();
                    callStack.push(this.globalNameSpace);
                }
                throw throwable;
            }
        }
        if (this.interactive && this.exitOnEOF) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object source(String string, NameSpace nameSpace) throws FileNotFoundException, IOException, EvalError {
        File file = this.pathToFile(string);
        if (DEBUG) {
            Interpreter.debug("Sourcing file: " + file);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            Object object = this.eval(bufferedReader, nameSpace, string);
            return object;
        }
        finally {
            ((Reader)bufferedReader).close();
        }
    }

    public Object source(String string) throws FileNotFoundException, IOException, EvalError {
        return this.source(string, this.globalNameSpace);
    }

    public Object eval(Reader reader, NameSpace nameSpace, String string) throws EvalError {
        Object object = null;
        if (DEBUG) {
            Interpreter.debug("eval: nameSpace = " + nameSpace);
        }
        Interpreter interpreter = new Interpreter(reader, this.out, this.err, false, nameSpace, this, string);
        CallStack callStack = new CallStack(nameSpace);
        boolean bl = false;
        while (!bl) {
            Object var11_16;
            SimpleNode simpleNode = null;
            try {
                block19: {
                    try {
                        bl = interpreter.Line();
                        if (interpreter.get_jjtree().nodeArity() <= 0) break block19;
                        simpleNode = (SimpleNode)interpreter.get_jjtree().rootNode();
                        simpleNode.setSourceFile(string);
                        if (TRACE) {
                            this.println("// " + simpleNode.getText());
                        }
                        object = simpleNode.eval(callStack, interpreter);
                        if (callStack.depth() > 1) {
                            throw new InterpreterError("Callstack growing: " + callStack);
                        }
                        if (!(object instanceof ReturnControl)) break block19;
                        object = ((ReturnControl)object).value;
                        var11_16 = null;
                    }
                    catch (ParseException parseException) {
                        if (DEBUG) {
                            this.error(parseException.getMessage(DEBUG));
                        }
                        parseException.setErrorSourceFile(string);
                        throw parseException;
                    }
                    catch (InterpreterError interpreterError) {
                        interpreterError.printStackTrace();
                        throw new EvalError("Sourced file: " + string + " internal Error: " + interpreterError.getMessage(), simpleNode, callStack);
                    }
                    catch (TargetError targetError) {
                        if (targetError.getNode() == null) {
                            targetError.setNode(simpleNode);
                        }
                        targetError.reThrow("Sourced file: " + string);
                        var11_16 = null;
                        interpreter.get_jjtree().reset();
                        if (callStack.depth() <= 1) continue;
                        callStack.clear();
                        callStack.push(nameSpace);
                        continue;
                    }
                    catch (EvalError evalError) {
                        if (DEBUG) {
                            evalError.printStackTrace();
                        }
                        if (evalError.getNode() == null) {
                            evalError.setNode(simpleNode);
                        }
                        evalError.reThrow("Sourced file: " + string);
                        var11_16 = null;
                        interpreter.get_jjtree().reset();
                        if (callStack.depth() <= 1) continue;
                        callStack.clear();
                        callStack.push(nameSpace);
                        continue;
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            exception.printStackTrace();
                        }
                        throw new EvalError("Sourced file: " + string + " unknown error: " + exception.getMessage(), simpleNode, callStack);
                    }
                    catch (TokenMgrError tokenMgrError) {
                        throw new EvalError("Sourced file: " + string + " Token Parsing Error: " + tokenMgrError.getMessage(), simpleNode, callStack);
                    }
                    interpreter.get_jjtree().reset();
                    if (callStack.depth() <= 1) break;
                    callStack.clear();
                    callStack.push(nameSpace);
                    {
                        break;
                    }
                }
                var11_16 = null;
                interpreter.get_jjtree().reset();
                if (callStack.depth() <= 1) continue;
                callStack.clear();
                callStack.push(nameSpace);
            }
            catch (Throwable throwable) {
                var11_16 = null;
                interpreter.get_jjtree().reset();
                if (callStack.depth() > 1) {
                    callStack.clear();
                    callStack.push(nameSpace);
                }
                throw throwable;
            }
        }
        return Primitive.unwrap(object);
    }

    public Object eval(Reader reader) throws EvalError {
        return this.eval(reader, this.globalNameSpace, "eval stream");
    }

    public Object eval(String string) throws EvalError {
        if (DEBUG) {
            Interpreter.debug("eval(String): " + string);
        }
        return this.eval(string, this.globalNameSpace);
    }

    public Object eval(String string, NameSpace nameSpace) throws EvalError {
        String string2 = string.endsWith(";") ? string : string + ";";
        return this.eval(new StringReader(string2), nameSpace, "inline evaluation of: ``" + this.showEvalString(string2) + "''");
    }

    private String showEvalString(String string) {
        string = string.replace('\n', ' ');
        if ((string = string.replace('\r', ' ')).length() > 80) {
            string = string.substring(0, 80) + " . . . ";
        }
        return string;
    }

    public final void error(String string) {
        if (this.console != null) {
            this.console.error("// Error: " + string + "\n");
        } else {
            this.err.println("// Error: " + string);
            this.err.flush();
        }
    }

    public Reader getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public final void println(String string) {
        this.print(string + systemLineSeparator);
    }

    public final void print(String string) {
        if (this.console != null) {
            this.console.print(string);
        } else {
            this.out.print(string);
            this.out.flush();
        }
    }

    public static final void debug(String string) {
        if (DEBUG) {
            debug.println("// Debug: " + string);
        }
    }

    public Object get(String string) throws EvalError {
        try {
            Object object = this.globalNameSpace.get(string, this);
            return Primitive.unwrap(object);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(SimpleNode.JAVACODE, new CallStack());
        }
    }

    Object getu(String string) {
        try {
            return this.get(string);
        }
        catch (EvalError evalError) {
            throw new InterpreterError("set: " + evalError);
        }
    }

    public void set(String string, Object object) throws EvalError {
        if (object == null) {
            object = Primitive.NULL;
        }
        CallStack callStack = new CallStack();
        try {
            if (Name.isCompound(string)) {
                LHS lHS = this.globalNameSpace.getNameResolver(string).toLHS(callStack, this);
                lHS.assign(object, false);
            } else {
                this.globalNameSpace.setVariable(string, object, false);
            }
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(SimpleNode.JAVACODE, callStack);
        }
    }

    void setu(String string, Object object) {
        try {
            this.set(string, object);
        }
        catch (EvalError evalError) {
            throw new InterpreterError("set: " + evalError);
        }
    }

    public void set(String string, long l) throws EvalError {
        this.set(string, new Primitive(l));
    }

    public void set(String string, int n) throws EvalError {
        this.set(string, new Primitive(n));
    }

    public void set(String string, double d) throws EvalError {
        this.set(string, new Primitive(d));
    }

    public void set(String string, float f) throws EvalError {
        this.set(string, new Primitive(f));
    }

    public void set(String string, boolean bl) throws EvalError {
        this.set(string, new Primitive(bl));
    }

    public void unset(String string) throws EvalError {
        CallStack callStack = new CallStack();
        try {
            LHS lHS = this.globalNameSpace.getNameResolver(string).toLHS(callStack, this);
            if (lHS.type != 0) {
                throw new EvalError("Can't unset, not a variable: " + string, SimpleNode.JAVACODE, new CallStack());
            }
            lHS.nameSpace.unsetVariable(string);
        }
        catch (UtilEvalError utilEvalError) {
            throw new EvalError(utilEvalError.getMessage(), SimpleNode.JAVACODE, new CallStack());
        }
    }

    public Object getInterface(Class clazz) throws EvalError {
        try {
            return this.globalNameSpace.getThis(this).getInterface(clazz);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(SimpleNode.JAVACODE, new CallStack());
        }
    }

    private JJTParserState get_jjtree() {
        return this.parser.jjtree;
    }

    private JavaCharStream get_jj_input_stream() {
        return this.parser.jj_input_stream;
    }

    private boolean Line() throws ParseException {
        return this.parser.Line();
    }

    void loadRCFiles() {
        block2: {
            try {
                String string = System.getProperty("user.home") + File.separator + ".bshrc";
                this.source(string, this.globalNameSpace);
            }
            catch (Exception exception) {
                if (!DEBUG) break block2;
                Interpreter.debug("Could not find rc file: " + exception);
            }
        }
    }

    public File pathToFile(String string) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            String string2 = (String)this.getu("bsh.cwd");
            file = new File(string2 + File.separator + string);
        }
        return new File(file.getCanonicalPath());
    }

    public static void redirectOutputToFile(String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            System.setOut(printStream);
            System.setErr(printStream);
        }
        catch (IOException iOException) {
            System.err.println("Can't redirect output to file: " + string);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.getClassManager().setClassLoader(classLoader);
    }

    public BshClassManager getClassManager() {
        return this.getNameSpace().getClassManager();
    }

    public void setStrictJava(boolean bl) {
        this.strictJava = bl;
    }

    public boolean getStrictJava() {
        return this.strictJava;
    }

    static void staticInit() {
        try {
            systemLineSeparator = System.getProperty("line.separator");
            debug = System.err;
            DEBUG = Boolean.getBoolean("debug");
            TRACE = Boolean.getBoolean("trace");
            LOCALSCOPING = Boolean.getBoolean("localscoping");
            String string = System.getProperty("outfile");
            if (string != null) {
                Interpreter.redirectOutputToFile(string);
            }
        }
        catch (SecurityException securityException) {
            System.err.println("Could not init static:" + securityException);
        }
        catch (Exception exception) {
            System.err.println("Could not init static(2):" + exception);
        }
        catch (Throwable throwable) {
            System.err.println("Could not init static(3):" + throwable);
        }
    }

    public String getSourceFileInfo() {
        if (this.sourceFileInfo != null) {
            return this.sourceFileInfo;
        }
        return "<unknown source>";
    }

    public Interpreter getParent() {
        return this.parent;
    }

    public void setOut(PrintStream printStream) {
        this.out = printStream;
    }

    public void setErr(PrintStream printStream) {
        this.err = printStream;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.console != null) {
            this.setOut(this.console.getOut());
            this.setErr(this.console.getErr());
        } else {
            this.setOut(System.out);
            this.setErr(System.err);
        }
    }

    private String getBshPrompt() {
        try {
            return (String)this.eval("getBshPrompt()");
        }
        catch (Exception exception) {
            return "bsh % ";
        }
    }

    public void setExitOnEOF(boolean bl) {
        this.exitOnEOF = bl;
    }

    static {
        systemLineSeparator = "\n";
        Interpreter.staticInit();
    }
}

