/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.renderer.AjaxComponentRendererBase;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.renderer.RendererBase;
import org.ajax4jsf.framework.renderer.compiler.HtmlCompiler;
import org.ajax4jsf.framework.renderer.compiler.PreparedTemplate;
import org.ajax4jsf.framework.renderer.compiler.TemplateContext;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.PrototypeScript;
import org.ajax4jsf.framework.resource.SmartPositionScript;
import org.ajax4jsf.framework.resource.TemplateCSSResource;
import org.ajax4jsf.framework.skin.Skin;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.ajax4jsf.framework.util.javascript.JSFunctionDefinition;
import org.richfaces.component.AjaxSuggestionEvent;
import org.richfaces.component.UISuggestionBox;
import org.richfaces.component.util.FormUtil;

public class SuggestionBoxRenderer
extends AjaxComponentRendererBase {
    private static final String[] OPTIONS = new String[]{"popupClass", "popupStyle", "width", "height", "entryClass", "selectedClass", "param", "frequency", "minChars", "tokens", "rows"};
    public static final int SHADOW_DEPTH = 4;
    private InternetResource[] styles = new InternetResource[]{new TemplateCSSResource("org/richfaces/renderkit/html/css/suggestionbox.xcss")};
    private final InternetResource[] additionalScripts = new InternetResource[]{new PrototypeScript(), new SmartPositionScript(), this.getResource("/org/richfaces/renderkit/html/scripts/browser_info.js"), this.getResource("scripts/scriptaculo.js"), this.getResource("scripts/suggestionbox.js")};
    private PreparedTemplate body = HtmlCompiler.compileResource((String)"org/richfaces/renderkit/html/templates/table.jspx");
    private PreparedTemplate popup = HtmlCompiler.compileResource((String)"org/richfaces/renderkit/html/templates/popup.jspx");
    static /* synthetic */ Class class$org$richfaces$component$UISuggestionBox;

    protected final Class getComponentClass() {
        return class$org$richfaces$component$UISuggestionBox == null ? (class$org$richfaces$component$UISuggestionBox = SuggestionBoxRenderer.class$("org.richfaces.component.UISuggestionBox")) : class$org$richfaces$component$UISuggestionBox;
    }

    public final boolean getRendersChildren() {
        return true;
    }

    protected final void doDecode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String reqValue = (String)requestParameterMap.get(clientId);
        if (reqValue != null && reqValue.equals(clientId)) {
            String paramName = (String)component.getAttributes().get("param");
            if (null == paramName) {
                paramName = "inputvalue";
            }
            Object elementValue = requestParameterMap.get(paramName);
            ((UISuggestionBox)component).setSubmitedValue(elementValue);
            component.queueEvent((FacesEvent)new AjaxSuggestionEvent(component, elementValue));
        }
    }

    protected final void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeBegin(writer, context, component);
        FormUtil.throwEnclFormReqExceptionIfNeed(context, component);
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UISuggestionBox suggestionBox = (UISuggestionBox)component;
        if (!suggestionBox.isSubmitted()) {
            suggestionBox.setRowIndex(-1);
            writer.startElement("div", component);
            this.getUtils().encodeId(context, component);
            Map attributes = component.getAttributes();
            StringBuffer clazz = new StringBuffer("dr-sb-common-container rich-sb-common-container");
            Object popupClass = attributes.get("popupClass");
            if (null != popupClass) {
                clazz.append(" ").append(popupClass);
            }
            writer.writeAttribute("class", (Object)clazz, "popupClass");
            int zIndex = suggestionBox.getZindex();
            StringBuffer style = new StringBuffer("display:none; z-index: " + (zIndex + 1) + ";");
            style.append(this.getSizeForStyle(component, "width", null, false));
            style.append(this.getSizeForStyle(component, "height", null, false));
            Object popupStyle = attributes.get("popupStyle");
            if (null != popupStyle) {
                style.append(popupStyle);
            }
            writer.writeAttribute("style", (Object)style, "popupStyle");
            UIComponent popupFacet = component.getFacet("popup");
            if (null == popupFacet) {
                this.popup.encode((RendererBase)this, context, component);
            } else {
                this.renderChild(context, popupFacet);
            }
            writer.startElement("script", component);
            writer.writeText((Object)this.getScript(context, component), "script");
            writer.endElement("script");
            writer.endElement("div");
            writer.startElement("iframe", component);
            writer.writeAttribute("src", (Object)this.getResource("/org/richfaces/renderkit/html/images/spacer.gif").getUri(context, null), null);
            writer.writeAttribute("id", (Object)(component.getClientId(context) + "_iframe"), null);
            writer.writeAttribute("style", (Object)("position:absolute;display:none;z-index:" + zIndex + ";"), null);
            writer.endElement("iframe");
        } else {
            suggestionBox.setSubmitted(false);
        }
        ((UISuggestionBox)component).setValue(null);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UISuggestionBox suggestionBox = (UISuggestionBox)component;
        if (suggestionBox.isSubmitted()) {
            Object value = suggestionBox.getSubmitedValue();
            MethodBinding suggestingAction = suggestionBox.getSuggestionAction();
            if (null != suggestingAction) {
                suggestionBox.setValue(suggestingAction.invoke(context, new Object[]{value}));
            }
            this.body.encode(this.getTemplateContext(context, suggestionBox));
            suggestionBox.setRowIndex(-1);
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
            ajaxContext.removeRenderedArea(component.getClientId(context));
            ajaxContext.addRenderedArea(this.getContentId(context, component));
        }
    }

    private UIComponent getTarget(UIComponent component) {
        String target = ((UISuggestionBox)component).getFor();
        if (null != target) {
            UIComponent targetComponent = component.getParent().findComponent(target);
            if (null != targetComponent) {
                return targetComponent;
            }
            throw new FacesException("Component for target " + target + " not found in SuggestionBox " + component.getId());
        }
        throw new FacesException("Component SuggestionBox " + component.getId() + " don't have property 'for' ");
    }

    private String getScript(FacesContext context, UIComponent component) {
        String onselect;
        Map attributes = component.getAttributes();
        StringBuffer script = new StringBuffer(" new ");
        JSFunction submitSuggest = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context, (String)"RichFaces.Suggestion");
        UIComponent targetComponent = this.getTarget(component);
        submitSuggest.addParameter((Object)targetComponent.getClientId(context));
        submitSuggest.addParameter((Object)component.getClientId(context));
        submitSuggest.addParameter(component.getAttributes().get("onsubmit"));
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        options.put("popup", component.getClientId(context));
        for (int i = 0; i < OPTIONS.length; ++i) {
            String option = OPTIONS[i];
            Object value = attributes.get(option);
            if (null == value) continue;
            options.put(option, value);
        }
        String eventsQueue = (String)options.get("eventsQueue");
        if (null == eventsQueue) {
            options.put("eventsQueue", component.getClientId(context));
        }
        if (null != (onselect = (String)attributes.get("onselect"))) {
            JSFunctionDefinition function = new JSFunctionDefinition((Object)"suggestion");
            function.addParameter((Object)"event");
            function.addToBody((Object)onselect);
            options.put("onselect", function);
        }
        if (component.getValueBinding("fetchValue") != null || attributes.get("fetchValue") != null) {
            options.put("select", attributes.get("selectValueClass"));
        }
        submitSuggest.addParameter((Object)options);
        script.append(submitSuggest.toScript()).append(";\n");
        return script.toString();
    }

    private TemplateContext getTemplateContext(FacesContext context, UIData data) {
        data.setRowIndex(-1);
        return new DataTemplateContext((RendererBase)this, context, (UIComponent)data);
    }

    public final String opacityStyle(FacesContext context, UIComponent component) {
        String filterOpacity;
        String opacity = (String)component.getAttributes().get("shadowOpacity");
        if (null == opacity) {
            Skin skin = SkinFactory.getInstance().getSkin(context);
            opacity = (String)skin.getParameter(context, "shadowOpacity");
        }
        try {
            Double op = Double.valueOf(opacity);
            filterOpacity = Integer.toString(op.intValue() * 10);
            opacity = Double.toString(op / 10.0);
        }
        catch (Exception e) {
            return ";";
        }
        return "opacity:" + opacity + "; filter:alpha(opacity=" + filterOpacity + ");";
    }

    public final String border(FacesContext context, UIComponent component) {
        String border = (String)component.getAttributes().get("border");
        String frame = (String)component.getAttributes().get("frame");
        if (null == frame) {
            frame = "box";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (null != border && Pattern.matches("\\d*", border)) {
            border = border + "px";
        }
        boolean top = false;
        boolean right = false;
        boolean bottom = false;
        boolean left = false;
        if (frame.equalsIgnoreCase("above")) {
            top = true;
        } else if (frame.equalsIgnoreCase("below")) {
            bottom = true;
        } else if (frame.equalsIgnoreCase("hsides")) {
            top = true;
            bottom = true;
        } else if (frame.equalsIgnoreCase("lhs")) {
            left = true;
        } else if (frame.equalsIgnoreCase("rhs")) {
            right = true;
        } else if (frame.equalsIgnoreCase("vsides")) {
            right = true;
            left = true;
        } else {
            top = true;
            right = true;
            bottom = true;
            left = true;
        }
        stringBuffer.append("; border-width:");
        if (top) {
            stringBuffer.append(" ").append(border).append(" ");
        } else {
            stringBuffer.append(" 0px ");
        }
        if (right) {
            stringBuffer.append(" ").append(border).append(" ");
        } else {
            stringBuffer.append(" 0px ");
        }
        if (bottom) {
            stringBuffer.append(" ").append(border).append(" ");
        } else {
            stringBuffer.append(" 0px ");
        }
        if (left) {
            stringBuffer.append(" ").append(border).append(" ");
        } else {
            stringBuffer.append(" 0px ");
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    public final String bgcolor(FacesContext context, UIComponent component) {
        String bgcolor = (String)component.getAttributes().get("bgcolor");
        if (bgcolor != null) {
            return "background-color: " + bgcolor + ";";
        }
        return ";";
    }

    public final String cellPadding(FacesContext context, UIComponent component) {
        UISuggestionBox box = (UISuggestionBox)component;
        String cp = box.getCellpadding();
        if (cp != null) {
            return "padding: " + this.getUtils().encodePctOrPx(cp) + ";";
        }
        return ";";
    }

    public final String getBorder(FacesContext context, UIComponent component) {
        String border = (String)component.getAttributes().get("border");
        if (border == null || border.length() == 0) {
            return "0";
        }
        return border;
    }

    public final String getContentId(FacesContext context, UIComponent component) {
        return component.getClientId(context) + ':' + "suggest";
    }

    public final String overflowSize(FacesContext context, UIComponent component) {
        StringBuffer style = new StringBuffer();
        style.append(this.getSizeForStyle(component, "width", null, true));
        style.append(this.getSizeForStyle(component, "height", null, true));
        return style.toString();
    }

    public final String shadowDepth(FacesContext context, UIComponent component) {
        String shadow = (String)component.getAttributes().get("shadowDepth");
        if (shadow == null) {
            shadow = Integer.toString(4);
        }
        return "top: " + shadow + "; left: " + shadow;
    }

    protected final InternetResource[] getAdditionalScripts() {
        return this.additionalScripts;
    }

    protected final InternetResource[] getStyles() {
        return this.styles;
    }

    private String getSizeForStyle(UIComponent component, String attr, String def, boolean isShadow) {
        Map attributes = component.getAttributes();
        StringBuffer style = new StringBuffer();
        String attribute = (String)attributes.get(attr);
        if (attribute == null && def != null) {
            attribute = def;
        }
        if (attribute != null && !attribute.equals("")) {
            if (isShadow) {
                attribute = String.valueOf(Integer.parseInt(attribute) - 4);
            }
            style.append(attr).append(":").append(attribute);
            if (Pattern.matches("\\d*", attribute)) {
                style.append("px");
            }
            style.append(";");
        }
        return style.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DataTemplateContext
    extends TemplateContext {
        private List columns;
        private int first;
        private int last;
        private int rows;
        private int rowCount;
        private int current;
        private String[] rowClasses = new String[0];
        private String entryClass;

        public DataTemplateContext(RendererBase renderer, FacesContext facesContext, UIComponent component) {
            super(renderer, facesContext, component);
            if (component.getFacet("head") != null) {
                this.putParameter("hasHead", Boolean.TRUE);
            }
            if (component.getFacet("head") != null) {
                this.putParameter("hasHead", Boolean.TRUE);
            }
            this.columns = new ArrayList(component.getChildCount());
            Iterator iter = component.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent column = (UIComponent)iter.next();
                if (!(column instanceof UIColumn)) continue;
                this.columns.add(column);
                if (column.getFacet("head") != null) {
                    this.putParameter("hasHead", Boolean.TRUE);
                    this.putParameter("hasColumnHead", Boolean.TRUE);
                }
                if (column.getFacet("footer") == null) continue;
                this.putParameter("hasFooter", Boolean.TRUE);
                this.putParameter("hasColumnFooter", Boolean.TRUE);
            }
            UISuggestionBox box = (UISuggestionBox)component;
            this.first = box.getFirst();
            this.rows = box.getRows();
            this.rowCount = box.getRowCount();
            if (this.rows > 0) {
                // empty if block
            }
            this.rows = this.rowCount - this.first;
            this.last = this.first + this.rows;
            if (this.last > this.rowCount) {
                this.last = this.rowCount;
            }
            this.current = this.first;
            this.entryClass = box.getEntryClass();
            String rowClasses = box.getRowClasses();
            if (null != rowClasses && rowClasses.length() > 0) {
                this.rowClasses = rowClasses.split("\\s+");
            }
        }

        public Object getParameter(Object key) {
            if ("rows".equals(key)) {
                return new Iterator(){

                    public boolean hasNext() {
                        if (DataTemplateContext.this.current >= DataTemplateContext.this.last) {
                            return false;
                        }
                        UIData data = (UIData)DataTemplateContext.this.getComponent();
                        data.setRowIndex(DataTemplateContext.this.current);
                        return data.isRowAvailable();
                    }

                    public Object next() {
                        DataTemplateContext.this.current++;
                        return DataTemplateContext.this.getComponent();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("remove row from UIData not supported");
                    }
                };
            }
            if ("rowClass".equals(key)) {
                StringBuffer rowClass = new StringBuffer();
                if (null != this.entryClass) {
                    rowClass.append(this.entryClass);
                    if (this.rowClasses.length > 0) {
                        rowClass.append(" ");
                    }
                }
                if (this.rowClasses.length > 0) {
                    int currentClass = (this.current - this.first - 1) % this.rowClasses.length;
                    if (currentClass < 0) {
                        currentClass = 0;
                    }
                    rowClass.append(this.rowClasses[currentClass]);
                }
                return rowClass.toString();
            }
            if ("columns".equals(key)) {
                return this.columns;
            }
            if ("columnsCount".equals(key)) {
                return new Integer(this.columns.size());
            }
            return super.getParameter(key);
        }
    }
}

