/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.dnd.Draggable;
import org.ajax4jsf.dnd.Dropzone;
import org.ajax4jsf.dnd.event.DropEvent;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.ajax4jsf.framework.util.javascript.JSFunctionDefinition;
import org.ajax4jsf.framework.util.javascript.JSReference;
import org.ajax4jsf.framework.util.javascript.ScriptUtils;
import org.richfaces.json.JSONCollection;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.DnDEventsExchangeMailer;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public class DropzoneRendererContributor
implements RendererContributor {
    public static final String DROP_TARGET_ID = "dropTargetId";
    private static final DnDEventsExchangeMailer.EventCallback dropEventsCallback = new DnDEventsExchangeMailer.EventCallback(){

        void processEvent(FacesEvent facesEvent, UIComponent source, FacesContext facesContext, Object type, Object value) {
            DropEvent dropEvent = (DropEvent)facesEvent;
            Draggable draggable = (Draggable)source;
            dropEvent.setDraggableSource(draggable);
            dropEvent.setDragType((String)type);
            dropEvent.setDragValue(value);
        }
    };
    private static RendererContributor instance;
    static /* synthetic */ Class class$org$ajax4jsf$framework$resource$PrototypeScript;
    static /* synthetic */ Class class$org$ajax4jsf$dnd$DnDScript;
    static /* synthetic */ Class class$org$ajax4jsf$dnd$Dropzone;

    private DropzoneRendererContributor() {
    }

    public static synchronized RendererContributor getInstance() {
        if (instance == null) {
            instance = new DropzoneRendererContributor();
        }
        return instance;
    }

    public ScriptOptions buildOptions(FacesContext context, UIComponent drop) {
        if (drop instanceof Dropzone) {
            return new DropZoneOptions((Dropzone)drop);
        }
        return null;
    }

    public void decode(FacesContext context, UIComponent component, CompositeRenderer compositeRenderer) {
        Map paramMap;
        DnDEventsExchangeMailer eventsExchanger = DnDEventsExchangeMailer.getInstance(context);
        String clientId = component.getClientId(context);
        if (clientId.equals((paramMap = context.getExternalContext().getRequestParameterMap()).get(DROP_TARGET_ID))) {
            String dragSourceId = (String)paramMap.get("dragSourceId");
            if (compositeRenderer != null) {
                compositeRenderer.contributorDecodeCallback(component, context, this, dragSourceId);
            }
            Dropzone dropzone = (Dropzone)component;
            eventsExchanger.mailEvent(dragSourceId, component, context, (FacesEvent)new DropEvent(component), dropEventsCallback, dropzone.getAcceptedTypes(), dropzone.getDropValue(), false);
        }
    }

    public String getScriptContribution(FacesContext context, UIComponent component) {
        StringBuffer result = new StringBuffer();
        result.append(".drop = ");
        JSFunctionDefinition definition = new JSFunctionDefinition();
        definition.addParameter((Object)"event");
        definition.addParameter((Object)"drag");
        Map requestOpts = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        definition.addToBody((Object)"var options = ").addToBody((Object)ScriptUtils.toScript((Object)requestOpts)).addToBody((Object)";");
        definition.addToBody((Object)("options.parameters['dropTargetId'] = '" + component.getClientId(context) + "';"));
        definition.addToBody((Object)"Object.extend(options.parameters,drag.getParameters());");
        definition.addToBody((Object)"if (this.options.ondrop) { if (!this.options.ondrop.call(this, event)) return; };");
        JSFunction dropFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
        dropFunction.addParameter((Object)new JSReference("options"));
        definition.addToBody((Object)dropFunction.toScript()).addToBody((Object)";");
        definition.appendScript(result);
        result.append(";");
        return result.toString();
    }

    public String[] getStyleDependencies() {
        return null;
    }

    public String[] getScriptDependencies() {
        return new String[]{(class$org$ajax4jsf$framework$resource$PrototypeScript == null ? (class$org$ajax4jsf$framework$resource$PrototypeScript = DropzoneRendererContributor.class$("org.ajax4jsf.framework.resource.PrototypeScript")) : class$org$ajax4jsf$framework$resource$PrototypeScript).getName(), "/org/richfaces/renderkit/html/scripts/json/json.js", (class$org$ajax4jsf$dnd$DnDScript == null ? (class$org$ajax4jsf$dnd$DnDScript = DropzoneRendererContributor.class$("org.ajax4jsf.dnd.DnDScript")) : class$org$ajax4jsf$dnd$DnDScript).getName(), "/org/richfaces/renderkit/html/scripts/utils.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-common.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-dropzone.js"};
    }

    public Class getAcceptableClass() {
        return class$org$ajax4jsf$dnd$Dropzone == null ? (class$org$ajax4jsf$dnd$Dropzone = DropzoneRendererContributor.class$("org.ajax4jsf.dnd.Dropzone")) : class$org$ajax4jsf$dnd$Dropzone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DropZoneOptions
    extends ScriptOptions {
        public DropZoneOptions(Dropzone zone) {
            super((UIComponent)zone);
            Object acceptedTypes = zone.getAcceptedTypes();
            if (acceptedTypes instanceof String) {
                try {
                    String typesString = ((String)acceptedTypes).trim();
                    if (!typesString.startsWith("[")) {
                        typesString = "[" + typesString + "]";
                    }
                    acceptedTypes = new JSONCollection(typesString);
                }
                catch (JSONException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            this.addOption("acceptedTypes", acceptedTypes);
            Object typeMapping = zone.getTypeMapping();
            if (typeMapping instanceof String) {
                try {
                    typeMapping = new JSONMap((String)typeMapping);
                }
                catch (JSONException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            this.addOption("typeMapping", typeMapping);
            this.addEventHandler("ondragenter", zone.getOndragenter());
            this.addEventHandler("ondragexit", zone.getOndragexit());
            this.addEventHandler("onafterdrag");
            this.addEventHandler("ondrop");
            this.addEventHandler("ondropend");
        }
    }
}

