/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.richfaces.event.SwitchablePanelSwitchEvent;

public abstract class UISwitchablePanel
extends UIInput {
    public static final String CLIENT_METHOD = "client";
    public static final String SERVER_METHOD = "server";
    public static final String AJAX_METHOD = "ajax";
    public static final String DEFAULT_METHOD = "server";
    private transient Object renderedValue;
    private String switchType;

    public String getSwitchType() {
        if (this.switchType != null) {
            return this.switchType;
        }
        ValueBinding switchTypeBinding = this.getValueBinding("switchType");
        if (switchTypeBinding != null) {
            return (String)switchTypeBinding.getValue(FacesContext.getCurrentInstance());
        }
        return "server";
    }

    public void setSwitchType(String switchType) {
        this.switchType = switchType;
    }

    public Object convertSwitchValue(UIComponent component, Object object) {
        return object;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof SwitchablePanelSwitchEvent && ((Object)((Object)this)).equals(event.getComponent())) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
            }
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        if (facesEvent instanceof SwitchablePanelSwitchEvent) {
            if (this.isRendered()) {
                ValueBinding valueBinding;
                FacesContext facesContext = FacesContext.getCurrentInstance();
                SwitchablePanelSwitchEvent switchEvent = (SwitchablePanelSwitchEvent)facesEvent;
                Object newValue = this.convertSwitchValue(switchEvent.getEventSource(), switchEvent.getValue());
                Object oldValue = this.getValue();
                if (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue)) {
                    this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, oldValue, newValue));
                }
                if ((valueBinding = this.getValueBinding("value")) != null) {
                    valueBinding.setValue(facesContext, newValue);
                    this.setValue(null);
                } else {
                    this.setValue(newValue);
                }
                if (AjaxRendererUtils.isAjaxRequest((FacesContext)facesContext) && this.getSwitchType().equals(AJAX_METHOD)) {
                    AjaxRendererUtils.addRegionByName((FacesContext)facesContext, (UIComponent)this, (String)this.getId());
                }
            }
        } else {
            super.broadcast(facesEvent);
        }
    }

    public void updateModel(FacesContext context) {
    }

    protected Iterator getSwitchedFacetsAndChildren() {
        return this.getFacetsAndChildren();
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("FacesContext is null!");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator kids = this.getSwitchedFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
        try {
            this.decode(context);
            if (this.isImmediate()) {
                this.validate(context);
                context.renderResponse();
            }
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("FacesContext is null!");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator kids = this.getSwitchedFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processUpdates(context);
        }
        try {
            this.updateModel(context);
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("FacesContext is null!");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator kids = this.getSwitchedFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processValidators(context);
        }
        try {
            if (!this.isImmediate()) {
                this.validate(context);
                if (!this.isValid()) {
                    context.renderResponse();
                }
            }
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    protected Object getRenderedValue() {
        if (this.renderedValue != null) {
            return this.renderedValue;
        }
        return this.getValue();
    }

    protected void setRenderedValue(Object renderedValue) {
        this.renderedValue = renderedValue;
    }

    public Object saveState(FacesContext context) {
        Object[] states = new Object[]{super.saveState(context), this.switchType};
        return states;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.switchType = (String)states[1];
        this.renderedValue = this.getValue();
    }
}

