/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.bpel.app.AppDescriptor;
import org.jbpm.bpel.app.AppMyRole;
import org.jbpm.bpel.app.AppPartnerLink;
import org.jbpm.bpel.app.AppPartnerRole;
import org.jbpm.bpel.app.AppScope;
import org.jbpm.bpel.endpointref.EndpointReference;
import org.jbpm.bpel.integration.catalog.CompositeCatalog;
import org.jbpm.bpel.integration.catalog.ServiceCatalog;
import org.jbpm.bpel.xml.ParseProblem;
import org.jbpm.bpel.xml.ProblemCounter;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.bpel.xml.ServiceCatalogReader;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.util.ClassLoaderUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AppDescriptorReader {
    private ProblemHandler problemHandler;
    public static final String RESOURCE_CATALOG_READERS = "resource.catalog.readers";
    private static final Log log = LogFactory.getLog((Class)AppDescriptorReader.class);
    private static final Map catalogReaders = AppDescriptorReader.readCatalogReaders();
    static /* synthetic */ Class class$org$jbpm$bpel$xml$ServiceCatalogReader;

    protected AppDescriptorReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(AppDescriptor appDescriptor, InputSource documentSource) {
        DocumentBuilder builder = XmlUtil.getDocumentBuilder();
        ProblemHandler problemHandler = this.getProblemHandler();
        builder.setErrorHandler(problemHandler.asSaxErrorHandler());
        try {
            Element catalogsElem;
            String version;
            Document descriptorDoc = builder.parse(documentSource);
            if (problemHandler.getProblemCount() > 0) {
                return;
            }
            Element descriptorElem = descriptorDoc.getDocumentElement();
            this.readScope(descriptorElem, appDescriptor);
            String targetNamespace = XmlUtil.getAttribute(descriptorElem, "targetNamespace");
            if (targetNamespace != null) {
                appDescriptor.setTargetNamespace(targetNamespace);
            }
            if ((version = XmlUtil.getAttribute(descriptorElem, "version")) != null) {
                appDescriptor.setVersion(Integer.valueOf(version));
            }
            if ((catalogsElem = XmlUtil.getElement(descriptorElem, "urn:jbpm.org:bpel-1.1:application", "serviceCatalogs")) != null) {
                ServiceCatalog catalog = this.readServiceCatalogs(catalogsElem, documentSource.getSystemId());
                appDescriptor.setServiceCatalog(catalog);
            }
        }
        catch (SAXException e) {
            problemHandler.add(new Problem(2, "application descriptor contains invalid xml", (Throwable)e));
        }
        catch (IOException e) {
            problemHandler.add(new Problem(2, "application descriptor is not readable", (Throwable)e));
        }
        finally {
            builder.setErrorHandler(null);
        }
    }

    public void readScope(Element scopeElem, AppScope scope) {
        Element scopesElem;
        scope.setName(XmlUtil.getAttribute(scopeElem, "name"));
        Element partnerLinksElem = XmlUtil.getElement(scopeElem, "urn:jbpm.org:bpel-1.1:application", "partnerLinks");
        if (partnerLinksElem != null) {
            this.readPartnerLinks(partnerLinksElem, scope);
        }
        if ((scopesElem = XmlUtil.getElement(scopeElem, "urn:jbpm.org:bpel-1.1:application", "scopes")) != null) {
            this.readScopes(scopesElem, scope);
        }
    }

    public void readScopes(Element scopesElem, AppScope parentScope) {
        Iterator scopeElemIt = XmlUtil.getElements(scopesElem, "urn:jbpm.org:bpel-1.1:application", "scope");
        while (scopeElemIt.hasNext()) {
            AppScope scope = new AppScope();
            this.readScope((Element)scopeElemIt.next(), scope);
            parentScope.addScope(scope);
        }
    }

    public void readPartnerLinks(Element plinksElem, AppScope scope) {
        Iterator plinkElemIt = XmlUtil.getElements(plinksElem, "urn:jbpm.org:bpel-1.1:application", "partnerLink");
        while (plinkElemIt.hasNext()) {
            AppPartnerLink partnerLink = this.readPartnerLink((Element)plinkElemIt.next());
            scope.addPartnerLink(partnerLink);
        }
    }

    public AppPartnerLink readPartnerLink(Element partnerLinkElem) {
        Element partnerRoleElem;
        AppPartnerLink partnerLink = new AppPartnerLink();
        partnerLink.setName(partnerLinkElem.getAttribute("name"));
        Element myRoleElem = XmlUtil.getElement(partnerLinkElem, "urn:jbpm.org:bpel-1.1:application", "myRole");
        if (myRoleElem != null) {
            partnerLink.setMyRole(this.readMyRole(myRoleElem));
        }
        if ((partnerRoleElem = XmlUtil.getElement(partnerLinkElem, "urn:jbpm.org:bpel-1.1:application", "partnerRole")) != null) {
            partnerLink.setPartnerRole(this.readPartnerRole(partnerRoleElem));
        }
        return partnerLink;
    }

    public AppMyRole readMyRole(Element myRoleElem) {
        AppMyRole myRole = new AppMyRole();
        myRole.setHandle(XmlUtil.getAttribute(myRoleElem, "handle"));
        return myRole;
    }

    public AppPartnerRole readPartnerRole(Element partnerRoleElem) {
        AppPartnerRole partnerRole = new AppPartnerRole();
        String initiateValue = XmlUtil.getAttribute(partnerRoleElem, "initiate");
        AppPartnerRole.InitiateMode initiateMode = AppPartnerRole.InitiateMode.valueOf(initiateValue);
        partnerRole.setInitiateMode(initiateMode);
        Element referenceElem = XmlUtil.getElement(partnerRoleElem);
        if (referenceElem != null) {
            if (AppPartnerRole.InitiateMode.STATIC.equals((Object)initiateMode)) {
                EndpointReference endpointRef = EndpointReference.readServiceRef(referenceElem);
                partnerRole.setEndpointReference(endpointRef);
            } else {
                this.getProblemHandler().add(new ParseProblem("not treating element as endpoint reference, since initiate mode is not static", referenceElem));
            }
        } else if (AppPartnerRole.InitiateMode.STATIC.equals((Object)initiateMode)) {
            this.getProblemHandler().add(new ParseProblem("endpoint reference missing", partnerRoleElem));
        }
        return partnerRole;
    }

    public ServiceCatalog readServiceCatalogs(Element catalogsElem, String documentBaseURI) {
        ServiceCatalog resultingCatalog;
        ArrayList<ServiceCatalog> catalogs = new ArrayList<ServiceCatalog>();
        Iterator catalogElemIt = XmlUtil.getElements(catalogsElem, "urn:jbpm.org:bpel-1.1:application");
        while (catalogElemIt.hasNext()) {
            Element catalogElem = (Element)catalogElemIt.next();
            ServiceCatalogReader catalogReader = AppDescriptorReader.getCatalogReader(catalogElem.getLocalName());
            if (catalogReader != null) {
                ServiceCatalog catalog = catalogReader.read(catalogElem, documentBaseURI);
                catalogs.add(catalog);
                continue;
            }
            this.getProblemHandler().add(new ParseProblem("unrecognized service catalog", catalogElem));
        }
        switch (catalogs.size()) {
            case 0: {
                resultingCatalog = null;
                break;
            }
            case 1: {
                resultingCatalog = (ServiceCatalog)catalogs.get(0);
                break;
            }
            default: {
                resultingCatalog = new CompositeCatalog(catalogs);
            }
        }
        return resultingCatalog;
    }

    public ProblemHandler getProblemHandler() {
        if (this.problemHandler == null) {
            this.problemHandler = new ProblemCounter();
        }
        return this.problemHandler;
    }

    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    public static AppDescriptorReader getInstance() {
        return new AppDescriptorReader();
    }

    public static ServiceCatalogReader getCatalogReader(String name) {
        return (ServiceCatalogReader)catalogReaders.get(name);
    }

    private static Map readCatalogReaders() {
        Element readersElem;
        String resource = JbpmConfiguration.Configs.getString((String)RESOURCE_CATALOG_READERS);
        try {
            readersElem = XmlUtil.parseResource(resource);
        }
        catch (SAXException e) {
            log.error((Object)("catalog readers document contains invalid xml: " + resource), (Throwable)e);
            return Collections.EMPTY_MAP;
        }
        catch (IOException e) {
            log.error((Object)("could not read catalog readers document: " + resource), (Throwable)e);
            return Collections.EMPTY_MAP;
        }
        HashMap<String, ServiceCatalogReader> catalogReaders = new HashMap<String, ServiceCatalogReader>();
        Iterator readerElemIt = XmlUtil.getElements(readersElem, null, "catalogReader");
        while (readerElemIt.hasNext()) {
            String readerClassName;
            Class readerClass;
            Element readerElem = (Element)readerElemIt.next();
            String name = readerElem.getAttribute("name");
            if (!(class$org$jbpm$bpel$xml$ServiceCatalogReader == null ? AppDescriptorReader.class$("org.jbpm.bpel.xml.ServiceCatalogReader") : class$org$jbpm$bpel$xml$ServiceCatalogReader).isAssignableFrom(readerClass = ClassLoaderUtil.loadClass((String)(readerClassName = readerElem.getAttribute("class"))))) {
                log.warn((Object)("not a catalog reader: " + readerClassName));
                continue;
            }
            try {
                ServiceCatalogReader reader = (ServiceCatalogReader)readerClass.newInstance();
                catalogReaders.put(name, reader);
                log.debug((Object)("registered catalog reader: name=" + name + ", class=" + readerClassName));
            }
            catch (InstantiationException e) {
                log.warn((Object)("reader class not instantiable: " + readerClassName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("reader class or constructor not public: " + readerClassName), (Throwable)e);
            }
        }
        return catalogReaders;
    }
}

