/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.wsdl.xml;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.util.EmptyIterator;
import org.jbpm.bpel.graph.def.Import;
import org.jbpm.bpel.wsdl.PartnerLinkType;
import org.jbpm.bpel.wsdl.Property;
import org.jbpm.bpel.wsdl.xml.WsdlConstants;
import org.jbpm.bpel.wsdl.xml.WsdlFactoryImpl;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WsdlUtil {
    private static final WSDLFactory factory = new WsdlFactoryImpl();
    private static Definition sharedDefinition;
    private static ExtensionRegistry sharedRegistry;
    private static final Log log;

    private WsdlUtil() {
    }

    public static WSDLFactory getFactory() {
        return factory;
    }

    public static Definition getSharedDefinition() {
        if (sharedDefinition == null) {
            sharedDefinition = WsdlUtil.getFactory().newDefinition();
        }
        return sharedDefinition;
    }

    public static ExtensionRegistry getSharedExtensionRegistry() {
        if (sharedRegistry == null) {
            sharedRegistry = WsdlUtil.getFactory().newPopulatedExtensionRegistry();
        }
        return sharedRegistry;
    }

    public static Definition readText(String text) throws WSDLException {
        return WsdlUtil.getFactory().newWSDLReader().readWSDL(null, new InputSource(new StringReader(text)));
    }

    public static Definition readResource(Class clazz, String resource) throws WSDLException {
        String resourceURI = clazz.getResource(resource).toExternalForm();
        return WsdlUtil.getFactory().newWSDLReader().readWSDL(resourceURI);
    }

    public static Definition writeAndRead(Definition definition) throws WSDLException {
        WSDLFactory factory = WsdlUtil.getFactory();
        CharArrayWriter output = new CharArrayWriter();
        factory.newWSDLWriter().writeWSDL(definition, (Writer)output);
        try {
            return factory.newWSDLReader().readWSDL(definition.getDocumentBaseURI(), XmlUtil.parseText(output.toString()));
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "could not read the WSDL definitions back", (Throwable)e);
        }
    }

    public static void writeFile(WSDLWriter writer, Definition def, File file) throws WSDLException {
        File parentDir = file.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        FileOutputStream fileSink = null;
        try {
            OutputStreamWriter encoderSink;
            fileSink = new FileOutputStream(file);
            try {
                encoderSink = new OutputStreamWriter((OutputStream)fileSink, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.debug((Object)"could not use UTF-8 to write WSDL document", (Throwable)e);
                encoderSink = new OutputStreamWriter(fileSink);
            }
            writer.writeWSDL(def, (Writer)new BufferedWriter(encoderSink));
        }
        catch (FileNotFoundException e) {
            throw new WSDLException("OTHER_ERROR", "could not open file for writing: " + file, (Throwable)e);
        }
        finally {
            if (fileSink != null) {
                try {
                    ((OutputStream)fileSink).close();
                }
                catch (IOException e) {
                    log.warn((Object)("could not close file: " + file), (Throwable)e);
                }
            }
        }
    }

    public static PortType getPortType(Definition def, QName name) {
        return (PortType)new WsdlElementLookup(){

            protected Object getLocalElement(Definition def, QName name) {
                return def.getPortTypes().get(name);
            }
        }.getElement(def, name);
    }

    public static Message getMessage(Definition def, QName name) {
        return (Message)new WsdlElementLookup(){

            protected Object getLocalElement(Definition def, QName name) {
                return def.getMessages().get(name);
            }
        }.getElement(def, name);
    }

    public static PartnerLinkType getPartnerLinkType(Definition def, QName name) {
        return (PartnerLinkType)new WsdlElementLookup(){

            protected Object getLocalElement(Definition def, QName name) {
                Iterator partnerLinkTypeIt = WsdlUtil.getExtensions(def.getExtensibilityElements(), WsdlConstants.Q_PARTNER_LINK_TYPE);
                while (partnerLinkTypeIt.hasNext()) {
                    PartnerLinkType partnerLinkType = (PartnerLinkType)partnerLinkTypeIt.next();
                    if (!partnerLinkType.getQName().equals(name)) continue;
                    return partnerLinkType;
                }
                return null;
            }
        }.getElement(def, name);
    }

    public static Property getProperty(Definition def, QName name) {
        return (Property)new WsdlElementLookup(){

            protected Object getLocalElement(Definition def, QName name) {
                Iterator propertyIt = WsdlUtil.getExtensions(def.getExtensibilityElements(), WsdlConstants.Q_PROPERTY);
                while (propertyIt.hasNext()) {
                    Property property = (Property)propertyIt.next();
                    if (!property.getQName().equals(name)) continue;
                    return property;
                }
                return null;
            }
        }.getElement(def, name);
    }

    public static ExtensibilityElement getExtension(List extensions, QName extensionType) {
        if (extensions != null) {
            Iterator extensionIt = extensions.iterator();
            while (extensionIt.hasNext()) {
                ExtensibilityElement extension = (ExtensibilityElement)extensionIt.next();
                if (!ExtensionTypePredicate.evaluate(extension, extensionType)) continue;
                return extension;
            }
        }
        return null;
    }

    public static Iterator getExtensions(List extensions, QName extensionType) {
        return extensions != null ? new FilterIterator(extensions.iterator(), (Predicate)new ExtensionTypePredicate(extensionType)) : EmptyIterator.INSTANCE;
    }

    public static QName getDocLitElementName(Message message) {
        Map parts = message.getParts();
        return parts.size() == 1 ? ((Part)parts.values().iterator().next()).getElementName() : null;
    }

    public static Import createImport(Definition def) {
        Import imp = new Import();
        imp.setNamespace(def.getTargetNamespace());
        imp.setType(Import.Type.WSDL);
        imp.setDocument(def);
        return imp;
    }

    static {
        log = LogFactory.getLog((Class)WsdlUtil.class);
    }

    private static class ExtensionTypePredicate
    implements Predicate {
        private final QName extensionType;

        ExtensionTypePredicate(QName type) {
            this.extensionType = type;
        }

        public boolean evaluate(Object arg) {
            return ExtensionTypePredicate.evaluate((ExtensibilityElement)arg, this.extensionType);
        }

        public static boolean evaluate(ExtensibilityElement extension, QName extensionType) {
            return extension.getElementType().equals(extensionType);
        }
    }

    private static abstract class WsdlElementLookup {
        private WsdlElementLookup() {
        }

        public Object getElement(Definition def, QName name) {
            Object element = this.getLocalElement(def, name);
            if (element == null) {
                element = this.getImportedElement(def, name);
            }
            return element;
        }

        protected Object getImportedElement(Definition def, QName name) {
            List imports = def.getImports(name.getNamespaceURI());
            if (imports != null) {
                int n = imports.size();
                for (int i = 0; i < n; ++i) {
                    javax.wsdl.Import imp = (javax.wsdl.Import)imports.get(i);
                    Object element = this.getLocalElement(imp.getDefinition(), name);
                    if (element == null) continue;
                    return element;
                }
            }
            Iterator importsIt = def.getImports().values().iterator();
            while (importsIt.hasNext()) {
                imports = (List)importsIt.next();
                int n = imports.size();
                for (int i = 0; i < n; ++i) {
                    javax.wsdl.Import imp = (javax.wsdl.Import)imports.get(i);
                    Object element = this.getImportedElement(imp.getDefinition(), name);
                    if (element == null) continue;
                    return element;
                }
            }
            return null;
        }

        protected abstract Object getLocalElement(Definition var1, QName var2);
    }
}

