/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.persistence.db.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.lang.enums.Enum;
import org.apache.commons.lang.enums.EnumUtils;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class EnumType
implements UserType,
ParameterizedType {
    private Class enumClass;
    public static final String ENUM_CLASS_PARAM = "class";
    private static final int[] SQL_TYPES = new int[]{12};

    public boolean equals(Object x, Object y) {
        return x == null ? y == null : x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) {
        return target;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String enumName = (String)Hibernate.STRING.nullSafeGet(rs, names[0]);
        Enum enumConstant = enumName != null ? EnumUtils.getEnum((Class)this.enumClass, (String)enumName) : null;
        return enumConstant;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        String enumName = value != null ? ((Enum)value).getName() : null;
        Hibernate.STRING.nullSafeSet(st, (Object)enumName, index);
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public void setParameterValues(Properties parameters) throws HibernateException {
        String enumClassName = (String)parameters.get(ENUM_CLASS_PARAM);
        try {
            this.enumClass = Class.forName(enumClassName);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("enum class not found: " + enumClassName, (Throwable)e);
        }
    }
}

