/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.persistence.db.type;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.jbpm.bpel.persistence.db.type.StringBufferReader;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ElementType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{12};
    private static final Log log = LogFactory.getLog((Class)ElementType.class);

    public boolean equals(Object x, Object y) {
        return x == null ? y == null : x.equals(y);
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }

    public Object deepCopy(Object value) {
        return value != null ? ((Element)value).cloneNode(true) : null;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) {
        return this.deepCopy(original);
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String columnName = names[0];
        Reader xmlStream = rs.getCharacterStream(columnName);
        if (xmlStream == null) {
            return null;
        }
        InputSource source = new InputSource(xmlStream);
        source.setSystemId(columnName);
        try {
            Element element = XmlUtil.getDocumentBuilder().parse(source).getDocumentElement();
            if (log.isTraceEnabled()) {
                log.trace((Object)("returning '" + element + "' as column: " + columnName));
            }
            return element;
        }
        catch (SAXException e) {
            throw new HibernateException("could not parse column: " + columnName, (Throwable)e);
        }
        catch (IOException e) {
            throw new HibernateException("could not read column: " + columnName, (Throwable)e);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, SQL_TYPES[0]);
            if (log.isTraceEnabled()) {
                log.trace((Object)("binding null to parameter: " + index));
            }
        } else {
            Element element = (Element)value;
            try {
                Transformer idTransformer = XmlUtil.getTransformerFactory().newTransformer();
                StringWriter xmlStream = new StringWriter();
                idTransformer.transform(new DOMSource(element), new StreamResult(xmlStream));
                StringBuffer xmlBuffer = xmlStream.getBuffer();
                st.setCharacterStream(index, (Reader)new StringBufferReader(xmlBuffer), xmlBuffer.length());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("binding '" + xmlBuffer + "' to parameter: " + index));
                }
            }
            catch (TransformerException e) {
                throw new HibernateException("could not transform to stream: " + element, (Throwable)e);
            }
        }
    }

    public Class returnedClass() {
        return Element.class;
    }
}

