/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.par;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.bpel.xml.BpelParseException;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.par.ConfigurableParser;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.par.ProcessArchiveParser;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.util.ClassLoaderUtil;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GenericArchiveParser
implements ProcessArchiveParser {
    private static final Log log = LogFactory.getLog((Class)GenericArchiveParser.class);
    private static List jpdlArchiveParsers = GenericArchiveParser.readProcessArchiveParsers("resource.jpdl.parsers");
    private static List bpelArchiveParsers = GenericArchiveParser.readProcessArchiveParsers("resource.bpel.parsers");
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$org$jbpm$jpdl$par$ProcessArchiveParser;

    public ProcessDefinition readFromArchive(ProcessArchive archive, ProcessDefinition definition) {
        if (archive.getEntry("processdefinition.xml") == null) {
            definition = GenericArchiveParser.callProcessArchiveParsers(bpelArchiveParsers, archive, definition);
            List problems = archive.getProblems();
            if (Problem.containsProblemsOfLevel((Collection)problems, (int)2)) {
                throw new BpelParseException(problems);
            }
        } else {
            definition = GenericArchiveParser.callProcessArchiveParsers(jpdlArchiveParsers, archive, definition);
            List problems = archive.getProblems();
            if (Problem.containsProblemsOfLevel((Collection)problems, (int)2)) {
                throw new JpdlException(problems);
            }
        }
        return definition;
    }

    public static List readProcessArchiveParsers(String objectName) {
        Element parsersElem;
        String resource = JbpmConfiguration.Configs.getString((String)objectName);
        try {
            parsersElem = XmlUtil.parseResource(resource);
        }
        catch (SAXException e) {
            log.error((Object)("parsers document contains invalid xml: " + resource), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        catch (IOException e) {
            log.error((Object)("could not read parsers document: " + resource), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        ArrayList<ProcessArchiveParser> processArchiveParsers = new ArrayList<ProcessArchiveParser>();
        Iterator parserElemIt = XmlUtil.getElements(parsersElem, null, "parser");
        while (parserElemIt.hasNext()) {
            Element parserElem;
            String parserClassName;
            Class parserClass;
            if (!(class$org$jbpm$jpdl$par$ProcessArchiveParser == null ? GenericArchiveParser.class$("org.jbpm.jpdl.par.ProcessArchiveParser") : class$org$jbpm$jpdl$par$ProcessArchiveParser).isAssignableFrom(parserClass = ClassLoaderUtil.loadClass((String)(parserClassName = (parserElem = (Element)parserElemIt.next()).getAttribute("class"))))) {
                log.warn((Object)("not a process archive parser: " + parserClass));
                continue;
            }
            try {
                ProcessArchiveParser processArchiveParser = (ProcessArchiveParser)parserClass.newInstance();
                if (processArchiveParser instanceof ConfigurableParser) {
                    ((ConfigurableParser)processArchiveParser).configure(parserElem);
                }
                processArchiveParsers.add(processArchiveParser);
                log.debug((Object)("registered archive parser: " + parserClassName));
            }
            catch (InstantiationException e) {
                log.warn((Object)("parser class not instantiable: " + parserClassName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)("parser class or constructor not public: " + parserClassName), (Throwable)e);
            }
        }
        return processArchiveParsers;
    }

    public static ProcessDefinition callProcessArchiveParsers(List archiveParsers, ProcessArchive archive, ProcessDefinition definition) {
        Iterator archiveParsersIt = archiveParsers.iterator();
        while (archiveParsersIt.hasNext()) {
            ProcessArchiveParser archiveParser = (ProcessArchiveParser)archiveParsersIt.next();
            definition = archiveParser.readFromArchive(archive, definition);
        }
        return definition;
    }
}

