/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.server;

import javax.jms.JMSException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.app.AppDescriptor;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.integration.jms.IntegrationControl;
import org.jbpm.bpel.integration.jms.JmsIntegrationServiceFactory;

public class IntegrationConfigurator
implements ServletContextListener {
    private static final Log log = LogFactory.getLog((Class)IntegrationConfigurator.class);
    private static final String JBPM_CONFIGURATION_PARAM = "jbpm.configuration.resource";

    public void contextInitialized(ServletContextEvent ev) {
        ServletContext servletContext = ev.getServletContext();
        String configurationName = servletContext.getInitParameter(JBPM_CONFIGURATION_PARAM);
        JbpmConfiguration jbpmConfiguration = configurationName != null ? JbpmConfiguration.getInstance((String)configurationName) : JbpmConfiguration.getInstance();
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            AppDescriptor appDescriptor = AppDescriptor.readAppDescriptor(jbpmContext);
            BpelProcessDefinition processDefinition = appDescriptor.findProcessDefinition(jbpmContext);
            JmsIntegrationServiceFactory integrationServiceFactory = JmsIntegrationServiceFactory.getInstance(jbpmConfiguration);
            IntegrationControl integrationControl = integrationServiceFactory.getIntegrationControl(processDefinition);
            integrationControl.setAppDescriptor(appDescriptor);
            integrationControl.enableInboundMessageActivities(jbpmContext);
            servletContext.setAttribute("jbpm.bpel.integration.control", (Object)integrationControl);
            log.info((Object)("Message reception enabled for process: " + appDescriptor.getName()));
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BpelException("could not start bpel application", e);
        }
        finally {
            jbpmContext.close();
        }
    }

    public void contextDestroyed(ServletContextEvent ev) {
        IntegrationControl integrationControl = (IntegrationControl)ev.getServletContext().getAttribute("jbpm.bpel.integration.control");
        try {
            integrationControl.disableInboundMessageActivities();
            log.info((Object)("Message reception disabled for process: " + integrationControl.getAppDescriptor().getName()));
        }
        catch (JMSException e) {
            log.error((Object)"could not stop bpel application", (Throwable)e);
        }
    }
}

