/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.struct;

import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.bpel.graph.struct.StructuredActivity;
import org.jbpm.graph.def.Transition;

public class Sequence
extends StructuredActivity {
    private static final long serialVersionUID = 1L;

    public Sequence() {
    }

    public Sequence(String name) {
        super(name);
    }

    protected boolean isChildInitial(Activity child) {
        return child.equals(this.getNodes().get(0));
    }

    protected void addImplicitTransitions(Activity activity) {
        if (this.nodes == null || this.nodes.size() == 0) {
            this.begin.connect(activity);
        } else {
            Activity last = (Activity)((Object)this.nodes.get(this.nodes.size() - 1));
            Transition leavingTransition = last.getDefaultLeavingTransition();
            this.end.removeArrivingTransition(leavingTransition);
            activity.addArrivingTransition(leavingTransition);
        }
        activity.connect(this.end);
    }

    protected void removeImplicitTransitions(Activity activity) {
        Transition leaving = activity.getDefaultLeavingTransition();
        Transition arriving = activity.getDefaultArrivingTransition();
        activity.removeArrivingTransition(arriving);
        activity.removeLeavingTransition(leaving);
        Activity successor = (Activity)leaving.getTo();
        successor.removeArrivingTransition(leaving);
        successor.addArrivingTransition(arriving);
    }

    public void reorderNode(int oldIndex, int newIndex) {
        if (this.nodes == null) {
            throw new IndexOutOfBoundsException("no collection present");
        }
        Activity reorderedObject = (Activity)((Object)this.nodes.remove(oldIndex));
        this.removeImplicitTransitions(reorderedObject);
        StructuredActivity.Begin predecessor = newIndex == 0 ? this.begin : (Activity)((Object)this.nodes.get(newIndex - 1));
        StructuredActivity.End successor = newIndex == this.nodes.size() ? this.end : (Activity)((Object)this.nodes.get(newIndex));
        Transition leaving = predecessor.getDefaultLeavingTransition();
        successor.removeArrivingTransition(leaving);
        reorderedObject.addArrivingTransition(leaving);
        reorderedObject.connect(successor);
        this.nodes.add(newIndex, reorderedObject);
    }

    public void accept(BpelVisitor visitor) {
        visitor.visit(this);
    }
}

