/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.def;

import java.util.List;
import org.jbpm.bpel.graph.basic.Receive;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.graph.def.BpelVisitorSupport;
import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.scope.Scope;
import org.jbpm.bpel.graph.struct.Flow;
import org.jbpm.bpel.graph.struct.If;
import org.jbpm.bpel.graph.struct.Pick;
import org.jbpm.bpel.graph.struct.Sequence;
import org.jbpm.bpel.graph.struct.While;
import org.jbpm.bpel.integration.def.ReceiveAction;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

class ProcessInstanceStarter
extends BpelVisitorSupport {
    private final ReceiveAction trigger;
    private final Token token;
    static final /* synthetic */ boolean $assertionsDisabled;

    ProcessInstanceStarter(Token token, ReceiveAction trigger) {
        this.token = token;
        this.trigger = trigger;
    }

    public void visit(BpelProcessDefinition process) {
        process.getGlobalScope().getActivity().accept(this);
    }

    public void visit(Receive receive) {
        if (!$assertionsDisabled && !receive.isCreateInstance()) {
            throw new AssertionError(receive);
        }
        if (receive.getReceiveAction().equals(this.trigger)) {
            this.token.setNode((Node)receive);
            receive.leave(new ExecutionContext(this.token));
        } else {
            receive.enter(new ExecutionContext(this.token));
        }
    }

    public void visit(Sequence sequence) {
        Activity firstActivity = (Activity)((Object)sequence.getNodes().get(0));
        if (firstActivity.isInitial()) {
            firstActivity.accept(this);
        } else {
            ProcessInstanceStarter.enterActivity(firstActivity, this.token);
        }
    }

    public void visit(If _if) {
    }

    public void visit(While _while) {
    }

    public void visit(Pick pick) {
        if (!$assertionsDisabled && !pick.isCreateInstance()) {
            throw new AssertionError(pick);
        }
        if (pick.getOnMessages().contains(this.trigger)) {
            this.token.setNode((Node)pick);
            pick.processEvent(this.trigger, new ExecutionContext(this.token));
        } else {
            pick.enter(new ExecutionContext(this.token));
        }
    }

    public void visit(Flow flow) {
        this.token.setNode((Node)flow.getEnd());
        Token flowToken = flow.initializeLinks(this.token);
        Token[] concurrentTokens = flow.createConcurrentTokens(flowToken);
        List activities = flow.getNodes();
        int n = concurrentTokens.length;
        for (int i = 0; i < n; ++i) {
            Activity activity = (Activity)((Object)activities.get(i));
            Token concurrentToken = concurrentTokens[i];
            if (activity.isInitial()) {
                activity.accept(new ProcessInstanceStarter(concurrentToken, this.trigger));
            } else {
                ProcessInstanceStarter.enterActivity(activity, concurrentToken);
            }
            if (flowToken.hasEnded()) break;
        }
    }

    public void visit(Scope scope) {
        this.token.setNode((Node)scope);
        Token scopeToken = new Token(this.token, scope.getName());
        ScopeInstance scopeInstance = scope.createInstance(scopeToken);
        scopeInstance.initializeData();
        scopeInstance.enableEvents();
        Activity activity = scope.getActivity();
        Token primaryToken = scopeInstance.getPrimaryToken();
        if (activity.isInitial()) {
            activity.accept(new ProcessInstanceStarter(primaryToken, this.trigger));
        } else {
            ProcessInstanceStarter.enterActivity(activity, primaryToken);
        }
    }

    private static void enterActivity(Activity activity, Token token) {
        if (!$assertionsDisabled && activity.getTargets().isEmpty()) {
            throw new AssertionError((Object)activity);
        }
        activity.enter(new ExecutionContext(token));
    }

    static {
        $assertionsDisabled = !ProcessInstanceStarter.class.desiredAssertionStatus();
    }
}

