/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.BpelVisitor;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class Assign
extends Activity {
    static final Log log = LogFactory.getLog((Class)Assign.class);
    private static final long serialVersionUID = 1L;
    private List copies;

    public Assign() {
    }

    public Assign(String name) {
        super(name);
    }

    public void execute(ExecutionContext context) {
        Token token = context.getToken();
        int n = this.copies.size();
        for (int i = 0; i < n; ++i) {
            ((Copy)this.copies.get(i)).copyValue(token);
        }
        this.leave(context);
    }

    public void addCopy(Copy copy) {
        if (this.copies == null) {
            this.copies = new ArrayList();
        }
        this.copies.add(copy);
    }

    public List getCopies() {
        return this.copies;
    }

    public void accept(BpelVisitor visitor) {
        visitor.visit(this);
    }

    public static abstract class To
    implements Serializable {
        long id;

        public abstract void assign(Token var1, Object var2);
    }

    public static abstract class From
    implements Serializable {
        long id;

        public abstract Object extract(Token var1);
    }

    public static class Copy
    implements Serializable {
        long id;
        private From from;
        private To to;
        private static final long serialVersionUID = 1L;

        public From getFrom() {
            return this.from;
        }

        public void setFrom(From from) {
            this.from = from;
        }

        public To getTo() {
            return this.to;
        }

        public void setTo(To to) {
            this.to = to;
        }

        public void copyValue(Token token) {
            Object value = this.from.extract(token);
            log.debug((Object)("copying: token=" + token + ", value=" + value));
            this.to.assign(token, value);
        }
    }
}

