/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.endpointref.wsdl;

import javax.xml.namespace.QName;
import org.jbpm.bpel.endpointref.SoapEndpointReference;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsdlEndpointReference
extends SoapEndpointReference {
    private static final String PREFIX_WSDL = "wsdl";
    private static final String PREFIX_SOAP = "soap";

    protected void readEndpointRef(Element endpointRefElem) {
        String serviceLocalName = endpointRefElem.getAttribute("name");
        String defaultNamespace = XmlUtil.getNamespaceURI(null, endpointRefElem);
        this.setServiceName(new QName(defaultNamespace, serviceLocalName));
        Element portElem = XmlUtil.getElement(endpointRefElem, "http://schemas.xmlsoap.org/wsdl/", "port");
        if (portElem != null) {
            this.setPortName(portElem.getAttribute("name"));
            Element addressElem = XmlUtil.getElement(portElem, "http://schemas.xmlsoap.org/wsdl/soap/", "address");
            if (addressElem != null) {
                this.setAddress(addressElem.getAttribute("location"));
            }
        }
    }

    protected Element writeEndpointRef(Document nodeFactory) {
        Element serviceElem = nodeFactory.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:service");
        XmlUtil.addNamespaceDeclaration(serviceElem, "http://schemas.xmlsoap.org/wsdl/", PREFIX_WSDL);
        QName serviceName = this.getServiceName();
        serviceElem.setAttribute("name", serviceName.getLocalPart());
        XmlUtil.addNamespaceDeclaration(serviceElem, serviceName.getNamespaceURI());
        String portName = this.getPortName();
        if (portName != null) {
            Element portElem = nodeFactory.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:port");
            portElem.setAttribute("name", portName);
            serviceElem.appendChild(portElem);
            String address = this.getAddress();
            if (address != null) {
                Element addressElem = nodeFactory.createElementNS("http://schemas.xmlsoap.org/wsdl/soap/", "soap:address");
                XmlUtil.addNamespaceDeclaration(addressElem, "http://schemas.xmlsoap.org/wsdl/soap/", PREFIX_SOAP);
                addressElem.setAttribute("location", address);
                portElem.appendChild(addressElem);
            }
        }
        return serviceElem;
    }
}

