/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.app;

import java.net.URL;
import java.util.Collection;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.app.AppDescriptorVisitor;
import org.jbpm.bpel.app.AppScope;
import org.jbpm.bpel.graph.def.BpelProcessDefinition;
import org.jbpm.bpel.integration.catalog.ServiceCatalog;
import org.jbpm.bpel.persistence.db.BpelGraphSession;
import org.jbpm.bpel.xml.AppDescriptorReader;
import org.jbpm.bpel.xml.ProblemCollector;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.jpdl.xml.Problem;
import org.xml.sax.InputSource;

public class AppDescriptor
extends AppScope {
    private String targetNamespace;
    private Integer version;
    private ServiceCatalog serviceCatalog;
    public static final String RESOURCE_APP_DESCRIPTOR = "resource.app.descriptor";
    public static final String DEFAULT_APP_DESCRIPTOR = "/bpel-application.xml";

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ServiceCatalog getServiceCatalog() {
        return this.serviceCatalog;
    }

    public void setServiceCatalog(ServiceCatalog serviceCatalog) {
        this.serviceCatalog = serviceCatalog;
    }

    public BpelProcessDefinition findProcessDefinition(JbpmContext jbpmContext) {
        String name = this.getName();
        String targetNamespace = this.getTargetNamespace();
        Integer version = this.getVersion();
        BpelGraphSession graphSession = BpelGraphSession.getInstance(jbpmContext);
        BpelProcessDefinition processDefinition = version != null ? graphSession.findProcessDefinition(name, targetNamespace, version) : graphSession.findLatestProcessDefinition(name, targetNamespace);
        if (processDefinition == null) {
            throw new BpelException("process not found: name=" + name + ", version=" + version);
        }
        return processDefinition;
    }

    public void accept(AppDescriptorVisitor visitor) {
        visitor.visit(this);
    }

    public static AppDescriptor readAppDescriptor(JbpmContext jbpmContext) {
        URL appDescriptorURL;
        String appDescriptorResource = DEFAULT_APP_DESCRIPTOR;
        ObjectFactory objectFactory = jbpmContext.getObjectFactory();
        if (objectFactory.hasObject(RESOURCE_APP_DESCRIPTOR)) {
            appDescriptorResource = (String)objectFactory.createObject(RESOURCE_APP_DESCRIPTOR);
        }
        if ((appDescriptorURL = Thread.currentThread().getContextClassLoader().getResource(appDescriptorResource)) == null && (appDescriptorURL = AppDescriptor.class.getResource(appDescriptorResource)) == null) {
            throw new BpelException("could not find application descriptor: " + appDescriptorResource);
        }
        AppDescriptorReader appDescriptorReader = AppDescriptorReader.getInstance();
        ProblemCollector problemHandler = new ProblemCollector(appDescriptorResource);
        appDescriptorReader.setProblemHandler(problemHandler);
        AppDescriptor appDescriptor = new AppDescriptor();
        appDescriptorReader.read(appDescriptor, new InputSource(appDescriptorURL.toExternalForm()));
        if (Problem.containsProblemsOfLevel((Collection)problemHandler.getProblems(), (int)2)) {
            throw new BpelException("errors found in bpel application descriptor");
        }
        return appDescriptor;
    }
}

