/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.LogFactory;
import webwork.util.BeanUtil;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class URLTag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    protected String page;
    protected String valueAttr;
    protected String value;
    protected String includeParamsAttr;
    protected Map params;
    public static final String NONE = "none";
    public static final String GET = "get";
    public static final String ALL = "all";

    public void setPage(String aName) {
        this.page = aName;
    }

    public void setValue(String aName) {
        this.valueAttr = aName;
    }

    public void setIncludeParams(String aName) {
        this.includeParamsAttr = aName;
    }

    public void addParameter(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        if (value == null) {
            this.params.remove(name);
        } else {
            this.params.put(name, BeanUtil.toStringValue(value));
        }
    }

    public int doStartTag() throws JspException {
        block12: {
            if (this.page == null) {
                if (this.valueAttr != null) {
                    this.value = this.findString(this.valueAttr);
                }
            } else {
                this.value = this.page;
            }
            this.params = null;
            if (this.value != null) break block12;
            try {
                if (this.params == null) {
                    this.params = new HashMap();
                }
                String includeParams = null;
                if (this.includeParamsAttr != null) {
                    includeParams = this.findString(this.includeParamsAttr);
                }
                if (includeParams == null || includeParams.equals(GET)) {
                    HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
                    String query = req.getQueryString();
                    if (query == null) break block12;
                    int idx = query.lastIndexOf(35);
                    if (idx != -1) {
                        query = query.substring(0, idx - 1);
                    }
                    this.params.putAll(HttpUtils.parseQueryString((String)query));
                    break block12;
                }
                if (includeParams.equals(ALL)) {
                    this.params.putAll(((HttpServletRequest)this.pageContext.getRequest()).getParameterMap());
                } else if (!includeParams.equals(NONE)) {
                    LogFactory.getLog(this.getClass()).warn((Object)("Unknown value for includeParams parameter to URL tag: " + includeParams));
                }
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).warn((Object)("Unable to put request parameters (" + ((HttpServletRequest)this.pageContext.getRequest()).getQueryString() + ") into parameter map."), (Throwable)e);
            }
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        String result;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        StringBuffer link = new StringBuffer();
        if (this.value != null) {
            if (this.value.startsWith("/")) {
                link.append(request.getContextPath());
            }
            link.append(this.value);
        } else {
            String requestURI = (String)request.getAttribute("webwork.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        if (this.params != null && this.params.size() > 0) {
            if (link.toString().indexOf("?") == -1) {
                link.append('?');
            } else {
                link.append("&amp;");
            }
            Iterator iterator = this.params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value != null) {
                    if (value instanceof String) {
                        link.append(name);
                        link.append('=');
                        link.append(URLEncoder.encode((String)value));
                    } else {
                        String[] values = (String[])value;
                        link.append(name);
                        link.append('=');
                        link.append(URLEncoder.encode(values[0]));
                    }
                }
                if (!iterator.hasNext()) continue;
                link.append("&amp;");
            }
        }
        try {
            result = response.encodeURL(link.toString());
        }
        catch (Exception e) {
            result = link.toString();
        }
        String id = this.getId();
        if (id != null) {
            this.pageContext.setAttribute(id, (Object)result);
            this.pageContext.setAttribute(id, (Object)result, 2);
        } else {
            try {
                this.pageContext.getOut().write(result);
            }
            catch (IOException _ioe) {
                throw new JspException("IOError: " + _ioe.getMessage());
            }
        }
        return 6;
    }
}

