/*
 * Decompiled with CFR 0.152.
 */
package webwork.util.editor;

import java.text.DateFormat;
import java.util.Date;
import webwork.action.ActionContext;
import webwork.action.ValidationEditorSupport;
import webwork.util.DateFormatter;
import webwork.util.editor.FastPropertyEditor;

public class DateEditor
extends ValidationEditorSupport
implements FastPropertyEditor {
    public void setAsText(String txt) {
        this.setValue(this.getAsValue(txt));
    }

    public Object getAsValue(String txt) {
        try {
            DateFormatter formatter = new DateFormatter();
            try {
                ActionContext.getContext();
                formatter.setParser(DateFormat.getDateInstance(3, ActionContext.getLocale()));
            }
            catch (Exception e) {
                // empty catch block
            }
            formatter.setDate(txt);
            return formatter.getDate();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to set value for " + txt);
        }
    }

    public String getAsText() {
        return this.value == null ? "" : DateEditor.formatDate(this.value);
    }

    public String getAsText(Object val) {
        return val == null ? "" : DateEditor.formatDate(val);
    }

    private static String formatDate(Object obj) {
        try {
            DateFormatter formatter = new DateFormatter();
            formatter.setDate((Date)obj);
            try {
                ActionContext.getContext();
                formatter.setFormat(DateFormat.getDateInstance(3, ActionContext.getLocale()));
            }
            catch (Exception e) {
                // empty catch block
            }
            return formatter.getFormattedDate();
        }
        catch (Exception e) {
            return "";
        }
    }
}

