/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;
import webwork.util.ValueStack;

public class ServletValueStack
extends ValueStack {
    private ServletRequest request;
    private PageContext context;

    public static ServletValueStack getStack(ServletRequest request) {
        ServletValueStack stack = (ServletValueStack)request.getAttribute("webwork.result");
        if (stack == null) {
            stack = new ServletValueStack();
            request.setAttribute("webwork.result", (Object)stack);
        }
        stack.setRequest(request);
        return stack;
    }

    public static ServletValueStack getStack(PageContext context) {
        ServletRequest request = context.getRequest();
        ServletValueStack stack = (ServletValueStack)request.getAttribute("webwork.result");
        if (stack == null) {
            stack = new ServletValueStack();
            request.setAttribute("webwork.result", (Object)stack);
        }
        stack.setRequest(request);
        stack.setContext(context);
        return stack;
    }

    private void setRequest(ServletRequest request) {
        this.request = request;
    }

    private void setContext(PageContext context) {
        this.context = context;
    }

    protected Object findInContext(String id) {
        if (this.context != null) {
            try {
                return this.context.findAttribute(id);
            }
            catch (Exception e) {
                return this.request.getAttribute(id);
            }
        }
        return this.request.getAttribute(id);
    }

    protected Object getParameter(String aName) {
        return this.request.getParameter(aName);
    }
}

