/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.AbstractAssertion;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyRegistry;
import org.apache.ws.policy.util.PolicyUtil;

public class PrimitiveAssertion
extends AbstractAssertion
implements Assertion {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private Assertion owner = null;
    private QName qname;
    private List terms = new ArrayList();
    private Hashtable attributes = new Hashtable();
    private boolean flag = false;
    private boolean isOptional = false;
    private String strValue = null;
    private Object value;

    public PrimitiveAssertion(QName qname) {
        this.qname = qname;
    }

    public PrimitiveAssertion(QName qname, Object value) {
        this.qname = qname;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public QName getName() {
        return this.qname;
    }

    public Assertion intersect(Assertion assertion, PolicyRegistry reg) {
        List primListB;
        List primListA;
        Assertion target;
        PrimitiveAssertion normalizedMe;
        this.log.debug((Object)"Enter: PrimitveAssertion:intersect");
        Assertion assertion2 = normalizedMe = this.isNormalized() ? this : this.normalize(reg);
        if (!(normalizedMe instanceof PrimitiveAssertion)) {
            return normalizedMe.intersect(assertion, reg);
        }
        Assertion assertion3 = target = assertion.isNormalized() ? assertion : assertion.normalize(reg);
        if (!(assertion instanceof PrimitiveAssertion)) {
            return normalizedMe.intersect(assertion, reg);
        }
        if (!(target instanceof PrimitiveAssertion)) {
            return target.intersect(normalizedMe, reg);
        }
        PrimitiveAssertion arg = (PrimitiveAssertion)target;
        PrimitiveAssertion self = normalizedMe;
        if (!self.getName().equals(arg.getName())) {
            return new XorCompositeAssertion();
        }
        if (self.getTerms().isEmpty() && arg.getTerms().isEmpty()) {
            AndCompositeAssertion assertion22 = new AndCompositeAssertion();
            assertion22.addTerm(self);
            assertion22.addTerm(arg);
            return assertion22;
        }
        if (self.getTerms().isEmpty() || arg.getTerms().isEmpty()) {
            return new XorCompositeAssertion();
        }
        List argChildTerms = arg.getTerms().get(0) instanceof Policy ? PolicyUtil.getPrimTermsList((Policy)arg.getTerms().get(0)) : arg.getTerms();
        List selfChildTerms = self.getTerms().get(0) instanceof Policy ? PolicyUtil.getPrimTermsList((Policy)self.getTerms().get(0)) : self.getTerms();
        PrimitiveAssertion PRIMITIVE_B2 = null;
        if (selfChildTerms.size() > argChildTerms.size()) {
            primListA = selfChildTerms;
            primListB = argChildTerms;
        } else {
            primListA = argChildTerms;
            primListB = selfChildTerms;
        }
        boolean isIntersect = false;
        for (PrimitiveAssertion PRIMITIVE_A : primListA) {
            boolean found = false;
            for (PrimitiveAssertion PRIMITIVE_B2 : primListB) {
                if (!PRIMITIVE_A.getName().equals(PRIMITIVE_B2.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                return new XorCompositeAssertion();
            }
            if (!(PRIMITIVE_A.intersect(PRIMITIVE_B2) instanceof XorCompositeAssertion)) continue;
            return new XorCompositeAssertion();
        }
        AndCompositeAssertion andCompositeAssertion = new AndCompositeAssertion();
        andCompositeAssertion.addTerm(arg);
        andCompositeAssertion.addTerm(self);
        return andCompositeAssertion;
    }

    public Assertion intersect(Assertion assertion) throws UnsupportedOperationException {
        return this.intersect(assertion, null);
    }

    public Assertion merge(Assertion assertion, PolicyRegistry reg) {
        Assertion target;
        PrimitiveAssertion normalizedMe;
        this.log.debug((Object)"Enter: PrimitveAssertion:merge");
        Assertion assertion2 = normalizedMe = this.isNormalized() ? this : this.normalize(reg);
        if (!(normalizedMe instanceof PrimitiveAssertion)) {
            return normalizedMe.merge(assertion, reg);
        }
        Assertion assertion3 = target = assertion.isNormalized() ? assertion : assertion.normalize(reg);
        if (!(target instanceof PrimitiveAssertion)) {
            return target.merge(normalizedMe, reg);
        }
        AndCompositeAssertion AND = new AndCompositeAssertion();
        AND.addTerm(target);
        AND.addTerm(normalizedMe);
        return AND;
    }

    public Assertion merge(Assertion assertion) {
        return this.merge(assertion, null);
    }

    public Assertion normalize() {
        return this.normalize(null);
    }

    public Assertion normalize(PolicyRegistry reg) {
        this.log.debug((Object)"Enter: PrimitveAssertion:normalize");
        if (this.isNormalized()) {
            return this;
        }
        if (this.isOptional()) {
            XorCompositeAssertion XOR = new XorCompositeAssertion();
            AndCompositeAssertion AND = new AndCompositeAssertion();
            PrimitiveAssertion PRIM = this.getSelfWithoutTerms();
            PRIM.removeAttribute(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Optional"));
            PRIM.setOptional(false);
            PRIM.setTerms(this.getTerms());
            AND.addTerm(PRIM);
            XOR.addTerm(AND);
            XOR.addTerm(new AndCompositeAssertion());
            return XOR.normalize(reg);
        }
        if (this.getTerms().isEmpty()) {
            PrimitiveAssertion PRIM = this.getSelfWithoutTerms();
            PRIM.setNormalized(true);
            return PRIM;
        }
        ArrayList<Assertion> policyTerms = new ArrayList<Assertion>();
        ArrayList<Assertion> nonPolicyTerms = new ArrayList<Assertion>();
        for (Assertion term : this.getTerms()) {
            if (term instanceof Policy) {
                policyTerms.add(term);
                continue;
            }
            if (term instanceof PrimitiveAssertion) {
                nonPolicyTerms.add(term);
                continue;
            }
            throw new RuntimeException();
        }
        if (policyTerms.isEmpty()) {
            PrimitiveAssertion PRIM = this.getSelfWithoutTerms();
            PRIM.setTerms(this.getTerms());
            PRIM.setNormalized(true);
            return PRIM;
        }
        Policy policyTerm = PolicyUtil.getSinglePolicy(policyTerms, reg);
        XorCompositeAssertion xorTerm = (XorCompositeAssertion)policyTerm.getTerms().get(0);
        List ANDs = xorTerm.getTerms();
        if (ANDs.size() == 0) {
            return new XorCompositeAssertion();
        }
        if (ANDs.size() == 1) {
            ((AndCompositeAssertion)ANDs.get(0)).addTerms(nonPolicyTerms);
            PrimitiveAssertion PRIM = this.getSelfWithoutTerms();
            PRIM.addTerm(policyTerm);
            return PRIM;
        }
        Policy nPOLICY = new Policy();
        XorCompositeAssertion nXOR = new XorCompositeAssertion();
        nPOLICY.addTerm(nXOR);
        Iterator iterator2 = ANDs.iterator();
        while (iterator2.hasNext()) {
            PrimitiveAssertion nPRIM = this.getSelfWithoutTerms();
            ArrayList<Assertion> list = new ArrayList<Assertion>();
            list.addAll(((AndCompositeAssertion)iterator2.next()).getTerms());
            if (!nonPolicyTerms.isEmpty()) {
                list.addAll(nonPolicyTerms);
            }
            nPRIM.addTerm(this.getSinglePolicy(list));
            AndCompositeAssertion AND = new AndCompositeAssertion();
            AND.addTerm(nPRIM);
            nXOR.addTerm(AND);
        }
        nPOLICY.setNormalized(true);
        return nPOLICY;
    }

    private PrimitiveAssertion getSelfWithoutTerms() {
        PrimitiveAssertion self = new PrimitiveAssertion(this.getName());
        self.setAttributes(this.getAttributes());
        self.setStrValue(this.getStrValue());
        return self;
    }

    public boolean hasParent() {
        return this.owner != null;
    }

    public Assertion getParent() {
        return this.owner;
    }

    public void setAttributes(Hashtable attributes) {
        this.attributes = attributes;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public void addAttribute(QName qname, Object value) {
        this.attributes.put(qname, value);
    }

    public String getAttribute(QName qname) {
        return (String)this.attributes.get(qname);
    }

    public void removeAttribute(QName qname) {
        this.attributes.remove(qname);
    }

    public void setParent(Assertion parent) {
        this.owner = parent;
    }

    public List getTerms() {
        return this.terms;
    }

    public void setTerms(List terms) {
        this.terms = terms;
    }

    public void addTerm(Assertion term) {
        this.terms.add(term);
    }

    public void addTerms(List terms) {
        terms.addAll(terms);
    }

    public boolean isNormalized() {
        return this.flag;
    }

    public void setNormalized(boolean flag) {
        for (Assertion assertion : this.getTerms()) {
            assertion.setNormalized(flag);
        }
        this.flag = flag;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public void setStrValue(String strValue) {
        this.strValue = strValue;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    private Policy getSinglePolicy(List policyList, PolicyRegistry reg) {
        Policy result = null;
        for (Policy policy : policyList) {
            result = result == null ? policy : (Policy)result.merge(policy, reg);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.terms.isEmpty();
    }

    public boolean remove(Assertion assertion) {
        return this.terms.remove(assertion);
    }

    public int size() {
        return this.terms.size();
    }

    private Policy getSinglePolicy(List childTerms) {
        Policy policy = new Policy();
        XorCompositeAssertion xor = new XorCompositeAssertion();
        AndCompositeAssertion and = new AndCompositeAssertion();
        and.addTerms(childTerms);
        xor.addTerm(and);
        policy.addTerm(xor);
        return policy;
    }

    private boolean isEmptyPolicy(Policy policy) {
        XorCompositeAssertion xor = (XorCompositeAssertion)policy.getTerms().get(0);
        return xor.isEmpty();
    }

    private List getTerms(Policy policy) {
        return ((AndCompositeAssertion)((XorCompositeAssertion)policy.getTerms().get(0)).getTerms().get(0)).getTerms();
    }

    public final short getType() {
        return 1;
    }
}

