/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.AbstractAssertion;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.CompositeAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyRegistry;

public class Policy
extends AbstractAssertion
implements CompositeAssertion {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private String xmlBase = null;
    private String id = null;

    public Policy() {
    }

    public Policy(String id) {
        this(null, id);
        this.setNormalized(false);
    }

    public Policy(String xmlBase, String id) {
        this.xmlBase = xmlBase;
        this.id = id;
        this.setNormalized(false);
    }

    public void setBase(String xmlBase) {
        this.xmlBase = xmlBase;
    }

    public String getBase() {
        return this.xmlBase;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getPolicyURI() {
        if (this.id != null) {
            if (this.xmlBase != null) {
                return this.xmlBase + "#" + this.id;
            }
            return "#" + this.id;
        }
        return null;
    }

    public Assertion normalize() {
        return this.normalize(null);
    }

    public Assertion normalize(PolicyRegistry reg) {
        this.log.debug((Object)"Enter: Policy::normalize");
        if (this.isNormalized()) {
            return this;
        }
        String xmlBase = this.getBase();
        String id = this.getId();
        Policy policy = new Policy(xmlBase, id);
        AndCompositeAssertion AND = new AndCompositeAssertion();
        XorCompositeAssertion XOR = new XorCompositeAssertion();
        ArrayList childAndTermList = new ArrayList();
        ArrayList<Assertion> childXorTermList = new ArrayList<Assertion>();
        for (Assertion term : this.getTerms()) {
            if ((term = term.normalize(reg)) instanceof Policy) {
                XorCompositeAssertion Xor = (XorCompositeAssertion)((Policy)term).getTerms().get(0);
                if (Xor.size() != 1) {
                    term = Xor;
                } else {
                    AND.addTerms(((AndCompositeAssertion)Xor.getTerms().get(0)).getTerms());
                    continue;
                }
            }
            if (term instanceof XorCompositeAssertion) {
                if (((XorCompositeAssertion)term).isEmpty()) {
                    XorCompositeAssertion emptyXor = new XorCompositeAssertion();
                    emptyXor.setNormalized(true);
                    policy.addTerm(emptyXor);
                    policy.setNormalized(true);
                    return policy;
                }
                childXorTermList.add(term);
                continue;
            }
            if (term instanceof AndCompositeAssertion) {
                if (((AndCompositeAssertion)term).isEmpty()) {
                    AndCompositeAssertion emptyAnd = new AndCompositeAssertion();
                    XOR.addTerm(emptyAnd);
                    continue;
                }
                AND.addTerms(((AndCompositeAssertion)term).getTerms());
                continue;
            }
            AND.addTerm(term);
        }
        if (childXorTermList.size() > 1) {
            for (int i = 0; i < childXorTermList.size(); ++i) {
                for (int j = i; j < childXorTermList.size(); ++j) {
                    if (i == j) continue;
                    XorCompositeAssertion xorTermA = (XorCompositeAssertion)childXorTermList.get(i);
                    XorCompositeAssertion xorTermB = (XorCompositeAssertion)childXorTermList.get(j);
                    for (Assertion andTermA : xorTermA.getTerms()) {
                        for (Assertion andTermB : xorTermB.getTerms()) {
                            AndCompositeAssertion anAndTerm = new AndCompositeAssertion();
                            anAndTerm.addTerms(andTermA.getTerms());
                            anAndTerm.addTerms(andTermB.getTerms());
                            XOR.addTerm(anAndTerm);
                        }
                    }
                }
            }
        } else if (childXorTermList.size() == 1) {
            Assertion xorTerm = (Assertion)childXorTermList.get(0);
            XOR.addTerms(xorTerm.getTerms());
        }
        if (childXorTermList.isEmpty()) {
            XorCompositeAssertion xor = new XorCompositeAssertion();
            xor.addTerm(AND);
            policy.addTerm(xor);
            policy.setNormalized(true);
            return policy;
        }
        List primTerms = AND.getTerms();
        for (Assertion anAndTerm : XOR.getTerms()) {
            anAndTerm.addTerms(primTerms);
        }
        policy.addTerm(XOR);
        policy.setNormalized(true);
        return policy;
    }

    public Assertion intersect(Assertion assertion, PolicyRegistry reg) {
        Policy normalizedMe;
        this.log.debug((Object)"Enter: Policy::intersect");
        Assertion assertion2 = normalizedMe = this.isNormalized() ? this : this.normalize(reg);
        if (!(normalizedMe instanceof Policy)) {
            return normalizedMe.intersect(assertion, reg);
        }
        Assertion target = assertion.isNormalized() ? assertion : assertion.normalize(reg);
        short type = target.getType();
        switch (type) {
            case 4: {
                Policy nPOLICY = new Policy();
                nPOLICY.addTerm(((XorCompositeAssertion)normalizedMe.getTerms().get(0)).intersect((XorCompositeAssertion)target.getTerms().get(0)));
                return nPOLICY;
            }
            case 3: {
                Policy nPOLICY = new Policy();
                nPOLICY.addTerm(((XorCompositeAssertion)normalizedMe.getTerms().get(0)).intersect(target));
                return nPOLICY;
            }
            case 2: {
                Policy nPOLICY = new Policy();
                nPOLICY.addTerm(((XorCompositeAssertion)normalizedMe.getTerms().get(0)).intersect(target));
                return nPOLICY;
            }
            case 1: {
                Policy nPOLICY = new Policy();
                nPOLICY.addTerm(((XorCompositeAssertion)normalizedMe.getTerms().get(0)).intersect(target));
                return nPOLICY;
            }
        }
        throw new IllegalArgumentException("intersect is not defined for " + target.getClass().getName() + " type");
    }

    public Assertion merge(Assertion assertion, PolicyRegistry reg) {
        Policy normalizedMe;
        this.log.debug((Object)"Enter: Policy::merge");
        Assertion assertion2 = normalizedMe = this.isNormalized() ? this : this.normalize(reg);
        if (!(normalizedMe instanceof Policy)) {
            return normalizedMe.merge(assertion, reg);
        }
        Policy nPOLICY = new Policy();
        Assertion target = assertion.isNormalized() ? assertion : assertion.normalize(reg);
        short type = target.getType();
        switch (type) {
            case 4: {
                nPOLICY.addTerm(((XorCompositeAssertion)normalizedMe.getTerms().get(0)).merge((XorCompositeAssertion)target.getTerms().get(0)));
                return nPOLICY;
            }
            case 3: {
                nPOLICY.addTerm(((XorCompositeAssertion)normalizedMe.getTerms().get(0)).merge(target));
                return nPOLICY;
            }
            case 2: {
                nPOLICY.addTerm(((XorCompositeAssertion)normalizedMe.getTerms().get(0)).merge(target));
                return nPOLICY;
            }
            case 1: {
                nPOLICY.addTerm(((XorCompositeAssertion)normalizedMe.getTerms().get(0)).merge(target));
                return nPOLICY;
            }
        }
        throw new IllegalArgumentException(" merge for " + target.getClass().getName() + " not defined");
    }

    public final short getType() {
        return 4;
    }
}

