/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.access.exception.ObjectNotFoundException;
import org.apache.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheFactory;
import org.apache.jcs.auxiliary.remote.RemoteCacheInfo;
import org.apache.jcs.auxiliary.remote.RemoteCacheMonitor;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.behavior.ICache;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.behavior.IZombie;

public class RemoteCache
implements ICache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCache == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCache = RemoteCache.class$("org.apache.jcs.auxiliary.remote.RemoteCache")) : class$org$apache$jcs$auxiliary$remote$RemoteCache));
    final String cacheName;
    private IRemoteCacheService remote;
    private IRemoteCacheAttributes irca;
    IElementAttributes attr = null;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCache;

    public String toString() {
        return "RemoteCache: " + this.cacheName;
    }

    public RemoteCache(IRemoteCacheAttributes cattr, IRemoteCacheService remote) {
        this.irca = cattr;
        this.cacheName = cattr.getCacheName();
        this.remote = remote;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Construct> cacheName=" + cattr.getCacheName()));
            log.debug((Object)("irca = " + this.irca.toString()));
        }
    }

    public void setElementAttributes(IElementAttributes attr) {
        this.attr = attr;
    }

    public IElementAttributes getElementAttributes() {
        return this.attr;
    }

    public void update(ICacheElement ce) throws IOException {
        if (!this.irca.getGetOnly()) {
            try {
                this.remote.update(ce, RemoteCacheInfo.listenerId);
            }
            catch (NullPointerException npe) {
                log.error((Object)("npe for ce = " + ce + "ce.attr = " + ce.getElementAttributes()), (Throwable)npe);
                return;
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to put " + ce.getKey() + " to " + ce.getCacheName());
            }
        }
    }

    public ICacheElement get(Serializable key) throws IOException {
        try {
            return this.remote.get(this.cacheName, this.sanitized(key));
        }
        catch (ObjectNotFoundException one) {
            log.debug((Object)("didn't find element " + key + " in remote"));
            return null;
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to get " + key + " from " + this.cacheName);
            return null;
        }
    }

    public Set getGroupKeys(String groupName) {
        return this.remote.getGroupKeys(this.cacheName, groupName);
    }

    private Serializable sanitized(Serializable s) throws IOException {
        return s;
    }

    public boolean remove(Serializable key) throws IOException {
        block3: {
            if (this.irca.getGetOnly()) break block3;
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove> key=" + key));
            }
            try {
                this.remote.remove(this.cacheName, this.sanitized(key), RemoteCacheInfo.listenerId);
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove " + key + " from " + this.cacheName);
            }
        }
        return false;
    }

    public void removeAll() throws IOException {
        block2: {
            if (this.irca.getRemoteType() == 1 || this.irca.getGetOnly()) break block2;
            try {
                this.remote.removeAll(this.cacheName, RemoteCacheInfo.listenerId);
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove all from " + this.cacheName);
            }
        }
    }

    public void dispose() throws IOException {
        log.debug((Object)"disposing of remote cache");
        try {
            this.remote.dispose(this.cacheName);
        }
        catch (Exception ex) {
            log.error((Object)"couldn't dispose");
            this.handleException(ex, "Failed to dispose " + this.cacheName);
        }
    }

    public int getStatus() {
        return this.remote instanceof IZombie ? 3 : 1;
    }

    public int getSize() {
        return 0;
    }

    public int getCacheType() {
        return 4;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void fixCache(IRemoteCacheService remote) {
        this.remote = remote;
    }

    private void handleException(Exception ex, String msg) throws IOException {
        log.error((Object)("Disabling remote cache due to error " + msg));
        log.error((Object)ex.toString());
        this.remote = new ZombieRemoteCacheService();
        RemoteCacheMonitor.getInstance().notifyError();
        RemoteCacheNoWaitFacade rcnwf = (RemoteCacheNoWaitFacade)RemoteCacheFactory.facades.get(this.irca.getCacheName());
        log.debug((Object)("Initiating failover, rcnf = " + rcnwf));
        if (rcnwf != null) {
            RemoteCacheAttributes cfr_ignored_0 = rcnwf.rca;
            if (rcnwf.rca.getRemoteType() == 0) {
                log.debug((Object)"found facade calling failover");
                rcnwf.failover(0);
            }
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

