/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp.asn1;

import java.math.BigInteger;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class BerEncoder
implements AsnEncoder {
    private static final byte LONG_LENGTH = -128;
    private static final byte HIGH_BIT = -128;
    private static final byte EXTENSION_ID = 31;
    private static final byte CONSTRUCTOR = 32;

    protected static int byteToInt(byte b) {
        return 0xFF & b;
    }

    protected static long byteToLong(byte b) {
        return 0xFFL & (long)b;
    }

    protected static boolean isConstructor(byte b) {
        return (b & 0x20) == 32;
    }

    protected static boolean isExtensionId(byte b) {
        return (b & 0x1F) == 31;
    }

    protected static void rotate(byte[] buf, int begin, int pivot, int end) throws ArrayIndexOutOfBoundsException {
        int dist = end - pivot;
        byte[] hold = new byte[dist];
        System.arraycopy(buf, pivot, hold, 0, dist);
        System.arraycopy(buf, begin, buf, begin + dist, pivot - begin);
        System.arraycopy(hold, 0, buf, begin, dist);
    }

    public int buildLength(byte[] buf, int startOffset, int asnLength) throws AsnEncodingException {
        if (asnLength <= 127) {
            if (buf.length - startOffset < 1) {
                throw new AsnEncodingException("Buffer overflow error");
            }
            buf[startOffset++] = (byte)(asnLength & 0x7F);
        } else if (asnLength <= 255) {
            if (buf.length - startOffset < 2) {
                throw new AsnEncodingException("Buffer overflow error");
            }
            buf[startOffset++] = -127;
            buf[startOffset++] = (byte)(asnLength & 0xFF);
        } else {
            if (buf.length - startOffset < 3) {
                throw new AsnEncodingException("Buffer overflow error");
            }
            buf[startOffset++] = -126;
            buf[startOffset++] = (byte)(asnLength >>> 8 & 0xFF);
            buf[startOffset++] = (byte)(asnLength & 0xFF);
        }
        return startOffset;
    }

    public Object[] parseLength(byte[] buf, int startOffset) throws AsnDecodingException {
        byte numBytes;
        if (buf.length - startOffset < 1) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        Object[] retVals = new Object[2];
        if (((numBytes = buf[startOffset++]) & 0xFFFFFF80) == 0) {
            numBytes = (byte)(numBytes & 0x7F);
            retVals[1] = new Integer(BerEncoder.byteToInt(numBytes));
        } else if ((numBytes = (byte)(numBytes & 0x7F)) == 1) {
            if (buf.length - startOffset < 1) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            retVals[1] = new Integer(BerEncoder.byteToInt(buf[startOffset++]));
        } else if (numBytes == 2) {
            if (buf.length - startOffset < 2) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            int val = BerEncoder.byteToInt(buf[startOffset++]) << 8 | BerEncoder.byteToInt(buf[startOffset++]);
            retVals[1] = new Integer(val);
        } else {
            throw new AsnDecodingException("Invalid ASN.1 length");
        }
        retVals[0] = new Integer(startOffset);
        return retVals;
    }

    public int buildHeader(byte[] buf, int startOffset, byte asnType, int asnLength) throws AsnEncodingException {
        if (buf.length - startOffset < 1) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        buf[startOffset++] = asnType;
        return this.buildLength(buf, startOffset, asnLength);
    }

    public Object[] parseHeader(byte[] buf, int startOffset) throws AsnDecodingException {
        byte asnType;
        if (buf.length - startOffset < 1) {
            throw new AsnDecodingException("Insufficent buffer length");
        }
        if (BerEncoder.isExtensionId(asnType = buf[startOffset++])) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        Object[] lenVals = this.parseLength(buf, startOffset);
        Object[] rVals = new Object[]{lenVals[0], new Byte(asnType), lenVals[1]};
        return rVals;
    }

    public int buildInteger32(byte[] buf, int startOffset, byte asnType, int asnInt32) throws AsnEncodingException {
        int mask = -8388608;
        int intSz = 4;
        while (((asnInt32 & mask) == 0 || (asnInt32 & mask) == mask) && intSz > 1) {
            --intSz;
            asnInt32 <<= 8;
        }
        if (buf.length - (startOffset = this.buildHeader(buf, startOffset, asnType, intSz)) < intSz) {
            throw new AsnEncodingException("Insufficent buffer size");
        }
        mask = -16777216;
        while (intSz-- > 0) {
            byte b = (byte)((asnInt32 & mask) >>> 24);
            buf[startOffset++] = b;
            asnInt32 <<= 8;
        }
        return startOffset;
    }

    public Object[] parseInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (asnLength > 4) {
            throw new AsnDecodingException("Integer too large: cannot decode");
        }
        int asnValue = 0;
        if ((buf[startOffset] & 0xFFFFFF80) == -128) {
            asnValue = -1;
        }
        while (asnLength-- > 0) {
            asnValue = asnValue << 8 | BerEncoder.byteToInt(buf[startOffset++]);
        }
        Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Integer(asnValue)};
        return rVals;
    }

    public int buildUInteger32(byte[] buf, int startOffset, byte asnType, long asnUInt32) throws AsnEncodingException {
        long mask = 0xFF800000L;
        int intSz = 4;
        boolean bAddNullByte = false;
        if (asnUInt32 > Integer.MAX_VALUE) {
            bAddNullByte = true;
            ++intSz;
        }
        while ((asnUInt32 & mask) == 0L && intSz > 1) {
            --intSz;
            asnUInt32 <<= 8;
        }
        if (buf.length - (startOffset = this.buildHeader(buf, startOffset, asnType, intSz)) < intSz) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        if (bAddNullByte) {
            buf[startOffset++] = 0;
            --intSz;
        }
        mask = 0xFF000000L;
        while (intSz-- > 0) {
            byte b = (byte)((asnUInt32 & mask) >>> 24);
            buf[startOffset++] = b;
            asnUInt32 <<= 8;
        }
        return startOffset;
    }

    public Object[] parseUInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (asnLength > 5) {
            throw new AsnDecodingException("Integer too large: cannot decode");
        }
        long asnValue = 0L;
        if ((buf[startOffset] & 0xFFFFFF80) == -128) {
            asnValue = -1L;
        }
        while (asnLength-- > 0) {
            asnValue = asnValue << 8 | BerEncoder.byteToLong(buf[startOffset++]);
        }
        Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Long(asnValue &= 0xFFFFFFFFL)};
        return rVals;
    }

    public int buildUInteger64(byte[] buf, int startOffset, byte asnType, BigInteger asnUInt64) throws AsnEncodingException {
        byte[] bytes = asnUInt64.toByteArray();
        if (buf.length - (startOffset = this.buildHeader(buf, startOffset, asnType, bytes.length)) < bytes.length) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        for (int i = 0; i < bytes.length; ++i) {
            buf[startOffset++] = bytes[i];
        }
        return startOffset;
    }

    public Object[] parseUInteger64(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (asnLength > 9) {
            throw new AsnDecodingException("Integer too large: cannot decode");
        }
        byte[] asnBuf = new byte[asnLength];
        for (int i = 0; i < asnLength; ++i) {
            asnBuf[i] = buf[startOffset++];
        }
        BigInteger asnValue = new BigInteger(asnBuf);
        Object[] rVals = new Object[]{new Integer(startOffset), asnType, asnValue};
        return rVals;
    }

    public int buildNull(byte[] buf, int startOffset, byte asnType) throws AsnEncodingException {
        return this.buildHeader(buf, startOffset, asnType, 0);
    }

    public Object[] parseNull(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        if ((Integer)hdrVals[2] != 0) {
            throw new AsnDecodingException("Malformed ASN.1 Type");
        }
        Object[] rVals = new Object[]{hdrVals[0], hdrVals[1]};
        return rVals;
    }

    public int buildString(byte[] buf, int startOffset, byte asnType, byte[] opaque) throws AsnEncodingException {
        int asnLength = opaque.length;
        if (buf.length - (startOffset = this.buildHeader(buf, startOffset, asnType, asnLength)) < opaque.length) {
            throw new AsnEncodingException("Insufficent buffer length");
        }
        try {
            System.arraycopy(opaque, 0, buf, startOffset, opaque.length);
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        return startOffset + opaque.length;
    }

    public Object[] parseString(byte[] buf, int startOffset) throws AsnDecodingException {
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Insufficent buffer length");
        }
        byte[] opaque = new byte[asnLength];
        try {
            System.arraycopy(buf, startOffset, opaque, 0, asnLength);
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw new AsnDecodingException("Buffer underflow exception");
        }
        Object[] rVals = new Object[]{new Integer(startOffset + asnLength), asnType, opaque};
        return rVals;
    }

    public int buildObjectId(byte[] buf, int startOffset, byte asnType, int[] oids) throws AsnEncodingException {
        if (buf.length - startOffset < 1) {
            throw new AsnEncodingException("Buffer overflow error");
        }
        int[] toEncode = oids;
        int begin = startOffset;
        if (oids.length < 2) {
            toEncode = new int[]{0, 0};
        }
        if (toEncode[0] < 0 || toEncode[0] > 2) {
            throw new AsnEncodingException("Invalid Object Identifier");
        }
        if (toEncode[1] < 0 || toEncode[1] > 40) {
            throw new AsnEncodingException("Invalid Object Identifier");
        }
        buf[startOffset++] = (byte)(toEncode[0] * 40 + toEncode[1]);
        int oidNdx = 2;
        while (oidNdx < toEncode.length) {
            int oid;
            if ((oid = toEncode[oidNdx++]) >= 0 && oid < 127) {
                if (buf.length - startOffset < 1) {
                    throw new AsnEncodingException("Buffer overflow error");
                }
                buf[startOffset++] = (byte)oid;
                continue;
            }
            int mask = 0;
            int bits = 0;
            int tmask = 0;
            int tbits = 0;
            tmask = 127;
            tbits = 0;
            while (tmask != 0) {
                if ((oid & tmask) != 0) {
                    mask = tmask;
                    bits = tbits;
                }
                tmask <<= 7;
                tbits += 7;
            }
            while (mask != 127) {
                if (buf.length - startOffset < 1) {
                    throw new AsnEncodingException("Buffer overflow error");
                }
                buf[startOffset++] = (byte)((oid & mask) >>> bits | 0xFFFFFF80);
                bits -= 7;
                if ((mask >>>= 7) != 0x1E00000) continue;
                mask = 0xFE00000;
            }
            if (buf.length - startOffset < 1) {
                throw new AsnEncodingException("Insufficent buffer space");
            }
            buf[startOffset++] = (byte)(oid & mask);
        }
        int pivot = startOffset;
        int asnLength = pivot - begin;
        int end = this.buildHeader(buf, pivot, asnType, asnLength);
        try {
            BerEncoder.rotate(buf, begin, pivot, end);
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw new AsnEncodingException("Insufficent buffer space");
        }
        return end;
    }

    public Object[] parseObjectId(byte[] buf, int startOffset) throws AsnDecodingException {
        int[] retOids;
        Object[] hdrVals = this.parseHeader(buf, startOffset);
        startOffset = (Integer)hdrVals[0];
        Byte asnType = (Byte)hdrVals[1];
        int asnLength = (Integer)hdrVals[2];
        if (buf.length - startOffset < asnLength) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (asnLength == 0) {
            int[] ids = new int[2];
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, ids};
            return rVals;
        }
        int idsOff = 0;
        int[] ids = new int[asnLength + 1];
        --asnLength;
        int oid = BerEncoder.byteToInt(buf[startOffset++]);
        ids[idsOff++] = oid / 40;
        ids[idsOff++] = oid % 40;
        while (asnLength > 0) {
            oid = 0;
            boolean done = false;
            do {
                --asnLength;
                byte b = buf[startOffset++];
                oid = oid << 7 | b & 0x7F;
                if ((b & 0xFFFFFF80) != 0) continue;
                done = true;
            } while (!done);
            ids[idsOff++] = oid;
        }
        if (idsOff == ids.length) {
            retOids = ids;
        } else {
            retOids = new int[idsOff];
            System.arraycopy(ids, 0, retOids, 0, idsOff);
        }
        Object[] rVals = new Object[]{new Integer(startOffset), asnType, retOids};
        return rVals;
    }
}

