/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling.impl.runtime;

import java.lang.reflect.Method;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.MapEntry;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtUtil;

public class RtCharactersHandler
extends CharactersHandler {
    public static final RtCharactersHandler INSTANCE = new RtCharactersHandler();

    public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
        Object unmarshalled = null;
        if (valueMetaData != null) {
            Method method;
            Class<?> cls;
            String parseMethod = valueMetaData.getUnmarshalMethod();
            if (parseMethod == null) {
                throw new JBossXBRuntimeException("javaType annotation is specified for " + qName + " but does not contain parseMethod attribute");
            }
            int lastDot = parseMethod.lastIndexOf(46);
            String clsName = parseMethod.substring(0, lastDot);
            try {
                cls = Thread.currentThread().getContextClassLoader().loadClass(clsName);
            }
            catch (ClassNotFoundException e) {
                throw new JBossXBRuntimeException("Failed to load class " + clsName + " for parseMethod " + parseMethod);
            }
            String methodName = parseMethod.substring(lastDot + 1);
            try {
                method = cls.getMethod(methodName, String.class, NamespaceContext.class);
            }
            catch (NoSuchMethodException e) {
                throw new JBossXBRuntimeException("Failed to find method " + methodName + "(" + String.class.getName() + " p1, " + NamespaceContext.class.getName() + " p2) in " + cls);
            }
            try {
                unmarshalled = method.invoke(null, value, nsCtx);
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("Failed to invoke parseMethod " + parseMethod + " for element " + qName + " and value " + value + ": " + e.getMessage(), e);
            }
        }
        unmarshalled = super.unmarshal(qName, typeBinding, nsCtx, valueMetaData, value);
        return unmarshalled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(QName qName, ElementBinding element, Object owner, Object value) {
        if (owner == null) return;
        if (owner instanceof MapEntry) {
            TypeBinding type = element.getType();
            CharactersMetaData characters = type.getCharactersMetaData();
            if (characters == null) throw new JBossXBRuntimeException("Parent object is a map entry but characters of element " + qName + " of type " + type.getQName() + " were bound to niether key nor value in a map entry.");
            if (characters.isMapEntryKey()) {
                ((MapEntry)owner).setKey(value);
                return;
            } else {
                if (!characters.isMapEntryValue()) throw new JBossXBRuntimeException("Parent object is a map entry but characters of element " + qName + " of type " + type.getQName() + " were bound to niether key nor value in a map entry.");
                ((MapEntry)owner).setValue(value);
            }
            return;
        } else {
            String propName = null;
            String colType = null;
            TypeBinding type = element.getType();
            if (type != null && !type.isSimple()) {
                PropertyMetaData propertyMetaData = type.getPropertyMetaData();
                if (propertyMetaData == null) {
                    CharactersMetaData charactersMetaData = type.getCharactersMetaData();
                    PropertyMetaData propertyMetaData2 = propertyMetaData = charactersMetaData == null ? null : charactersMetaData.getProperty();
                }
                if (propertyMetaData != null) {
                    propName = propertyMetaData.getName();
                    colType = propertyMetaData.getCollectionType();
                }
                if (propName == null) {
                    propName = "value";
                }
            } else {
                PropertyMetaData PropertyMetaData2 = element.getPropertyMetaData();
                if (PropertyMetaData2 != null) {
                    propName = PropertyMetaData2.getName();
                    colType = PropertyMetaData2.getCollectionType();
                }
                if (propName == null) {
                    propName = Util.xmlNameToFieldName(qName.getLocalPart(), element.getSchema().isIgnoreLowLine());
                }
            }
            RtUtil.set(owner, value, propName, colType, element.getSchema().isIgnoreUnresolvedFieldOrClass(), element.getValueAdapter());
        }
    }
}

