/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.custom.tree2.UITreeData;

public class HtmlTree
extends UITreeData {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlTree2";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.HtmlTree2";
    private UICommand _expandControl;
    private String _varNodeToggler;
    private Boolean _showNav;
    private Boolean _showLines;
    private Boolean _clientSideToggle;
    private Boolean _showRootNode;
    private Boolean _preserveToggle;
    private String _javascriptLocation;
    private String _imageLocation;

    public HtmlTree() {
        this.setRendererType("org.apache.myfaces.HtmlTree2");
        this._expandControl = new HtmlCommandLink();
        this._expandControl.setParent((UIComponent)this);
        this._clientSideToggle = Boolean.TRUE;
        this._preserveToggle = Boolean.TRUE;
        this._showRootNode = Boolean.TRUE;
        this._showNav = Boolean.TRUE;
        this._showLines = Boolean.TRUE;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._varNodeToggler, this._showLines, this._showNav, this._clientSideToggle, this._showRootNode, this._preserveToggle, this._javascriptLocation, this._imageLocation};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.setVarNodeToggler((String)values[1]);
        this.setShowLines((Boolean)values[2]);
        this.setShowNav((Boolean)values[3]);
        this.setClientSideToggle((Boolean)values[4]);
        this.setShowRootNode((Boolean)values[5]);
        this.setPreserveToggle((Boolean)values[6]);
        this.setJavascriptLocation((String)values[7]);
        this.setImageLocation((String)values[8]);
    }

    public void setNodeId(String nodeId) {
        super.setNodeId(nodeId);
        if (this._varNodeToggler != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            requestMap.put(this._varNodeToggler, this);
        }
    }

    public UICommand getExpandControl() {
        return this._expandControl;
    }

    public void setVarNodeToggler(String varNodeToggler) {
        this._varNodeToggler = varNodeToggler;
        String bindingString = "#{" + varNodeToggler + ".toggleExpanded}";
        MethodBinding actionBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(bindingString, null);
        this._expandControl.setAction(actionBinding);
    }

    public void setShowNav(boolean showNav) {
        this._showNav = showNav;
    }

    public boolean isShowNav() {
        if (this._showNav != null) {
            return this._showNav;
        }
        ValueBinding vb = this.getValueBinding("showNav");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v == null || v != false;
    }

    public void setShowLines(boolean showLines) {
        this._showLines = showLines;
    }

    public boolean isShowLines() {
        if (this._showLines != null) {
            return this._showLines;
        }
        ValueBinding vb = this.getValueBinding("showLines");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v == null || v != false;
    }

    public void setClientSideToggle(boolean clientSideToggle) {
        this._clientSideToggle = clientSideToggle;
    }

    public boolean isClientSideToggle() {
        if (this._clientSideToggle != null) {
            return this._clientSideToggle;
        }
        ValueBinding vb = this.getValueBinding("clientSideToggle");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v == null || v != false;
    }

    public void setShowRootNode(boolean showRootNode) {
        this._showRootNode = showRootNode;
    }

    public boolean isShowRootNode() {
        if (this._showRootNode != null) {
            return this._showRootNode;
        }
        ValueBinding vb = this.getValueBinding("showRootNode");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v == null || v != false;
    }

    public void setPreserveToggle(boolean preserveToggle) {
        this._preserveToggle = preserveToggle;
    }

    public boolean isPreserveToggle() {
        if (this._preserveToggle != null) {
            return this._preserveToggle;
        }
        ValueBinding vb = this.getValueBinding("preserveToggle");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v == null || v != false;
    }

    public void setJavascriptLocation(String javascriptLocation) {
        this._javascriptLocation = javascriptLocation;
    }

    public String getJavascriptLocation() {
        if (this._javascriptLocation != null) {
            return this._javascriptLocation;
        }
        ValueBinding vb = this.getValueBinding("javascriptLocation");
        if (vb == null) {
            return null;
        }
        return (String)vb.getValue(this.getFacesContext());
    }

    public void setImageLocation(String imageLocation) {
        this._imageLocation = imageLocation;
    }

    public String getImageLocation() {
        if (this._imageLocation != null) {
            return this._imageLocation;
        }
        ValueBinding vb = this.getValueBinding("imageLocation");
        if (vb == null) {
            return null;
        }
        return (String)vb.getValue(this.getFacesContext());
    }
}

