/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import xdoclet.DocletContext;
import xdoclet.XDocletException;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.template.TemplateException;
import xdoclet.util.Translator;
import xjavadoc.ClassIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XJavaDoc;
import xjavadoc.XPackage;

public class PackageTagsHandler
extends AbstractProgramElementTagsHandler {
    static /* synthetic */ Class class$xdoclet$XDocletMessages;

    public static String getPackageNameFor(XPackage pak, boolean withSubstitution) {
        return PackageTagsHandler.getPackageNameFor(pak.getName(), withSubstitution);
    }

    public static String getPackageNameFor(String packageName) {
        return PackageTagsHandler.getPackageNameFor(packageName, true);
    }

    public static String getPackageNameFor(String packageName, boolean withSubstitution) {
        ArrayList packageSubstitutions = PackageTagsHandler.getPackageSubstitutions(DocletContext.getInstance().getActiveSubTask().getSubTaskName());
        if (packageSubstitutions == null || !withSubstitution) {
            return packageName;
        }
        int i = 0;
        while (i < packageSubstitutions.size()) {
            PackageSubstitution ps = (PackageSubstitution)packageSubstitutions.get(i);
            StringTokenizer st = new StringTokenizer(ps.getPackages(), ",", false);
            while (st.hasMoreTokens()) {
                String packages = st.nextToken();
                String suffix = "." + packages;
                if (!packageName.endsWith(suffix)) continue;
                packageName = packageName.substring(0, packageName.length() - suffix.length()) + '.' + ps.getSubstituteWith();
                break;
            }
            ++i;
        }
        return packageName;
    }

    public static ArrayList getPackageSubstitutions(String subtaskName) {
        ArrayList packageSubstitutions = null;
        boolean supportsPackageSubstitutionInheritance = true;
        Boolean supports = (Boolean)DocletContext.getInstance().getConfigParam(subtaskName + ".packageSubstitutionInheritanceSupported");
        if (supports != null) {
            supportsPackageSubstitutionInheritance = supports;
        }
        packageSubstitutions = (ArrayList)DocletContext.getInstance().getConfigParam(subtaskName + ".packageSubstitutions");
        if (supportsPackageSubstitutionInheritance && (packageSubstitutions == null || packageSubstitutions.isEmpty())) {
            packageSubstitutions = (ArrayList)DocletContext.getInstance().getConfigParam("packageSubstitutions");
        }
        return packageSubstitutions;
    }

    public static String packageNameAsPathFor(XPackage pak) {
        return PackageTagsHandler.getPackageNameFor(pak, true).replace('.', '/');
    }

    public static String packageNameAsPathWithoutSubstitutionFor(XPackage pak) {
        return PackageTagsHandler.getPackageNameFor(pak, false).replace('.', '/');
    }

    public static String packageNameAsPathFor(String qualifiedName) {
        return qualifiedName.replace('.', '/');
    }

    public String packageName() throws XDocletException {
        if (PackageTagsHandler.getCurrentPackage() != null) {
            return PackageTagsHandler.getCurrentPackage().getName();
        }
        return PackageTagsHandler.getCurrentClass().getContainingPackage().getName();
    }

    public void packageOf(String template) throws XDocletException {
        try {
            String fullClassName = this.getEngine().outputOf(template);
            this.getEngine().print(PackageTagsHandler.getPackageNameFor(fullClassName.substring(0, fullClassName.lastIndexOf(46)), true));
        }
        catch (TemplateException ex) {
            Class clazz = class$xdoclet$XDocletMessages;
            if (clazz == null) {
                clazz = class$xdoclet$XDocletMessages = PackageTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
            }
            throw new XDocletException(ex, Translator.getString(clazz, "METHOD_FAILED", new String[]{"packageOf"}));
        }
    }

    public void forAllPackages(String template, Properties attributes) throws XDocletException {
        Collection classes = XJavaDoc.getInstance().getSourceClasses();
        TreeSet<XPackage> packages = new TreeSet<XPackage>();
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            XClass clazz = i.next();
            packages.add(clazz.getContainingPackage());
        }
        XPackage currentPackage = null;
        Iterator packageIterator = packages.iterator();
        while (packageIterator.hasNext()) {
            currentPackage = (XPackage)packageIterator.next();
            PackageTagsHandler.setCurrentPackage(currentPackage);
            this.generate(template);
        }
        PackageTagsHandler.setCurrentPackage(null);
    }

    public String packageNameAsPath() throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor(this.packageName());
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class PackageSubstitution
    implements Serializable {
        private String packages;
        private String substituteWith;

        public String getPackages() {
            return this.packages;
        }

        public String getSubstituteWith() {
            return this.substituteWith;
        }

        public void setPackages(String packages) {
            this.packages = packages;
        }

        public void setSubstituteWith(String substituteWith) {
            this.substituteWith = substituteWith;
        }

        private final /* synthetic */ void this() {
            this.packages = null;
            this.substituteWith = null;
        }

        public PackageSubstitution() {
            this.this();
        }
    }
}

