/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import xdoclet.DocletSupport;
import xdoclet.XDocletException;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.tagshandler.TypeTagsHandler;
import xdoclet.template.TemplateEngine;
import xdoclet.template.TemplateException;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.ClassIterator;
import xjavadoc.PackageIterator;
import xjavadoc.TagIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XJavaDoc;
import xjavadoc.XMethod;
import xjavadoc.XPackage;
import xjavadoc.XTag;

public class ClassTagsHandler
extends AbstractProgramElementTagsHandler {
    protected static final DateFormat dateFormatter = DateFormat.getDateTimeInstance();
    protected static final Calendar now = Calendar.getInstance();
    static /* synthetic */ Class class$xdoclet$tagshandler$ClassTagsHandler;
    static /* synthetic */ Class class$xdoclet$XDocletMessages;

    public static String getClassNameFor(XClass clazz) {
        return clazz.getName();
    }

    public static String getFullClassNameFor(XClass clazz) {
        if (clazz.getContainingClass() != null) {
            return clazz.getContainingClass().getQualifiedName();
        }
        return clazz.getQualifiedName();
    }

    public static void forAllDistinctClassTags(TemplateEngine engine, String template, String tagName, String paramName) throws XDocletException {
        HashSet<String> tagKeys = new HashSet<String>();
        Class clazz = class$xdoclet$tagshandler$ClassTagsHandler;
        if (clazz == null) {
            clazz = class$xdoclet$tagshandler$ClassTagsHandler = ClassTagsHandler.class$("[Lxdoclet.tagshandler.ClassTagsHandler;", false);
        }
        Log log = LogUtil.getLog(clazz, "forAllDistinctClassTags");
        try {
            Collection classes = XJavaDoc.getInstance().getSourceClasses();
            ClassIterator i = XCollections.classIterator((Collection)classes);
            while (i.hasNext()) {
                XClass clazz2 = i.next();
                ClassTagsHandler.setCurrentClass(clazz2);
                Collection tags = clazz2.getDoc().getTags(tagName);
                if (tags == null) continue;
                TagIterator j = XCollections.tagIterator((Collection)tags);
                while (j.hasNext()) {
                    XTag tag = j.next();
                    ClassTagsHandler.setCurrentClassTag(tag);
                    if (!tagKeys.contains(tag.getAttributeValue(paramName))) {
                        tagKeys.add(tag.getAttributeValue(paramName));
                        engine.generate(template);
                        continue;
                    }
                    Class clazz3 = class$xdoclet$XDocletMessages;
                    if (clazz3 == null) {
                        clazz3 = ClassTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
                    }
                    log.warn((Object)Translator.getString(clazz3, "DUPLICATED_TAG", new String[]{tagName, paramName, tag.getAttributeValue(paramName)}));
                }
            }
        }
        catch (TemplateException e) {
            if (e instanceof XDocletException) {
                throw (XDocletException)e;
            }
            Class clazz4 = class$xdoclet$XDocletMessages;
            if (clazz4 == null) {
                clazz4 = class$xdoclet$XDocletMessages = ClassTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
            }
            throw new XDocletException(e, Translator.getString(clazz4, "RUNNING_FAILED"));
        }
    }

    public void forAllDistinctClassTags(String template, Properties attributes) throws XDocletException {
        String tagName = attributes.getProperty("tagName");
        String paramName = attributes.getProperty("paramName");
        ClassTagsHandler.forAllDistinctClassTags(this.getEngine(), template, tagName, paramName);
    }

    public String className() throws XDocletException {
        return ClassTagsHandler.getCurrentClass().getName();
    }

    public String fullClassName() throws XDocletException {
        return ClassTagsHandler.getCurrentClass().getQualifiedName();
    }

    public String fullSuperclassName() throws XDocletException {
        return ClassTagsHandler.getFullSuperclassNameFor(ClassTagsHandler.getCurrentClass());
    }

    public void classOf(String template) throws XDocletException {
        try {
            String fullClassName = this.getEngine().outputOf(template);
            String result = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            this.getEngine().print(result);
        }
        catch (TemplateException ex) {
            Class clazz = class$xdoclet$XDocletMessages;
            if (clazz == null) {
                clazz = class$xdoclet$XDocletMessages = ClassTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
            }
            throw new XDocletException(ex, Translator.getString(clazz, "METHOD_FAILED", new String[]{"ClassTagsHandler.classOf"}));
        }
    }

    public void ifIsClassAbstract(String template) throws XDocletException {
        if (ClassTagsHandler.getCurrentClass().isAbstract()) {
            this.generate(template);
        }
    }

    public void ifIsClassNotAbstract(String template) throws XDocletException {
        if (!ClassTagsHandler.getCurrentClass().isAbstract()) {
            this.generate(template);
        }
    }

    public void pushClass(String template, Properties attributes) throws XDocletException {
        String value = attributes.getProperty("value", null);
        XClass currentClass = null;
        if (value == null) {
            try {
                value = this.getEngine().outputOf(template);
            }
            catch (TemplateException ex) {
                Class clazz = class$xdoclet$XDocletMessages;
                if (clazz == null) {
                    clazz = class$xdoclet$XDocletMessages = ClassTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
                }
                throw new XDocletException(ex, Translator.getString(clazz, "METHOD_FAILED", new String[]{"pushClass"}));
            }
        }
        if ((currentClass = XJavaDoc.getInstance().getXClass(value)) == null) {
            Class clazz = class$xdoclet$XDocletMessages;
            if (clazz == null) {
                clazz = class$xdoclet$XDocletMessages = ClassTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
            }
            throw new XDocletException(Translator.getString(clazz, "JAVADOC_COULDNT_LOAD_CLASS", new String[]{value}));
        }
        XMethod oldMethod = ClassTagsHandler.getCurrentMethod();
        ClassTagsHandler.pushCurrentClass(currentClass);
        ClassTagsHandler.setCurrentMethod(null);
        this.generate(template);
        ClassTagsHandler.popCurrentClass();
        ClassTagsHandler.setCurrentMethod(oldMethod);
    }

    public void forAllClasses(String template, Properties attributes) throws XDocletException {
        Class clazz = class$xdoclet$tagshandler$ClassTagsHandler;
        if (clazz == null) {
            clazz = class$xdoclet$tagshandler$ClassTagsHandler = ClassTagsHandler.class$("[Lxdoclet.tagshandler.ClassTagsHandler;", false);
        }
        Log log = LogUtil.getLog(clazz, "forAllClasses");
        String abstractStr = attributes.getProperty("abstract");
        boolean acceptAbstractClasses = TypeConversionUtil.stringToBoolean(abstractStr, true);
        String typeName = attributes.getProperty("type");
        String extentStr = attributes.getProperty("extent");
        int extent = TypeTagsHandler.extractExtentType(extentStr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("acceptAbstractClasses=" + acceptAbstractClasses));
            log.debug((Object)("typeName=" + typeName));
            log.debug((Object)("extentStr=" + extentStr));
            log.debug((Object)("extent=" + extent));
        }
        Collection classes = ClassTagsHandler.getAllClasses();
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            XClass currentClass = i.next();
            ClassTagsHandler.setCurrentClass(currentClass);
            log.debug((Object)("currentClass=" + currentClass));
            if (DocletSupport.isDocletGenerated(ClassTagsHandler.getCurrentClass()) || ClassTagsHandler.getCurrentClass().isAbstract() && !acceptAbstractClasses) {
                log.debug((Object)"isDocletGenerated or isAbstract");
                continue;
            }
            if (typeName != null) {
                if (TypeTagsHandler.isOfType(currentClass, typeName, extent)) {
                    log.debug((Object)"isOfType true, generate().");
                    this.generate(template);
                    continue;
                }
                log.debug((Object)"isOfType false");
                continue;
            }
            log.debug((Object)"typeName=null, generate().");
            this.generate(template);
        }
    }

    public String modifiers() throws XDocletException {
        return this.modifiers(0);
    }

    public String symbolicClassName() throws XDocletException {
        return ClassTagsHandler.getCurrentClass().getName();
    }

    public void ifDoesntHaveClassTag(String template, Properties attributes) throws XDocletException {
        if (!ClassTagsHandler.hasTag(attributes, 0)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasClassTag(String template, Properties attributes) throws XDocletException {
        if (ClassTagsHandler.hasTag(attributes, 0)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifClassTagValueMatches(String template, Properties attributes) throws XDocletException {
        String wantedTagValue = ClassTagsHandler.getTagValue(attributes, 0);
        if (wantedTagValue.equals(matchPattern)) {
            this.generate(template);
        }
    }

    public void ifClassTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (ClassTagsHandler.isTagValueEqual(attributes, 0)) {
            this.generate(template);
        }
    }

    public void ifClassTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!ClassTagsHandler.isTagValueEqual(attributes, 0)) {
            this.generate(template);
        }
    }

    public String classTagValue(Properties attributes) throws XDocletException {
        return ClassTagsHandler.getExpandedDelimitedTagValue(attributes, 0);
    }

    public String classTagValueMatch(Properties attributes) throws XDocletException {
        matchPattern = ClassTagsHandler.getTagValue(attributes, 0);
        return "";
    }

    public void forAllClassTags(String template, Properties attributes) throws XDocletException {
        boolean superclasses = TypeConversionUtil.stringToBoolean(attributes.getProperty("superclasses"), true);
        Collection tags = ClassTagsHandler.getCurrentClass().getDoc().getTags(attributes.getProperty("tagName"), superclasses);
        HashSet<String> done = new HashSet<String>();
        matchPattern = null;
        String tagKey = attributes.getProperty("tagKey");
        TagIterator i = XCollections.tagIterator((Collection)tags);
        while (i.hasNext()) {
            String key;
            XTag tag = i.next();
            if (tagKey != null && !done.add(key = tag.getAttributeValue(tagKey))) continue;
            ClassTagsHandler.setCurrentClassTag(tag);
            this.generate(template);
        }
        ClassTagsHandler.setCurrentClassTag(null);
        matchPattern = null;
    }

    public void forAllClassTagTokens(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTagTokens(template, attributes, 0);
    }

    public String classComment(Properties attributes) throws XDocletException {
        boolean noCommentSigns = TypeConversionUtil.stringToBoolean(attributes.getProperty("no-comment-signs"), false);
        if (noCommentSigns) {
            return ClassTagsHandler.getCurrentClass().getDoc().getCommentText();
        }
        char[] spaces = this.getIndentChars(attributes);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(spaces).append("/**").append("\n");
        sbuf.append(this.classCommentText(attributes));
        sbuf.append(this.classCommentTags(attributes));
        sbuf.append(spaces).append(" */");
        return sbuf.toString();
    }

    public String classCommentText(Properties attributes) throws XDocletException {
        boolean noCommentSigns = TypeConversionUtil.stringToBoolean(attributes.getProperty("no-comment-signs"), false);
        if (noCommentSigns) {
            return ClassTagsHandler.getCurrentClass().getDoc().getCommentText();
        }
        char[] spaces = this.getIndentChars(attributes);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(spaces).append(" * ").append(ClassTagsHandler.getCurrentClass().getDoc().getCommentText()).append("\n");
        return sbuf.toString();
    }

    public String classCommentTags(Properties attributes) throws XDocletException {
        char[] spaces = this.getIndentChars(attributes);
        StringBuffer sbuf = new StringBuffer();
        Collection classTags = ClassTagsHandler.getCurrentClass().getDoc().getTags();
        TagIterator i = XCollections.tagIterator((Collection)classTags);
        while (i.hasNext()) {
            XTag tag = i.next();
            String classTag = tag.getName();
            if (classTag.indexOf(58) != -1 || classTag.indexOf(46) != -1 || ClassTagsHandler.getDocletContext().getExcludedTags().indexOf(classTag) != -1) continue;
            sbuf.append(spaces).append(" * @").append(classTag).append(' ');
            sbuf.append(tag.getValue()).append("\n");
        }
        if (ClassTagsHandler.getDocletContext().getAddedTags() != null) {
            StringTokenizer st = new StringTokenizer(ClassTagsHandler.getDocletContext().getAddedTags(), ",");
            while (st.hasMoreTokens()) {
                sbuf.append(spaces).append(" * ").append(st.nextToken()).append("\n");
            }
        }
        return sbuf.toString();
    }

    public String firstSentenceDescription(Properties attributes) throws XDocletException {
        String noDescriptionIfLackingStr;
        boolean noDescriptionIfLacking;
        String desc = ClassTagsHandler.getCurrentClass().getDoc().getFirstSentence();
        if (desc == null && (noDescriptionIfLacking = TypeConversionUtil.stringToBoolean(noDescriptionIfLackingStr = attributes.getProperty("no-description-if-lacking"), true))) {
            Class clazz = class$xdoclet$XDocletMessages;
            if (clazz == null) {
                clazz = class$xdoclet$XDocletMessages = ClassTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
            }
            desc = Translator.getString(clazz, "NO_DESCRIPTION");
        }
        return this.checkForWrap(desc.trim());
    }

    public String importedList(Properties attributes) throws XDocletException {
        String currentClass = attributes.getProperty("currentClass");
        if (currentClass == null) {
            Class clazz = class$xdoclet$XDocletMessages;
            if (clazz == null) {
                clazz = class$xdoclet$XDocletMessages = ClassTagsHandler.class$("[Lxdoclet.XDocletMessages;", false);
            }
            throw new XDocletException(Translator.getString(clazz, "TAG_MUST_INCLUDE_A_PROPERTY", new String[]{"importList", "currentClass"}));
        }
        String currentPackage = PackageTagsHandler.getPackageNameFor(currentClass);
        StringBuffer sbuf = new StringBuffer();
        Collection packages = ClassTagsHandler.getCurrentClass().getImportedPackages();
        PackageIterator i = XCollections.packageIterator((Collection)packages);
        while (i.hasNext()) {
            XPackage pakkage = i.next();
            if (pakkage.getName().equals(currentPackage)) continue;
            sbuf.append("import ").append(pakkage.getName()).append(".*;").append("\n");
        }
        Collection classes = ClassTagsHandler.getCurrentClass().getImportedClasses();
        ClassIterator j = XCollections.classIterator((Collection)classes);
        while (j.hasNext()) {
            XClass clazz = j.next();
            if (PackageTagsHandler.getPackageNameFor(clazz.toString()).equals(currentPackage)) continue;
            sbuf.append("import ").append(clazz.toString()).append(';').append("\n");
        }
        return sbuf.toString();
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

