/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import [Ljava.lang.String;;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.Base64;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.JBossXBValueFormatException;
import org.jboss.xb.binding.TypeBinding;

public final class SimpleTypeBindings
implements Serializable {
    static final long serialVersionUID = 4372272109355825813L;
    public static final String XS_ANYSIMPLETYPE_NAME = "anySimpleType";
    public static final String XS_STRING_NAME = "string";
    public static final String XS_BOOLEAN_NAME = "boolean";
    public static final String XS_DECIMAL_NAME = "decimal";
    public static final String XS_FLOAT_NAME = "float";
    public static final String XS_DOUBLE_NAME = "double";
    public static final String XS_DURATION_NAME = "duration";
    public static final String XS_DATETIME_NAME = "dateTime";
    public static final String XS_TIME_NAME = "time";
    public static final String XS_DATE_NAME = "date";
    public static final String XS_GYEARMONTH_NAME = "gYearMonth";
    public static final String XS_GYEAR_NAME = "gYear";
    public static final String XS_GMONTHDAY_NAME = "gMonthDay";
    public static final String XS_GDAY_NAME = "gDay";
    public static final String XS_GMONTH_NAME = "gMonth";
    public static final String XS_HEXBINARY_NAME = "hexBinary";
    public static final String XS_BASE64BINARY_NAME = "base64Binary";
    public static final String XS_ANYURI_NAME = "anyURI";
    public static final String XS_QNAME_NAME = "QName";
    public static final String XS_NOTATION_NAME = "NOTATION";
    public static final String XS_NORMALIZEDSTRING_NAME = "normalizedString";
    public static final String XS_TOKEN_NAME = "token";
    public static final String XS_LANGUAGE_NAME = "language";
    public static final String XS_NMTOKEN_NAME = "NMTOKEN";
    public static final String XS_NMTOKENS_NAME = "NMTOKENS";
    public static final String XS_NAME_NAME = "Name";
    public static final String XS_NCNAME_NAME = "NCName";
    public static final String XS_ID_NAME = "ID";
    public static final String XS_IDREF_NAME = "IDREF";
    public static final String XS_IDREFS_NAME = "IDREFS";
    public static final String XS_ENTITY_NAME = "ENTITY";
    public static final String XS_ENTITIES_NAME = "ENTITIES";
    public static final String XS_INTEGER_NAME = "integer";
    public static final String XS_NONPOSITIVEINTEGER_NAME = "nonPositiveInteger";
    public static final String XS_NEGATIVEINTEGER_NAME = "negativeInteger";
    public static final String XS_LONG_NAME = "long";
    public static final String XS_INT_NAME = "int";
    public static final String XS_SHORT_NAME = "short";
    public static final String XS_BYTE_NAME = "byte";
    public static final String XS_NONNEGATIVEINTEGER_NAME = "nonNegativeInteger";
    public static final String XS_UNSIGNEDLONG_NAME = "unsignedLong";
    public static final String XS_UNSIGNEDINT_NAME = "unsignedInt";
    public static final String XS_UNSIGNEDSHORT_NAME = "unsignedShort";
    public static final String XS_UNSIGNEDBYTE_NAME = "unsignedByte";
    public static final String XS_POSITIVEINTEGER_NAME = "positiveInteger";
    public static final int XS_INT = "int".hashCode();
    public static final int XS_LONG = "long".hashCode();
    public static final int XS_SHORT = "short".hashCode();
    public static final int XS_FLOAT = "float".hashCode();
    public static final int XS_DOUBLE = "double".hashCode();
    public static final int XS_BOOLEAN = "boolean".hashCode();
    public static final int XS_BYTE = "byte".hashCode();
    public static final int XS_STRING = "string".hashCode();
    public static final int XS_INTEGER = "integer".hashCode();
    public static final int XS_DECIMAL = "decimal".hashCode();
    public static final int XS_DATETIME = "dateTime".hashCode();
    public static final int XS_QNAME = "QName".hashCode();
    public static final int XS_ANYURI = "anyURI".hashCode();
    public static final int XS_UNSIGNEDLONG = "unsignedLong".hashCode();
    public static final int XS_UNSIGNEDINT = "unsignedInt".hashCode();
    public static final int XS_UNSIGNEDSHORT = "unsignedShort".hashCode();
    public static final int XS_UNSIGNEDBYTE = "unsignedByte".hashCode();
    public static final int XS_DATE = "date".hashCode();
    public static final int XS_TIME = "time".hashCode();
    public static final int XS_BASE64BINARY = "base64Binary".hashCode();
    public static final int XS_HEXBINARY = "hexBinary".hashCode();
    public static final int XS_ANYSIMPLETYPE = "anySimpleType".hashCode();
    public static final int XS_DURATION = "duration".hashCode();
    public static final int XS_GYEARMONTH = "gYearMonth".hashCode();
    public static final int XS_GYEAR = "gYear".hashCode();
    public static final int XS_GMONTHDAY = "gMonthDay".hashCode();
    public static final int XS_GMONTH = "gMonth".hashCode();
    public static final int XS_GDAY = "gDay".hashCode();
    public static final int XS_NORMALIZEDSTRING = "normalizedString".hashCode();
    public static final int XS_TOKEN = "token".hashCode();
    public static final int XS_LANGUAGE = "language".hashCode();
    public static final int XS_NAME = "Name".hashCode();
    public static final int XS_NCNAME = "NCName".hashCode();
    public static final int XS_ID = "ID".hashCode();
    public static final int XS_NMTOKEN = "NMTOKEN".hashCode();
    public static final int XS_NMTOKENS = "NMTOKENS".hashCode();
    public static final int XS_NONPOSITIVEINTEGER = "nonPositiveInteger".hashCode();
    public static final int XS_NEGATIVEINTEGER = "negativeInteger".hashCode();
    public static final int XS_NONNEGATIVEINTEGER = "nonNegativeInteger".hashCode();
    public static final int XS_POSITIVEINTEGER = "positiveInteger".hashCode();
    public static final int XS_NOTATION = "NOTATION".hashCode();
    public static final int XS_IDREF = "IDREF".hashCode();
    public static final int XS_IDREFS = "IDREFS".hashCode();
    public static final int XS_ENTITY = "ENTITY".hashCode();
    public static final int XS_ENTITIES = "ENTITIES".hashCode();
    public static final TypeBinding STRING = new TypeBinding(){

        public Object unmarshal(String value) {
            return value;
        }

        public String marshal(Object value) {
            return (String)value;
        }
    };
    public static final TypeBinding INT = new TypeBinding(){

        public Object unmarshal(String value) {
            return Integer.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeBinding LONG = new TypeBinding(){

        public Object unmarshal(String value) {
            return Long.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeBinding DOUBLE = new TypeBinding(){

        public Object unmarshal(String value) {
            return Double.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeBinding FLOAT = new TypeBinding(){

        public Object unmarshal(String value) {
            return Float.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeBinding SHORT = new TypeBinding(){

        public Object unmarshal(String value) {
            return Short.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeBinding BYTE = new TypeBinding(){

        public Object unmarshal(String value) {
            return Byte.valueOf(value);
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeBinding CHAR = new TypeBinding(){

        public Object unmarshal(String value) {
            return value == null ? null : new Character(value.charAt(0));
        }

        public String marshal(Object value) {
            return String.valueOf(value);
        }
    };
    public static final TypeBinding JAVA_UTIL_DATE = new TypeBinding(){

        public Object unmarshal(String value) {
            return SimpleTypeBindings.unmarshalDate(value).getTime();
        }

        public String marshal(Object value) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)value);
            return SimpleTypeBindings.marshalDate(c);
        }
    };

    public static Class classForType(String xsdType, boolean nillable) {
        Class result;
        int typeCode = xsdType.hashCode();
        if (typeCode == XS_INT) {
            Class clazz = nillable ? Integer.class : Integer.TYPE;
            result = clazz;
        } else if (typeCode == XS_LONG) {
            Class clazz = nillable ? Long.class : Long.TYPE;
            result = clazz;
        } else if (typeCode == XS_SHORT) {
            Class clazz = nillable ? Short.class : Short.TYPE;
            result = clazz;
        } else if (typeCode == XS_BYTE) {
            Class clazz = nillable ? Byte.class : Byte.TYPE;
            result = clazz;
        } else if (typeCode == XS_FLOAT) {
            Class clazz = nillable ? Float.class : Float.TYPE;
            result = clazz;
        } else if (typeCode == XS_DOUBLE) {
            Class clazz = nillable ? Double.class : Double.TYPE;
            result = clazz;
        } else if (typeCode == XS_BOOLEAN) {
            Class clazz = nillable ? Boolean.class : Boolean.TYPE;
            result = clazz;
        } else if (typeCode == XS_STRING) {
            result = String.class;
        } else if (typeCode == XS_INTEGER) {
            result = BigInteger.class;
        } else if (typeCode == XS_DECIMAL) {
            result = BigDecimal.class;
        } else if (typeCode == XS_DATETIME) {
            result = Calendar.class;
        } else if (typeCode == XS_QNAME) {
            result = QName.class;
        } else if (typeCode == XS_ANYURI) {
            result = URI.class;
        } else if (typeCode == XS_UNSIGNEDLONG) {
            result = BigInteger.class;
        } else if (typeCode == XS_UNSIGNEDINT) {
            Class clazz = nillable ? Long.class : Long.TYPE;
            result = clazz;
        } else if (typeCode == XS_UNSIGNEDSHORT) {
            Class clazz = nillable ? Integer.class : Integer.TYPE;
            result = clazz;
        } else if (typeCode == XS_UNSIGNEDBYTE) {
            Class clazz = nillable ? Short.class : Short.TYPE;
            result = clazz;
        } else if (typeCode == XS_DATE) {
            result = Calendar.class;
        } else if (typeCode == XS_TIME) {
            result = Calendar.class;
        } else if (typeCode == XS_BASE64BINARY) {
            result = [B.class;
        } else if (typeCode == XS_HEXBINARY) {
            result = [B.class;
        } else if (typeCode == XS_ANYSIMPLETYPE) {
            result = String.class;
        } else {
            if (typeCode == XS_DURATION) {
                throw new IllegalStateException("Recognized but not supported xsdType: duration");
            }
            if (typeCode == XS_GYEARMONTH) {
                result = Calendar.class;
            } else if (typeCode == XS_GYEAR) {
                result = Calendar.class;
            } else if (typeCode == XS_GMONTHDAY) {
                result = Calendar.class;
            } else if (typeCode == XS_GMONTH) {
                result = Calendar.class;
            } else if (typeCode == XS_GDAY) {
                result = Calendar.class;
            } else if (typeCode == XS_NORMALIZEDSTRING) {
                result = String.class;
            } else if (typeCode == XS_TOKEN) {
                result = String.class;
            } else if (typeCode == XS_LANGUAGE) {
                result = String.class;
            } else if (typeCode == XS_NAME) {
                result = String.class;
            } else if (typeCode == XS_NCNAME) {
                result = String.class;
            } else if (typeCode == XS_ID) {
                result = String.class;
            } else if (typeCode == XS_NMTOKEN) {
                result = String.class;
            } else if (typeCode == XS_NMTOKENS) {
                result = String;.class;
            } else if (typeCode == XS_NONPOSITIVEINTEGER) {
                result = BigInteger.class;
            } else if (typeCode == XS_NEGATIVEINTEGER) {
                result = BigInteger.class;
            } else if (typeCode == XS_NONNEGATIVEINTEGER) {
                result = BigInteger.class;
            } else if (typeCode == XS_POSITIVEINTEGER) {
                result = BigInteger.class;
            } else if (typeCode == XS_NOTATION) {
                result = String.class;
            } else if (typeCode == XS_IDREF) {
                result = String.class;
            } else if (typeCode == XS_IDREFS) {
                result = String;.class;
            } else if (typeCode == XS_ENTITY) {
                result = String.class;
            } else if (typeCode == XS_ENTITIES) {
                result = String;.class;
            } else {
                throw new IllegalStateException("Not supported xsdType: " + xsdType + ", hashCode=" + xsdType.hashCode());
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object unmarshal(String xsdType, String value, NamespaceContext nsCtx) {
        void var4_52;
        if (xsdType == null) {
            throw new IllegalArgumentException("Schema type cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value string cannot be null");
        }
        int typeCode = xsdType.hashCode();
        if (typeCode == XS_INT) {
            Integer n = Integer.valueOf(value);
            return var4_52;
        }
        if (typeCode == XS_LONG) {
            Long l = Long.valueOf(value);
            return var4_52;
        }
        if (typeCode == XS_SHORT) {
            Short s = Short.valueOf(value);
            return var4_52;
        }
        if (typeCode == XS_BYTE) {
            Byte by = Byte.valueOf(value);
            return var4_52;
        }
        if (typeCode == XS_FLOAT) {
            if ("INF".equals(value)) {
                Float f = new Float(Float.POSITIVE_INFINITY);
                return var4_52;
            } else if ("-INF".equals(value)) {
                Float f = new Float(Float.NEGATIVE_INFINITY);
                return var4_52;
            } else {
                Float f = Float.valueOf(value);
            }
            return var4_52;
        }
        if (typeCode == XS_DOUBLE) {
            if ("INF".equals(value)) {
                Double d = new Double(Double.POSITIVE_INFINITY);
                return var4_52;
            } else if ("-INF".equals(value)) {
                Double d = new Double(Double.NEGATIVE_INFINITY);
                return var4_52;
            } else {
                Double d = Double.valueOf(value);
            }
            return var4_52;
        }
        if (typeCode == XS_BOOLEAN) {
            if (value.length() == 1) {
                switch (value.charAt(0)) {
                    case '1': {
                        Boolean bl = Boolean.TRUE;
                        return var4_52;
                    }
                    case '0': {
                        Boolean bl = Boolean.FALSE;
                        return var4_52;
                    }
                    default: {
                        throw new JBossXBValueFormatException("An instance of a datatype that is defined as ?boolean? can have the following legal literals {true, false, 1, 0}. But got: " + value);
                    }
                }
            }
            Boolean bl = Boolean.valueOf(value);
            return var4_52;
        }
        if (typeCode == XS_STRING) {
            String string = value;
            return var4_52;
        } else if (typeCode == XS_INTEGER) {
            BigInteger bigInteger = new BigInteger(value);
            return var4_52;
        } else if (typeCode == XS_DECIMAL) {
            BigDecimal bigDecimal = new BigDecimal(value);
            return var4_52;
        } else if (typeCode == XS_DATETIME) {
            Calendar calendar = SimpleTypeBindings.unmarshalDateTime(value);
            return var4_52;
        } else if (typeCode == XS_QNAME) {
            QName qName = SimpleTypeBindings.unmarshalQName(value, nsCtx);
            return var4_52;
        } else if (typeCode == XS_ANYURI) {
            try {
                URI uRI = new URI(value);
                return var4_52;
            }
            catch (URISyntaxException e) {
                throw new JBossXBValueFormatException("Failed to unmarshal anyURI value " + value, e);
            }
        } else if (typeCode == XS_UNSIGNEDLONG) {
            BigInteger d = new BigInteger(value);
            if (d.doubleValue() < 0.0 || d.doubleValue() > 1.8446744073709552E19) {
                throw new JBossXBValueFormatException("Invalid unsignedLong value: " + value);
            }
            BigInteger bigInteger = d;
            return var4_52;
        } else if (typeCode == XS_UNSIGNEDINT) {
            long l = Long.parseLong(value);
            if (l < 0L || l > 0xFFFFFFFFL) {
                throw new JBossXBValueFormatException("Invalid unsignedInt value: " + value);
            }
            Long l2 = new Long(l);
            return var4_52;
        } else if (typeCode == XS_UNSIGNEDSHORT) {
            int i = Integer.parseInt(value);
            if (i < 0 || i > 65535) {
                throw new JBossXBValueFormatException("Invalid unsignedShort value: " + value);
            }
            Integer n = new Integer(i);
            return var4_52;
        } else if (typeCode == XS_UNSIGNEDBYTE) {
            short s = Short.parseShort(value);
            if (s < 0 || s > 255) {
                throw new JBossXBValueFormatException("Invalid unsignedByte value: " + value);
            }
            Short s2 = new Short(s);
            return var4_52;
        } else if (typeCode == XS_DATE) {
            Calendar calendar = SimpleTypeBindings.unmarshalDate(value);
            return var4_52;
        } else if (typeCode == XS_TIME) {
            Calendar calendar = SimpleTypeBindings.unmarshalTime(value);
            return var4_52;
        } else if (typeCode == XS_BASE64BINARY) {
            byte[] byArray = SimpleTypeBindings.unmarshalBase64(value);
            return var4_52;
        } else if (typeCode == XS_HEXBINARY) {
            byte[] byArray = SimpleTypeBindings.unmarshalHexBinary(value);
            return var4_52;
        } else if (typeCode == XS_ANYSIMPLETYPE) {
            String string = value;
            return var4_52;
        } else {
            if (typeCode == XS_DURATION) {
                throw new IllegalStateException("Recognized but not supported xsdType: duration");
            }
            if (typeCode == XS_GYEARMONTH) {
                Calendar calendar = SimpleTypeBindings.unmarshalGYearMonth(value);
                return var4_52;
            } else if (typeCode == XS_GYEAR) {
                Calendar calendar = SimpleTypeBindings.unmarshalGYear(value);
                return var4_52;
            } else if (typeCode == XS_GMONTHDAY) {
                Calendar calendar = SimpleTypeBindings.unmarshalGMonthDay(value);
                return var4_52;
            } else {
                if (typeCode == XS_GMONTH) {
                    return SimpleTypeBindings.unmarshalGMonth(value);
                }
                if (typeCode == XS_GDAY) {
                    return SimpleTypeBindings.unmarshalGDay(value);
                }
                if (typeCode == XS_NORMALIZEDSTRING) {
                    if (!SimpleTypeBindings.isNormalizedString(value)) throw new JBossXBValueFormatException("Invalid normalizedString value: " + value);
                    String string = value;
                    return var4_52;
                } else if (typeCode == XS_TOKEN) {
                    if (!SimpleTypeBindings.isValidToken(value)) throw new JBossXBValueFormatException("Invalid token value: " + value);
                    String string = value;
                    return var4_52;
                } else if (typeCode == XS_LANGUAGE) {
                    String string = value;
                    return var4_52;
                } else if (typeCode == XS_NAME) {
                    String string = value;
                    return var4_52;
                } else if (typeCode == XS_NCNAME) {
                    String string = value;
                    return var4_52;
                } else if (typeCode == XS_ID) {
                    String string = value;
                    return var4_52;
                } else if (typeCode == XS_NMTOKEN) {
                    String string = value;
                    return var4_52;
                } else if (typeCode == XS_NMTOKENS) {
                    String[] stringArray = SimpleTypeBindings.unmarshalNMTokens(value);
                    return var4_52;
                } else {
                    if (typeCode == XS_NONPOSITIVEINTEGER) {
                        BigInteger bigInteger = new BigInteger(value);
                        if (BigInteger.ZERO.compareTo(bigInteger) >= 0) return var4_52;
                        throw new JBossXBValueFormatException("Invalid nonPositiveInteger value: " + value);
                    }
                    if (typeCode == XS_NEGATIVEINTEGER) {
                        BigInteger bigInteger = new BigInteger(value);
                        if (BigInteger.ZERO.compareTo(bigInteger) > 0) return var4_52;
                        throw new JBossXBValueFormatException("Invalid negativeInteger value: " + value);
                    }
                    if (typeCode == XS_NONNEGATIVEINTEGER) {
                        BigInteger bigInteger = new BigInteger(value);
                        if (BigInteger.ZERO.compareTo(bigInteger) <= 0) return var4_52;
                        throw new JBossXBValueFormatException("Invalid nonNegativeInteger value: " + value);
                    }
                    if (typeCode == XS_POSITIVEINTEGER) {
                        BigInteger bigInteger = new BigInteger(value);
                        if (BigInteger.ZERO.compareTo(bigInteger) < 0) return var4_52;
                        throw new JBossXBValueFormatException("Invalid positiveInteger value: " + value);
                    }
                    if (typeCode == XS_NOTATION) {
                        String string = value;
                        return var4_52;
                    } else if (typeCode == XS_IDREF) {
                        String string = value;
                        return var4_52;
                    } else if (typeCode == XS_IDREFS) {
                        String[] stringArray = SimpleTypeBindings.unmarshalIdRefs(value);
                        return var4_52;
                    } else if (typeCode == XS_ENTITY) {
                        String string = value;
                        return var4_52;
                    } else {
                        if (typeCode != XS_ENTITIES) throw new IllegalStateException("Not supported xsdType: " + xsdType + ", hashCode=" + xsdType.hashCode());
                        String[] stringArray = SimpleTypeBindings.unmarshalIdRefs(value);
                    }
                }
            }
        }
        return var4_52;
    }

    public static Object unmarshal(String value, Class javaType) {
        Object result;
        if (String.class == javaType) {
            result = value;
        } else if (Integer.TYPE == javaType || Integer.class == javaType) {
            result = Integer.valueOf(value);
        } else if (Long.TYPE == javaType || Long.class == javaType) {
            result = Long.valueOf(value);
        } else if (Double.TYPE == javaType || Double.class == javaType) {
            result = Double.valueOf(value);
        } else if (Float.TYPE == javaType || Float.class == javaType) {
            result = Float.valueOf(value);
        } else if (Short.TYPE == javaType || Short.class == javaType) {
            result = Short.valueOf(value);
        } else if (Byte.TYPE == javaType || Byte.class == javaType) {
            result = Byte.valueOf(value);
        } else if (Character.TYPE == javaType || Character.class == javaType) {
            result = new Character(value.charAt(0));
        } else if (Date.class == javaType) {
            String FORMAT = "yyyy-MM-dd";
            try {
                result = new SimpleDateFormat("yyyy-MM-dd").parse(value);
            }
            catch (ParseException e) {
                throw new JBossXBRuntimeException("Failed to parse date accroding to yyyy-MM-dd format: " + value + ": " + e.getMessage());
            }
        } else if (Object.class == javaType) {
            result = value;
        } else {
            throw new JBossXBRuntimeException("Unexpected field type " + javaType);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String marshal(String xsdType, Object value, NamespaceContext nsCtx) {
        String result;
        if (value == null) {
            throw new IllegalArgumentException("Can't marshal null value!");
        }
        int typeCode = xsdType.hashCode();
        if (typeCode == XS_INT) {
            Integer i = (Integer)value;
            return i.toString();
        }
        if (typeCode == XS_LONG) {
            Long l = (Long)value;
            return l.toString();
        }
        if (typeCode == XS_SHORT) {
            Short s = (Short)value;
            return s.toString();
        }
        if (typeCode == XS_BYTE) {
            Byte b = (Byte)value;
            return b.toString();
        }
        if (typeCode == XS_FLOAT) {
            Float f = (Float)value;
            if (f.floatValue() == Float.POSITIVE_INFINITY) {
                return "INF";
            }
            if (f.floatValue() != Float.NEGATIVE_INFINITY) return f.toString();
            return "-INF";
        }
        if (typeCode == XS_DOUBLE) {
            Double d = (Double)value;
            if (d == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d != Double.NEGATIVE_INFINITY) return d.toString();
            return "-INF";
        }
        if (typeCode == XS_BOOLEAN) {
            if (value instanceof Boolean) {
                if ((Boolean)value == false) return "false";
                return "true";
            }
            if (!(value instanceof Number)) throw new JBossXBValueFormatException("Java value for XSD boolean type expected to be an instance of java.lang.Boolean or java.lang.Number. But the value is of type " + value.getClass().getName());
            Number n = (Number)value;
            switch (n.byteValue()) {
                case 1: {
                    return "1";
                }
                case 0: {
                    return "0";
                }
                default: {
                    throw new JBossXBValueFormatException("An instance of a datatype that is defined as ?boolean? can have the following legal literals {true, false, 1, 0}. But got: " + value);
                }
            }
        }
        if (typeCode == XS_STRING) {
            return (String)value;
        }
        if (typeCode == XS_INTEGER) {
            BigInteger bi = (BigInteger)value;
            return bi.toString();
        }
        if (typeCode == XS_DECIMAL) {
            BigDecimal bd = (BigDecimal)value;
            return bd.toString();
        }
        if (typeCode == XS_DATETIME) {
            Calendar c;
            if (value.getClass() == Date.class) {
                c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                c.clear();
                c.setTime((Date)value);
                return SimpleTypeBindings.marshalDateTime(c);
            } else {
                c = (Calendar)value;
            }
            return SimpleTypeBindings.marshalDateTime(c);
        }
        if (typeCode == XS_QNAME) {
            QName qName = (QName)value;
            return SimpleTypeBindings.marshalQName(qName, nsCtx);
        }
        if (typeCode == XS_ANYURI) {
            URI u = (URI)value;
            return u.toString();
        }
        if (typeCode == XS_UNSIGNEDLONG) {
            BigInteger d = (BigInteger)value;
            if (d.doubleValue() < 0.0) throw new JBossXBValueFormatException("Invalid unsignedLong value: " + value);
            if (!(d.doubleValue() > 1.8446744073709552E19)) return d.toString();
            throw new JBossXBValueFormatException("Invalid unsignedLong value: " + value);
        }
        if (typeCode == XS_UNSIGNEDINT) {
            Long l = (Long)value;
            if (l < 0L) throw new JBossXBValueFormatException("Invalid unsignedInt value: " + value);
            if (l <= 0xFFFFFFFFL) return l.toString();
            throw new JBossXBValueFormatException("Invalid unsignedInt value: " + value);
        }
        if (typeCode == XS_UNSIGNEDSHORT) {
            Integer i = (Integer)value;
            if (i < 0) throw new JBossXBValueFormatException("Invalid unsignedShort value: " + value);
            if (i <= 65535) return i.toString();
            throw new JBossXBValueFormatException("Invalid unsignedShort value: " + value);
        }
        if (typeCode == XS_UNSIGNEDBYTE) {
            Short s = (Short)value;
            if (s < 0) throw new JBossXBValueFormatException("Invalid unsignedByte value: " + value);
            if (s <= 255) return s.toString();
            throw new JBossXBValueFormatException("Invalid unsignedByte value: " + value);
        }
        if (typeCode == XS_DATE) {
            Calendar c = (Calendar)value;
            return SimpleTypeBindings.marshalDate(c);
        }
        if (typeCode == XS_TIME) {
            Calendar c = (Calendar)value;
            return SimpleTypeBindings.marshalTime(c);
        }
        if (typeCode == XS_BASE64BINARY) {
            byte[] b = (byte[])value;
            return SimpleTypeBindings.marshalBase64(b);
        }
        if (typeCode == XS_HEXBINARY) {
            byte[] b = (byte[])value;
            return SimpleTypeBindings.marshalHexBinary(b);
        }
        if (typeCode == XS_ANYSIMPLETYPE) {
            return (String)value;
        }
        if (typeCode == XS_DURATION) {
            throw new IllegalStateException("Recognized but not supported xsdType: " + xsdType);
        }
        if (typeCode == XS_GYEARMONTH) {
            Calendar c = (Calendar)value;
            return SimpleTypeBindings.marshalGYearMonth(c);
        }
        if (typeCode == XS_GYEAR) {
            Calendar c = (Calendar)value;
            return SimpleTypeBindings.marshalGYear(c);
        }
        if (typeCode == XS_GMONTHDAY) {
            Calendar c = (Calendar)value;
            return SimpleTypeBindings.marshalGMonthDay(c);
        }
        if (typeCode == XS_GMONTH) {
            Calendar c = (Calendar)value;
            return SimpleTypeBindings.marshalGMonth(c);
        }
        if (typeCode == XS_GDAY) {
            Calendar c = (Calendar)value;
            return SimpleTypeBindings.marshalGDay(c);
        }
        if (typeCode == XS_NORMALIZEDSTRING) {
            String s = (String)value;
            if (!SimpleTypeBindings.isNormalizedString(s)) throw new JBossXBValueFormatException("Invalid normalizedString value: " + value);
            return s;
        }
        if (typeCode == XS_TOKEN) {
            String s = (String)value;
            if (!SimpleTypeBindings.isValidToken(s)) throw new JBossXBValueFormatException("Invalid token value: " + value);
            return s;
        }
        if (typeCode == XS_LANGUAGE) {
            return (String)value;
        }
        if (typeCode == XS_NAME) {
            return (String)value;
        }
        if (typeCode == XS_NCNAME) {
            return (String)value;
        }
        if (typeCode == XS_ID) {
            return (String)value;
        }
        if (typeCode == XS_NMTOKEN) {
            return (String)value;
        }
        if (typeCode == XS_NMTOKENS) {
            String[] tokens = (String[])value;
            if (tokens.length <= 0) return "";
            result = tokens[0];
            int i = 1;
            while (i < tokens.length) {
                result = result + ' ' + tokens[i];
                ++i;
            }
            return result;
        }
        if (typeCode == XS_NONPOSITIVEINTEGER) {
            BigInteger bi = (BigInteger)value;
            if (BigInteger.ZERO.compareTo(bi) >= 0) return bi.toString();
            throw new JBossXBValueFormatException("Invalid nonPositiveInteger value: " + value);
        }
        if (typeCode == XS_NEGATIVEINTEGER) {
            BigInteger bi = (BigInteger)value;
            if (BigInteger.ZERO.compareTo(bi) > 0) return bi.toString();
            throw new JBossXBValueFormatException("Invalid negativeInteger value: " + value);
        }
        if (typeCode == XS_NONNEGATIVEINTEGER) {
            BigInteger bi = (BigInteger)value;
            if (BigInteger.ZERO.compareTo(bi) <= 0) return bi.toString();
            throw new JBossXBValueFormatException("Invalid nonNegativeInteger value: " + value);
        }
        if (typeCode == XS_POSITIVEINTEGER) {
            BigInteger bi = (BigInteger)value;
            if (BigInteger.ZERO.compareTo(bi) < 0) return bi.toString();
            throw new JBossXBValueFormatException("Invalid positiveInteger value: " + value);
        }
        if (typeCode == XS_NOTATION) {
            return (String)value;
        }
        if (typeCode == XS_IDREF) {
            return (String)value;
        }
        if (typeCode == XS_IDREFS) {
            String[] refs = (String[])value;
            if (refs.length <= 0) return "";
            result = refs[0];
            int i = 1;
            while (i < refs.length) {
                result = result + ' ' + refs[i];
                ++i;
            }
            return result;
        }
        if (typeCode == XS_ENTITY) {
            return (String)value;
        }
        if (typeCode != XS_ENTITIES) throw new IllegalStateException("Not supported xsdType: " + xsdType + ", hashCode=" + xsdType.hashCode());
        String[] refs = (String[])value;
        if (refs.length <= 0) return "";
        result = refs[0];
        int i = 1;
        while (i < refs.length) {
            result = result + ' ' + refs[i];
            ++i;
        }
        return result;
    }

    public static String[] unmarshalNMTokens(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value);
        String[] tokens = new String[tokenizer.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokenizer.nextToken();
        }
        return tokens;
    }

    public static String[] unmarshalIdRefs(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value);
        String[] tokens = new String[tokenizer.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokenizer.nextToken();
        }
        return tokens;
    }

    public static Calendar unmarshalGMonthDay(String value) {
        if (value.length() < 6 || value.charAt(0) != '-' || value.charAt(1) != '-' || value.charAt(4) != '-') {
            throw new JBossXBValueFormatException("gMonthDay value does not follow the format '--MM-DD[timezone]: " + value);
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2, Integer.parseInt(value.substring(2, 4)) - 1);
        cal.set(5, Integer.parseInt(value.substring(5, 7)));
        if (value.length() > 7) {
            cal.setTimeZone(SimpleTypeBindings.parseTimeZone(value, 7));
        }
        return cal;
    }

    public static String marshalGMonthDay(Calendar value) {
        String result = "--";
        result = result + SimpleTypeBindings.marshalInt(value.get(2) + 1, 2);
        result = result + '-';
        result = result + SimpleTypeBindings.marshalInt(value.get(5), 2);
        result = result + SimpleTypeBindings.marshalTimeZone(value.getTimeZone());
        return result;
    }

    public static Calendar unmarshalGMonth(String value) {
        if (value.length() < 4 || value.charAt(0) != '-' || value.charAt(1) != '-') {
            throw new JBossXBValueFormatException("gMonth value does not follow the format '--MM': " + value);
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2, Integer.parseInt(value.substring(2, 4)) - 1);
        if (value.length() > 4) {
            cal.setTimeZone(SimpleTypeBindings.parseTimeZone(value, 4));
        }
        return cal;
    }

    public static String marshalGMonth(Calendar value) {
        String result = "--";
        result = result + SimpleTypeBindings.marshalInt(value.get(2) + 1, 2);
        result = result + SimpleTypeBindings.marshalTimeZone(value.getTimeZone());
        return result;
    }

    public static Calendar unmarshalGYear(String value) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        int timeZone = SimpleTypeBindings.parseGYear(value, 0, cal);
        if (value.length() > timeZone) {
            TimeZone tz = SimpleTypeBindings.parseTimeZone(value, timeZone);
            cal.setTimeZone(tz);
        }
        return cal;
    }

    public static String marshalGYear(Calendar value) {
        String result = String.valueOf(value.get(1));
        result = result + SimpleTypeBindings.marshalTimeZone(value.getTimeZone());
        return result;
    }

    public static Calendar unmarshalGYearMonth(String value) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        int month = SimpleTypeBindings.parseGYear(value, 0, cal);
        if (value.charAt(month) != '-') {
            throw new JBossXBValueFormatException("gYearMonth value does not follow the format '[-]CCYY-MM[timezone]': " + value);
        }
        cal.set(2, Integer.parseInt(value.substring(month + 1, month + 3)) - 1);
        if (value.length() > month + 3) {
            TimeZone tz = SimpleTypeBindings.parseTimeZone(value, month + 3);
            cal.setTimeZone(tz);
        }
        return cal;
    }

    public static String marshalGYearMonth(Calendar value) {
        String result = String.valueOf(value.get(1));
        result = result + '-';
        result = result + SimpleTypeBindings.marshalInt(value.get(2) + 1, 2);
        result = result + SimpleTypeBindings.marshalTimeZone(value.getTimeZone());
        return result;
    }

    public static Calendar unmarshalGDay(String value) {
        if (value.length() < 5 || value.charAt(0) != '-' || value.charAt(1) != '-' || value.charAt(2) != '-') {
            throw new NumberFormatException("gDay value does not follow the format (---DD[timezonePart]): " + value);
        }
        int day = Integer.parseInt(value.substring(3, 5));
        if (day < 1 || day > 31) {
            throw new NumberFormatException("gDay value is not in the interval [1..31]: " + day);
        }
        TimeZone tz = SimpleTypeBindings.parseTimeZone(value, 5);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        if (tz != null) {
            cal.setTimeZone(tz);
        }
        cal.set(5, day);
        return cal;
    }

    public static String marshalGDay(Calendar value) {
        String result = "---";
        result = result + SimpleTypeBindings.marshalInt(value.get(5), 2);
        result = result + SimpleTypeBindings.marshalTimeZone(value.getTimeZone());
        return result;
    }

    public static Calendar unmarshalDate(String value) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        int ind = SimpleTypeBindings.parseDate(value, 0, cal);
        TimeZone tz = null;
        if (ind < value.length()) {
            tz = SimpleTypeBindings.parseTimeZone(value, ind);
        }
        if (tz != null) {
            cal.setTimeZone(tz);
        }
        return cal;
    }

    public static String marshalDate(Calendar value) {
        String result = String.valueOf(value.get(1));
        result = result + '-';
        result = result + SimpleTypeBindings.marshalInt(value.get(2) + 1, 2);
        result = result + '-';
        result = result + SimpleTypeBindings.marshalInt(value.get(5), 2);
        result = result + SimpleTypeBindings.marshalTimeZone(value.getTimeZone());
        return result;
    }

    public static Calendar unmarshalTime(String value) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        SimpleTypeBindings.parseTime(value, 0, cal);
        TimeZone tz = null;
        if (value.length() > 12) {
            tz = SimpleTypeBindings.parseTimeZone(value, 12);
        }
        if (tz != null) {
            cal.setTimeZone(tz);
        }
        return cal;
    }

    public static String marshalTime(Calendar value) {
        String result = SimpleTypeBindings.marshalInt(value.get(11), 2);
        result = result + ':';
        result = result + SimpleTypeBindings.marshalInt(value.get(12), 2);
        result = result + ':';
        result = result + SimpleTypeBindings.marshalInt(value.get(13), 2);
        result = result + '.';
        int millis = value.get(14);
        result = millis > 99 ? result + String.valueOf(millis) : (millis > 9 ? result + "0" + String.valueOf(millis) : result + "00" + String.valueOf(millis));
        result = result + SimpleTypeBindings.marshalTimeZone(value.getTimeZone());
        return result;
    }

    public static Calendar unmarshalDateTime(String value) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        int timeInd = SimpleTypeBindings.parseDate(value, 0, cal);
        if (value.charAt(timeInd) != 'T') {
            throw new JBossXBValueFormatException("DateTime value does not follow the format '[-]yyyy-mm-ddThh:mm:ss[.s+][timezone]': expected 'T' but got " + value.charAt(timeInd));
        }
        SimpleTypeBindings.parseTime(value, timeInd + 1, cal);
        TimeZone tz = null;
        if (value.length() > timeInd + 13) {
            tz = SimpleTypeBindings.parseTimeZone(value, timeInd + 13);
        }
        if (tz != null) {
            cal.setTimeZone(tz);
        }
        return cal;
    }

    public static String marshalDateTime(Calendar value) {
        String result = String.valueOf(value.get(1));
        result = result + '-';
        result = result + SimpleTypeBindings.marshalInt(value.get(2) + 1, 2);
        result = result + '-';
        result = result + SimpleTypeBindings.marshalInt(value.get(5), 2);
        result = result + 'T';
        result = result + SimpleTypeBindings.marshalInt(value.get(11), 2);
        result = result + ':';
        result = result + SimpleTypeBindings.marshalInt(value.get(12), 2);
        result = result + ':';
        result = result + SimpleTypeBindings.marshalInt(value.get(13), 2);
        result = result + '.';
        int millis = value.get(14);
        result = millis > 99 ? result + String.valueOf(millis) : (millis > 9 ? result + "0" + String.valueOf(millis) : result + "00" + String.valueOf(millis));
        result = result + SimpleTypeBindings.marshalTimeZone(value.getTimeZone());
        return result;
    }

    public static byte[] unmarshalHexBinary(String value) {
        if (value.length() % 2 != 0) {
            throw new IllegalArgumentException("hexBinary value must have even length.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < value.length(); i += 2) {
            char c1 = value.charAt(i);
            char c2 = value.charAt(i + 1);
            int b = 0;
            if (c1 >= '0' && c1 <= '9') {
                b = (byte)(b + (c1 - 48) * 16);
            } else if (c1 >= 'a' && c1 <= 'f') {
                b = (byte)(b + (c1 - 97 + 10) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                b = (byte)(b + (c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException("hexBinary value contains illegal character: " + value);
            }
            if (c2 >= '0' && c2 <= '9') {
                b = (byte)(b + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                b = (byte)(b + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                b = (byte)(b + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException("hexBinary value contains illegal character: " + value);
            }
            baos.write(b);
        }
        return baos.toByteArray();
    }

    public static String marshalHexBinary(byte[] value) {
        StringBuffer result = new StringBuffer(2 * value.length);
        for (int i = 0; i < value.length; ++i) {
            result.append(SimpleTypeBindings.convertDigit(value[i] >> 4));
            result.append(SimpleTypeBindings.convertDigit(value[i] & 0xF));
        }
        return result.toString();
    }

    public static boolean isNormalizedString(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != '\t' && c != '\n' && c != '\r') continue;
            return false;
        }
        return true;
    }

    public static byte[] unmarshalBase64(String value) {
        return Base64.decode(value);
    }

    public static String marshalBase64(byte[] value) {
        return Base64.encodeBytes(value);
    }

    public static QName unmarshalQName(String value, NamespaceContext nsRegistry) {
        int colonIndex = value.lastIndexOf(":");
        if (colonIndex > 0) {
            String prefix = value.substring(0, colonIndex);
            String nsURI = nsRegistry.getNamespaceURI(prefix);
            if (nsURI == null) {
                throw new IllegalStateException("No namespace URI registered for prefix: " + prefix);
            }
            String localPart = value.substring(colonIndex + 1);
            return new QName(nsURI, localPart, prefix);
        }
        return new QName(value);
    }

    public static String marshalQName(QName value, NamespaceContext nsRegistry) {
        String nsURI = value.getNamespaceURI();
        if (value.getPrefix().length() > 0) {
            return value.getPrefix() + ":" + value.getLocalPart();
        }
        if (nsURI.length() > 0 && nsRegistry != null) {
            String prefix = nsRegistry.getPrefix(nsURI);
            if (prefix == null) {
                throw new IllegalStateException("Namespace URI not registered: " + nsURI);
            }
            return prefix.length() > 0 ? prefix + ":" + value.getLocalPart() : value.getLocalPart();
        }
        return value.getLocalPart();
    }

    public static boolean isValidToken(String value) {
        if (value != null && value.length() > 0) {
            if (value.charAt(0) == ' ' || value.charAt(value.length() - 1) == ' ') {
                return false;
            }
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\t' || c == '\n' || c == '\r') {
                    return false;
                }
                if (c != ' ' || i + 1 >= value.length() || value.charAt(i + 1) != ' ') continue;
                return false;
            }
        }
        return true;
    }

    private static int parseGYear(String value, int start, Calendar cal) {
        int negative = value.charAt(start) == '-' ? 1 : 0;
        cal.set(1, Integer.parseInt(value.substring(start, start + 4 + negative)));
        return start + 4 + negative;
    }

    private static int parseDate(String value, int start, Calendar cal) {
        if (value.charAt(start) == '-') {
            ++start;
        }
        if (!Character.isDigit(value.charAt(start))) {
            throw new JBossXBValueFormatException("Date value does not follow the format '-'? yyyy '-' mm '-' dd: " + value);
        }
        int nextToken = value.indexOf(45, start);
        if (nextToken == -1 || nextToken - start < 4) {
            throw new JBossXBValueFormatException("Date value does not follow the format '-'? yyyy '-' mm '-' dd: " + value);
        }
        int year = Integer.parseInt(value.substring(start, nextToken));
        start = nextToken + 1;
        if ((nextToken = value.indexOf(45, start)) == -1 || nextToken - start < 2) {
            throw new JBossXBValueFormatException("Date value does not follow the format '-'? yyyy '-' mm '-' dd: " + value);
        }
        int month = Integer.parseInt(value.substring(start, nextToken));
        start = nextToken + 1;
        int day = Integer.parseInt(value.substring(start, nextToken += 3));
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        return nextToken;
    }

    private static void parseTime(String value, int start, Calendar cal) {
        if (value.charAt(start + 2) != ':' || value.charAt(start + 5) != ':' || value.charAt(start + 8) != '.') {
            throw new JBossXBValueFormatException("Time value does not follow the format 'hh:mm:ss:sss': " + value);
        }
        int hh = Integer.parseInt(value.substring(start, start + 2));
        int mm = Integer.parseInt(value.substring(start + 3, start + 5));
        int ss = Integer.parseInt(value.substring(start + 6, start + 8));
        int sss = Integer.parseInt(value.substring(start + 9, start + 12));
        cal.set(11, hh);
        cal.set(12, mm);
        cal.set(13, ss);
        cal.set(14, sss);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TimeZone parseTimeZone(String value, int start) {
        if (value.charAt(start) == '+' || value.charAt(start) == '-') {
            if (value.length() - start != 6) throw new NumberFormatException("Timezone value does not follow the format ([+/-]HH:MM): " + value.substring(start));
            if (!Character.isDigit(value.charAt(start + 1))) throw new NumberFormatException("Timezone value does not follow the format ([+/-]HH:MM): " + value.substring(start));
            if (!Character.isDigit(value.charAt(start + 2))) throw new NumberFormatException("Timezone value does not follow the format ([+/-]HH:MM): " + value.substring(start));
            if (value.charAt(start + 3) != ':') throw new NumberFormatException("Timezone value does not follow the format ([+/-]HH:MM): " + value.substring(start));
            if (!Character.isDigit(value.charAt(start + 4))) throw new NumberFormatException("Timezone value does not follow the format ([+/-]HH:MM): " + value.substring(start));
            if (!Character.isDigit(value.charAt(start + 5))) throw new NumberFormatException("Timezone value does not follow the format ([+/-]HH:MM): " + value.substring(start));
            return TimeZone.getTimeZone("GMT" + value.substring(start));
        }
        if (value.charAt(start) != 'Z') throw new NumberFormatException("Timezone value does not follow the format ([+/-]HH:MM): " + value.substring(start));
        return TimeZone.getTimeZone("GMT");
    }

    private static String marshalTimeZone(TimeZone value) {
        int offset = value.getRawOffset();
        if (offset == 0) {
            return "Z";
        }
        DecimalFormat hourFormat = new DecimalFormat("'+'00;-00");
        DecimalFormat minuteFormat = new DecimalFormat("00");
        int minutes = offset / 60000;
        int hours = minutes / 60;
        return hourFormat.format(hours) + ":" + minuteFormat.format(minutes -= hours * 60);
    }

    private static String marshalInt(int value, int length) {
        String result = String.valueOf(value);
        if (result.length() < length) {
            while (result.length() < length) {
                result = '0' + result;
            }
        } else if (result.length() > length) {
            throw new JBossXBValueFormatException("Can't marshal int value " + value + " to a string with length of " + length);
        }
        return result;
    }

    private static char convertDigit(int value) {
        if ((value &= 0xF) >= 10) {
            return (char)(value - 10 + 97);
        }
        return (char)(value + 48);
    }

    static {
        int[] codes = new int[45];
        String[] names = new String[codes.length];
        int i = 0;
        names[i] = XS_INT_NAME;
        codes[i++] = XS_INT;
        names[i] = XS_LONG_NAME;
        codes[i++] = XS_LONG;
        names[i] = XS_SHORT_NAME;
        codes[i++] = XS_SHORT;
        names[i] = XS_FLOAT_NAME;
        codes[i++] = XS_FLOAT;
        names[i] = XS_DOUBLE_NAME;
        codes[i++] = XS_DOUBLE;
        names[i] = XS_BOOLEAN_NAME;
        codes[i++] = XS_BOOLEAN;
        names[i] = XS_BYTE_NAME;
        codes[i++] = XS_BYTE;
        names[i] = XS_STRING_NAME;
        codes[i++] = XS_STRING;
        names[i] = XS_INTEGER_NAME;
        codes[i++] = XS_INTEGER;
        names[i] = XS_DECIMAL_NAME;
        codes[i++] = XS_DECIMAL;
        names[i] = XS_DATETIME_NAME;
        codes[i++] = XS_DATETIME;
        names[i] = XS_QNAME_NAME;
        codes[i++] = XS_QNAME;
        names[i] = XS_ANYURI_NAME;
        codes[i++] = XS_ANYURI;
        names[i] = XS_UNSIGNEDINT_NAME;
        codes[i++] = XS_UNSIGNEDINT;
        names[i] = XS_UNSIGNEDSHORT_NAME;
        codes[i++] = XS_UNSIGNEDSHORT;
        names[i] = XS_UNSIGNEDBYTE_NAME;
        codes[i++] = XS_UNSIGNEDBYTE;
        names[i] = XS_DATE_NAME;
        codes[i++] = XS_DATE;
        names[i] = XS_TIME_NAME;
        codes[i++] = XS_TIME;
        names[i] = XS_BASE64BINARY_NAME;
        codes[i++] = XS_BASE64BINARY;
        names[i] = XS_HEXBINARY_NAME;
        codes[i++] = XS_HEXBINARY;
        names[i] = XS_ANYSIMPLETYPE_NAME;
        codes[i++] = XS_ANYSIMPLETYPE;
        names[i] = XS_DURATION_NAME;
        codes[i++] = XS_DURATION;
        names[i] = XS_GYEARMONTH_NAME;
        codes[i++] = XS_GYEARMONTH;
        names[i] = XS_GYEAR_NAME;
        codes[i++] = XS_GYEAR;
        names[i] = XS_GMONTHDAY_NAME;
        codes[i++] = XS_GMONTHDAY;
        names[i] = XS_GMONTH_NAME;
        codes[i++] = XS_GMONTH;
        names[i] = XS_GDAY_NAME;
        codes[i++] = XS_GDAY;
        names[i] = XS_NORMALIZEDSTRING_NAME;
        codes[i++] = XS_NORMALIZEDSTRING;
        names[i] = XS_TOKEN_NAME;
        codes[i++] = XS_TOKEN;
        names[i] = XS_LANGUAGE_NAME;
        codes[i++] = XS_LANGUAGE;
        names[i] = XS_NAME_NAME;
        codes[i++] = XS_NAME;
        names[i] = XS_NCNAME_NAME;
        codes[i++] = XS_NCNAME;
        names[i] = XS_ID_NAME;
        codes[i++] = XS_ID;
        names[i] = XS_NMTOKEN_NAME;
        codes[i++] = XS_NMTOKEN;
        names[i] = XS_NMTOKENS_NAME;
        codes[i++] = XS_NMTOKENS;
        names[i] = XS_NONPOSITIVEINTEGER_NAME;
        codes[i++] = XS_NONPOSITIVEINTEGER;
        names[i] = XS_NONNEGATIVEINTEGER_NAME;
        codes[i++] = XS_NONNEGATIVEINTEGER;
        names[i] = XS_POSITIVEINTEGER_NAME;
        codes[i++] = XS_POSITIVEINTEGER;
        names[i] = XS_NEGATIVEINTEGER_NAME;
        codes[i++] = XS_NEGATIVEINTEGER;
        names[i] = XS_UNSIGNEDLONG_NAME;
        codes[i++] = XS_UNSIGNEDLONG;
        names[i] = XS_NOTATION_NAME;
        codes[i++] = XS_NOTATION;
        names[i] = XS_IDREF_NAME;
        codes[i++] = XS_IDREF;
        names[i] = XS_IDREFS_NAME;
        codes[i++] = XS_IDREFS;
        names[i] = XS_ENTITY_NAME;
        codes[i++] = XS_ENTITY;
        names[i] = XS_ENTITIES_NAME;
        codes[i++] = XS_ENTITIES;
        Logger log = Logger.getLogger(SimpleTypeBindings.class);
        boolean allAreUnique = true;
        for (int outer = 0; outer < names.length; ++outer) {
            int outerCode = codes[outer];
            String outerName = names[outer];
            for (int inner = outer + 1; inner < names.length; ++inner) {
                int innerCode = codes[inner];
                String innerName = names[inner];
                if (outerCode != innerCode) continue;
                log.error("Types have the same hash code " + outerCode + ": " + outerName + " and " + innerName);
                allAreUnique = false;
            }
        }
        if (!allAreUnique) {
            throw new IllegalStateException("Not all the schema types have unique hash codes! See log for more details.");
        }
    }
}

