/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins.factory;

import java.util.Iterator;
import java.util.Map;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.spi.config.KernelConfigurator;

public class GenericBeanFactory {
    protected KernelConfigurator configurator;
    protected String bean;
    protected ConstructorMetaData constructor;
    protected Map properties;

    public GenericBeanFactory(KernelConfigurator configurator) {
        this.configurator = configurator;
    }

    public Object create() throws Throwable {
        BeanInfo info = this.configurator.getBeanInfo(this.bean, this.getClass().getClassLoader());
        Joinpoint joinpoint = this.configurator.getConstructorJoinPoint(info, this.constructor, null);
        Object result = joinpoint.dispatch();
        if (this.properties != null && this.properties.size() > 0) {
            Iterator i = this.properties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String property = (String)entry.getKey();
                ValueMetaData vmd = (ValueMetaData)entry.getValue();
                TargettedJoinpoint jp = this.configurator.getPropertySetterJoinPoint(info, property, vmd);
                jp.setTarget(result);
                jp.dispatch();
            }
        }
        return result;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public ConstructorMetaData getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorMetaData constructor) {
        this.constructor = constructor;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }
}

