/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.Tracer;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class VDNNumber {
    private static final int zeroExponentValue_C = 128;
    private static final int tensComplement_C = 9;
    private static final int numberBytes_C = 20;
    private static final int numberDigits_C = 38;

    public static byte[] bigDecimal2number(BigDecimal bigDecimal) {
        return VDNNumber.bigDecimal2number(bigDecimal, 38);
    }

    public static byte[] bigDecimal2number(BigDecimal bigDecimal, int n) {
        int n2;
        boolean bl;
        byte[] byArray = new byte[20];
        int n3 = bigDecimal.scale();
        String string = bigDecimal.toString();
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        if (cArray[0] == '-') {
            bl = true;
            n2 = 1;
        } else {
            bl = false;
            n2 = 0;
        }
        while ((cArray[n2] == '0' || cArray[n2] == '.') && n2 < n4 - 1) {
            ++n2;
        }
        int n5 = cArray.length - n2 - n3;
        n4 = cArray.length - n2;
        if (n4 == 1 && cArray[n2] == '0') {
            byArray[0] = -128;
            return byArray;
        }
        if (n5 > 0 && n3 > 0) {
            --n5;
            --n4;
            System.arraycopy(cArray, cArray.length - n3, cArray, cArray.length - n3 - 1, n3);
        }
        if (n4 > n) {
            if (cArray[n2 + n] >= '5') {
                int n6 = n2 + n;
                cArray[n6] = (char)(cArray[n6] + '\u0001');
            }
            n4 = n;
        }
        int n7 = n2;
        while (n7 < n4 + n2) {
            int n8 = n7++;
            cArray[n8] = (char)(cArray[n8] - 48);
        }
        VDNNumber.packDigits(cArray, n2, n4, bl, byArray);
        n5 = bl ? 64 - n5 : (n5 += 192);
        byArray[0] = (byte)n5;
        return byArray;
    }

    public static byte[] long2number(long l) {
        boolean bl = false;
        int n = 1;
        byte[] byArray = new byte[20];
        char[] cArray = new char[39];
        int n2 = 37;
        if (l == 0L) {
            byArray[0] = -128;
            return byArray;
        }
        if (l < 0L) {
            n = -1;
            bl = true;
        }
        while (l != 0L) {
            char c;
            cArray[n2] = c = (char)((long)n * (l % 10L));
            l /= 10L;
            --n2;
        }
        int n3 = 38 - n2 - 1;
        VDNNumber.packDigits(cArray, ++n2, 38 - n2, bl, byArray);
        n3 = bl ? 64 - n3 : (n3 += 192);
        byArray[0] = (byte)n3;
        return byArray;
    }

    public static BigDecimal number2BigDecimal(byte[] byArray) throws SQLException {
        BigDecimal bigDecimal = null;
        int n = (byArray.length - 1) * 2;
        int n2 = 2;
        try {
            int n3;
            int n4 = byArray[0] & 0xFF;
            if (n4 == 128) {
                return new BigDecimal(0.0);
            }
            byte[] byArray2 = new byte[n + 2];
            if (n4 < 128) {
                n3 = -(n4 - 64);
                byArray2[0] = 45;
                byArray2[1] = 46;
                int n5 = 1;
                while (n5 < byArray.length) {
                    int n6 = ((char)byArray[n5] & 0xFF) >> 4;
                    if (n6 != 0) {
                        n2 = n5 * 2;
                    }
                    byArray2[n5 * 2] = (byte)(9 - n6 + 48);
                    n6 = (char)byArray[n5] & 0xF;
                    if (n6 != 0) {
                        n2 = n5 * 2 + 1;
                    }
                    byArray2[n5 * 2 + 1] = (byte)(9 - n6 + 48);
                    ++n5;
                }
                int n7 = n2;
                byArray2[n7] = (byte)(byArray2[n7] + 1);
            } else {
                n3 = n4 - 192;
                byArray2[0] = 48;
                byArray2[1] = 46;
                int n8 = 1;
                while (n8 < byArray.length) {
                    int n9 = ((char)byArray[n8] & 0xFF) >> 4;
                    if (n9 != 0) {
                        n2 = n8 * 2;
                    }
                    byArray2[n8 * 2] = (byte)(n9 + 48);
                    n9 = (char)byArray[n8] & 0xF;
                    if (n9 != 0) {
                        n2 = n8 * 2 + 1;
                    }
                    byArray2[n8 * 2 + 1] = (byte)(n9 + 48);
                    ++n8;
                }
            }
            String string = new String(byArray2, 0, n2 + 1);
            bigDecimal = new BigDecimal(string);
            bigDecimal = bigDecimal.movePointRight(n3);
            return bigDecimal;
        }
        catch (Exception exception) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.conversion.VDNnumber", Tracer.Hex2String(byArray)));
        }
    }

    public static long number2long(byte[] byArray) throws SQLException {
        boolean bl;
        long l = 0L;
        int n = byArray.length * 2 - 2;
        int n2 = byArray[0] & 0xFF;
        if (n2 == 128) {
            return 0L;
        }
        if (n2 < 128) {
            int n3 = -(n2 - 64);
            if (n3 < 0 || n3 > n) {
                BigDecimal bigDecimal = VDNNumber.number2BigDecimal(byArray);
                return bigDecimal.longValue();
            }
            bl = true;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = byArray[n4 / 2 + 1];
                if (n4 % 2 == 0) {
                    n5 &= 0xF0;
                    n5 >>>= 4;
                } else {
                    n5 &= 0xF;
                }
                l *= 10L;
                l += (long)(9 - n5);
                ++n4;
            }
            ++l;
        } else {
            int n6 = n2 - 192;
            if (n6 < 0 || n6 > n) {
                BigDecimal bigDecimal = VDNNumber.number2BigDecimal(byArray);
                return bigDecimal.longValue();
            }
            bl = false;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = byArray[n7 / 2 + 1];
                if (n7 % 2 == 0) {
                    n8 &= 0xF0;
                    n8 >>>= 4;
                } else {
                    n8 &= 0xF;
                }
                l *= 10L;
                l += (long)n8;
                ++n7;
            }
        }
        if (bl) {
            l = -l;
        }
        return l;
    }

    public static BigDecimal number2BigDecimal(byte[] byArray, int n) throws SQLException {
        return VDNNumber.number2BigDecimal(byArray).setScale(n);
    }

    public static int number2int(byte[] byArray) throws SQLException {
        return (int)VDNNumber.number2long(byArray);
    }

    private static void packDigits(char[] cArray, int n, int n2, boolean bl, byte[] byArray) {
        int n3;
        int n4 = n + n2 - 1;
        if (bl) {
            n3 = n;
            while (n3 < n4) {
                cArray[n3] = (char)(9 - cArray[n3]);
                ++n3;
            }
            cArray[n4] = (char)(10 - cArray[n4]);
            int n5 = n4;
            while (cArray[n5] == '\n') {
                cArray[n5] = '\u0000';
                int n6 = n5 - 1;
                cArray[n6] = (char)(cArray[n6] + '\u0001');
                --n5;
            }
        }
        n3 = 1;
        while (n <= n4) {
            byte by = (byte)cArray[n];
            byte by2 = n + 1 <= n4 ? (byte)cArray[n + 1] : (byte)0;
            byArray[n3] = (byte)(by << 4 | by2);
            ++n3;
            n += 2;
        }
    }

    public static void dumpVDN(String string, byte[] byArray) {
        StructuredBytes structuredBytes = new StructuredBytes(byArray);
        System.out.println(string);
        structuredBytes.traceOn(System.out);
    }
}

