/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbcext.ClientConnectionSapDB;
import com.sap.dbtech.jdbcext.ConnectionListenerBag;
import com.sap.dbtech.jdbcext.XADataSourceSapDB;
import com.sap.dbtech.jdbcext.XATrace;
import com.sap.dbtech.jdbcext.XATransaction;
import com.sap.dbtech.util.MessageTranslator;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAConnectionSapDB
extends ConnectionListenerBag
implements XAResource,
XAConnection {
    Properties connectProperties;
    XADataSourceSapDB ds;
    XATrace trace;
    WeakReference lastClientConnection;
    Connection nonTxConnection;
    XATransaction currentTransaction;
    int transactionTimeout;
    private static Hashtable xacodes;

    XAConnectionSapDB(Properties properties, XADataSourceSapDB xADataSourceSapDB, XATrace xATrace) {
        this.connectProperties = properties;
        this.ds = xADataSourceSapDB;
        this.trace = xATrace;
        this.nonTxConnection = null;
        this.currentTransaction = null;
        this.transactionTimeout = 30;
    }

    boolean isTraceEnabled() {
        return this.trace != null;
    }

    void traceXAError(Xid xid, int n) {
        if (this.trace != null) {
            this.trace.traceXAError(xid, n);
        }
    }

    void trace(Xid xid, String string) {
        if (this.trace != null) {
            this.trace.trace(xid, string);
        }
    }

    void trace(String string) {
        if (this.trace != null) {
            this.trace.trace(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        XAConnectionSapDB xAConnectionSapDB = this;
        synchronized (xAConnectionSapDB) {
            this.closeLastOpenClient();
            if (this.nonTxConnection != null) {
                this.nonTxConnection.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.closeLastOpenClient();
        XAClientConnectionSapDB xAClientConnectionSapDB = new XAClientConnectionSapDB();
        this.lastClientConnection = new WeakReference<XAClientConnectionSapDB>(xAClientConnectionSapDB);
        return xAClientConnectionSapDB;
    }

    public XAResource getXAResource() throws SQLException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int n) throws XAException {
        XAConnectionSapDB xAConnectionSapDB = this;
        synchronized (xAConnectionSapDB) {
            if (this.isTraceEnabled()) {
                this.trace(xid, "start");
            }
            if (xid == null) {
                this.xaerror(xid, -5);
            }
            if (this.currentTransaction != null) {
                this.xaerror(xid, -9);
            }
            switch (n) {
                case 0: {
                    if (this.isTraceEnabled()) {
                        this.trace(xid, "start: TMNOFLAGS");
                    }
                    XADataSourceSapDB xADataSourceSapDB = this.ds;
                    synchronized (xADataSourceSapDB) {
                        XATransaction xATransaction = null;
                        xATransaction = this.ds.getXATransaction(xid);
                        if (xATransaction != null) {
                            this.xaerror(xid, -8);
                        }
                        try {
                            Connection connection;
                            if (this.nonTxConnection != null) {
                                this.nonTxConnection.setAutoCommit(false);
                                connection = this.nonTxConnection;
                                this.nonTxConnection = null;
                            } else {
                                connection = this.ds.openPhysicalConnection(this.connectProperties);
                            }
                            long l = System.currentTimeMillis() + (long)(1000 * this.transactionTimeout);
                            this.currentTransaction = new XATransaction(xid, connection, l);
                            this.ds.addXATransaction(this.currentTransaction);
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                            this.xaerror(xid, -3);
                        }
                        break;
                    }
                }
                case 0x200000: {
                    if (this.isTraceEnabled()) {
                        this.trace(xid, "start: TMJOIN");
                    }
                    XADataSourceSapDB xADataSourceSapDB = this.ds;
                    synchronized (xADataSourceSapDB) {
                        XATransaction xATransaction = this.ds.getXATransaction(xid);
                        if (xATransaction == null) {
                            this.xaerror(xid, -5);
                        }
                        this.currentTransaction = xATransaction;
                        break;
                    }
                }
                case 0x8000000: {
                    if (this.isTraceEnabled()) {
                        this.trace(xid, "start: TMRESUME");
                    }
                    XADataSourceSapDB xADataSourceSapDB = this.ds;
                    synchronized (xADataSourceSapDB) {
                        XATransaction xATransaction = this.ds.getXATransaction(xid);
                        if (xATransaction == null) {
                            this.xaerror(xid, -5);
                        }
                        this.currentTransaction = xATransaction;
                        break;
                    }
                }
                default: {
                    if (this.isTraceEnabled()) {
                        this.trace(xid, "start: unknown flags");
                    }
                    this.xaerror(xid, -5);
                }
            }
        }
    }

    public void end(Xid xid, int n) throws XAException {
        if (this.isTraceEnabled()) {
            this.trace(xid, "end");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        if (this.currentTransaction == null) {
            this.xaerror(xid, -6);
        }
        switch (n) {
            case 0x4000000: {
                if (this.isTraceEnabled()) {
                    this.trace(xid, "end: TMSUCCESS");
                }
                if (!this.currentTransaction.xid.equals(xid)) {
                    this.xaerror(xid, -4);
                }
                if (this.currentTransaction.getStatus() == 2) {
                    this.xaerror(xid, 106);
                }
                this.currentTransaction = null;
                this.silentCloseLastOpenClient();
                break;
            }
            case 0x20000000: {
                if (this.isTraceEnabled()) {
                    this.trace(xid, "end: TMFAIL");
                }
                if (!this.currentTransaction.xid.equals(xid)) {
                    this.xaerror(xid, -4);
                }
                if (this.currentTransaction.getStatus() == 2) {
                    this.xaerror(xid, 106);
                }
                this.currentTransaction = null;
                this.silentCloseLastOpenClient();
                break;
            }
            case 0x2000000: {
                if (this.isTraceEnabled()) {
                    this.trace(xid, "end: TMSUSPEND");
                }
                if (!this.currentTransaction.xid.equals(xid)) {
                    this.xaerror(xid, -4);
                }
                if (this.currentTransaction.getStatus() == 2) {
                    this.xaerror(xid, 106);
                }
                this.currentTransaction = null;
                this.silentCloseLastOpenClient();
                break;
            }
            default: {
                this.xaerror(xid, -5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        if (this.isTraceEnabled()) {
            this.trace(xid, "commit");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        XADataSourceSapDB xADataSourceSapDB = this.ds;
        synchronized (xADataSourceSapDB) {
            XATransaction xATransaction = this.ds.getXATransaction(xid);
            if (xATransaction == null) {
                this.xaerror(xid, -4);
            }
            if (xATransaction.getStatus() == 2) {
                this.xaerror(xid, 6);
            }
            if (this.currentTransaction == xATransaction) {
                this.currentTransaction = null;
                this.silentCloseLastOpenClient();
            }
            if (bl || xATransaction.getStatus() == 3) {
                try {
                    xATransaction.commitRelease();
                }
                catch (SQLException sQLException) {
                    try {
                        xATransaction.rollbackRelease();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    this.ds.removeXATransaction(xid);
                    this.xaerror(xid, 6);
                }
                this.ds.removeXATransaction(xid);
            } else {
                this.xaerror(xid, -6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        if (this.isTraceEnabled()) {
            this.trace(xid, "rollback");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        XADataSourceSapDB xADataSourceSapDB = this.ds;
        synchronized (xADataSourceSapDB) {
            XATransaction xATransaction = this.ds.getXATransaction(xid);
            if (xATransaction == null) {
                this.xaerror(xid, -4);
            }
            if (xATransaction.getStatus() == 2) {
                this.ds.removeXATransaction(xid);
            }
            if (xATransaction.getStatus() == 1) {
                this.ds.removeXATransaction(xid);
                this.xaerror(xid, -3);
            }
            try {
                xATransaction.rollbackRelease();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.ds.removeXATransaction(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        if (this.isTraceEnabled()) {
            this.trace(xid, "forget");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        XADataSourceSapDB xADataSourceSapDB = this.ds;
        synchronized (xADataSourceSapDB) {
            XATransaction xATransaction = this.ds.getXATransaction(xid);
            if (xATransaction != null) {
                if (this.currentTransaction == xATransaction) {
                    this.currentTransaction = null;
                    this.silentCloseLastOpenClient();
                }
                this.ds.removeXATransaction(xid);
                try {
                    xATransaction.rollbackRelease();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = false;
        if (xAResource != null && xAResource instanceof XAConnectionSapDB) {
            XAConnectionSapDB xAConnectionSapDB = (XAConnectionSapDB)xAResource;
            bl = xAConnectionSapDB.ds == this.ds;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        if (this.isTraceEnabled()) {
            this.trace(xid, "prepare");
        }
        if (xid == null) {
            this.xaerror(xid, -5);
        }
        XAConnectionSapDB xAConnectionSapDB = this;
        synchronized (xAConnectionSapDB) {
            if (this.currentTransaction != null && this.currentTransaction.xid.equals(xid)) {
                this.silentCloseLastOpenClient();
                this.currentTransaction = null;
            }
        }
        XADataSourceSapDB xADataSourceSapDB = this.ds;
        synchronized (xADataSourceSapDB) {
            XATransaction xATransaction = this.ds.getXATransaction(xid);
            if (xATransaction == null) {
                this.xaerror(xid, -4);
            }
            if (xATransaction.getStatus() == 2) {
                this.xaerror(xid, 100);
            }
            xATransaction.setStatus(3);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int n) throws XAException {
        XADataSourceSapDB xADataSourceSapDB = this.ds;
        synchronized (xADataSourceSapDB) {
            Xid[] xidArray = this.ds.getAllPrepared();
            return xidArray;
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            this.xaerror(null, -5);
        }
        this.transactionTimeout = n;
        return false;
    }

    void sendErrorEvent(SQLException sQLException) {
        super.sendErrorEvent(this, sQLException);
    }

    void sendCloseEvent() {
        super.sendCloseEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getRealConnection(Object object) throws SQLException {
        Object var2_2;
        Object v0 = var2_2 = this.lastClientConnection == null ? null : this.lastClientConnection.get();
        if (var2_2 != object) {
            return null;
        }
        XAConnectionSapDB xAConnectionSapDB = this;
        synchronized (xAConnectionSapDB) {
            block7: {
                if (this.currentTransaction == null) break block7;
                ((XAClientConnectionSapDB)object).setTransactional(true);
                if (this.currentTransaction.physicalConnection != null) {
                    this.currentTransaction.physicalConnection.setAutoCommit(false);
                }
                Connection connection = this.currentTransaction.physicalConnection;
                return connection;
            }
            if (this.nonTxConnection == null) {
                this.nonTxConnection = this.ds.openPhysicalConnection(this.connectProperties);
            }
            ((XAClientConnectionSapDB)object).setTransactional(false);
            Connection connection = this.nonTxConnection;
            return connection;
        }
    }

    XAConnectionSapDB self() {
        return this;
    }

    void silentCloseLastOpenClient() {
        try {
            this.closeLastOpenClient();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLastOpenClient() throws SQLException {
        Object var1_1;
        Object v0 = var1_1 = this.lastClientConnection == null ? null : this.lastClientConnection.get();
        if (var1_1 != null) {
            XAConnectionSapDB xAConnectionSapDB = this;
            synchronized (xAConnectionSapDB) {
                XAClientConnectionSapDB xAClientConnectionSapDB = var1_1;
                xAClientConnectionSapDB.close();
            }
        }
    }

    private void xaerror(Xid xid, int n) throws XAException {
        if (this.isTraceEnabled()) {
            this.traceXAError(xid, n);
        }
        throw new XAException(n);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    class XAClientConnectionSapDB
    extends ClientConnectionSapDB {
        boolean closed = false;
        boolean transactional = false;

        XAClientConnectionSapDB() {
        }

        public Connection getPhysicalConnection() throws SQLException {
            Connection connection = XAConnectionSapDB.this.getRealConnection(this);
            if (connection == null) {
                throw new ObjectIsClosedException(this);
            }
            return connection;
        }

        public void setTransactional(boolean bl) {
            this.transactional = bl;
        }

        public void exceptionOccurred(SQLException sQLException) {
            XAConnectionSapDB.this.sendErrorEvent(sQLException);
        }

        public boolean isClosed() throws SQLException {
            return this.closed || XAConnectionSapDB.this.getRealConnection(this) == null || super.isClosed();
        }

        public void setAutoCommit(boolean bl) throws SQLException {
            if (this.transactional) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.autocommit.xasession"));
            }
            super.setAutoCommit(bl);
        }

        public void rollback() throws SQLException {
            if (this.transactional) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.rollback.xasession"));
            }
            super.rollback();
        }

        public void commit() throws SQLException {
            if (this.transactional) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.commit.xasession"));
            }
            super.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            if (!this.closed) {
                XAConnectionSapDB xAConnectionSapDB = XAConnectionSapDB.this.self();
                synchronized (xAConnectionSapDB) {
                    try {
                        if (this.transactional) {
                            this.closed = true;
                            XAConnectionSapDB.this.sendCloseEvent();
                        } else {
                            if (!this.getAutoCommit()) {
                                this.rollback();
                            }
                            this.closed = true;
                            XAConnectionSapDB.this.sendCloseEvent();
                        }
                    }
                    catch (ObjectIsClosedException objectIsClosedException) {
                        XAConnectionSapDB.this.sendCloseEvent();
                    }
                }
            }
        }

        public void finalize() {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

