/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

class TimestampTranslator
extends CharDataTranslator {
    public static final long day0 = new Time(0, 0, 0).getTime();
    public static final long day1 = new Time(23, 59, 59).getTime();
    public static final String zeroPadC = "0000";

    protected TimestampTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getTimestamp(sQLParamController, structuredMem);
    }

    public java.sql.Date getDate(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        Timestamp timestamp = this.getTimestamp(sQLParamController, structuredMem);
        java.sql.Date date = null;
        if (timestamp != null) {
            date = new java.sql.Date(timestamp.getTime());
        }
        return date;
    }

    public Time getTime(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        Timestamp timestamp = this.getTimestamp(sQLParamController, structuredMem);
        Time time = null;
        if (timestamp != null) {
            time = new Time(timestamp.getTime());
        }
        return time;
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        Timestamp timestamp = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            String string = structuredMem.getString(this.bufpos, this.physicalLength - 1);
            timestamp = Timestamp.valueOf(string);
        }
        return timestamp;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return this.transTimestampForInput(Timestamp.valueOf(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                java.sql.Date date = java.sql.Date.valueOf(string);
                return this.transTimestampForInput(new Timestamp(date.getTime()));
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    Time time = Time.valueOf(string);
                    return this.transTimestampForInput(new Timestamp(time.getTime()));
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    throw this.newParseException(string, "Timestamp");
                }
            }
        }
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof Timestamp) {
            object2 = this.transTimestampForInput((Timestamp)object);
        } else if (object instanceof Time) {
            String string = ((Time)object).toString();
            String string2 = new java.sql.Date(new Date().getTime()).toString();
            String string3 = string2 + " " + string + ".0";
            Timestamp timestamp = Timestamp.valueOf(string3);
            object2 = this.transTimestampForInput(timestamp);
        } else if (object instanceof java.sql.Date) {
            String string = ((java.sql.Date)object).toString();
            String string4 = string + " 00:00:00.0";
            Timestamp timestamp = Timestamp.valueOf(string4);
            object2 = this.transTimestampForInput(timestamp);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            object2 = this.transTimestampForInput(new Timestamp(date.getTime()));
        } else if (object instanceof String) {
            String string = (String)object;
            object2 = this.transStringForInput(string);
        }
        return object2;
    }

    public Object transTimestampForInput(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        String string = timestamp.toString();
        int n = 4 - string.indexOf(45);
        if (n > 0) {
            string = zeroPadC.substring(0, n) + string;
        }
        if ((n = string.length() - this.logicalLength) > 0) {
            string = string.substring(0, this.logicalLength);
        }
        return string;
    }
}

