/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import java.sql.SQLException;
import java.util.Hashtable;

public class FetchInfo {
    private ConnectionSapDB connection;
    private String cursorName;
    private DBTechTranslator[] columnInfo;
    private int recordSize;
    private Hashtable columnMapping;
    private String _fetchparamstring;
    boolean marker = false;

    public FetchInfo(ConnectionSapDB connectionSapDB, String string, DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        this.connection = connectionSapDB;
        this.cursorName = string;
        if (dBTechTranslatorArray == null || stringArray == null) {
            this.describe();
        } else {
            this.setMetaData(dBTechTranslatorArray, stringArray);
        }
    }

    private void describe() throws SQLException {
        ConnectionSapDB connectionSapDB = this.connection;
        DBTechTranslator[] dBTechTranslatorArray = null;
        String[] stringArray = null;
        RequestPacket requestPacket = connectionSapDB.getRequestPacket();
        requestPacket.initDbsCommand(false, "DESCRIBE \"" + this.cursorName + "\"");
        ReplyPacket replyPacket = connectionSapDB.execute(requestPacket, this, true);
        PartEnumeration partEnumeration = replyPacket.partEnumeration();
        while (partEnumeration.hasMoreElements()) {
            partEnumeration.nextElement();
            int n = partEnumeration.partKind();
            if (n == 2) {
                stringArray = replyPacket.parseColumnNames();
                continue;
            }
            if (n != 14) continue;
            dBTechTranslatorArray = replyPacket.parseShortFields();
        }
        this.setMetaData(dBTechTranslatorArray, stringArray);
    }

    private void setMetaData(DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        int n = dBTechTranslatorArray.length;
        this.recordSize = 0;
        this.connection = this.connection;
        this.columnMapping = new Hashtable(2 * n);
        if (n == stringArray.length) {
            this.columnInfo = dBTechTranslatorArray;
            int n2 = 0;
            while (n2 < n) {
                DBTechTranslator dBTechTranslator = dBTechTranslatorArray[n2];
                String string = stringArray[n2];
                dBTechTranslator.setColName(string);
                dBTechTranslator.setColIndex(n2);
                this.columnMapping.put(string, dBTechTranslator);
                int n3 = dBTechTranslator.getPhysicalLength() + dBTechTranslator.getBufpos() - 1;
                this.recordSize = Math.max(this.recordSize, n3);
                ++n2;
            }
        } else {
            int n4 = 0;
            this.columnInfo = new DBTechTranslator[stringArray.length];
            int n5 = 0;
            while (n5 < n) {
                if (dBTechTranslatorArray[n5].isOutput()) {
                    DBTechTranslator dBTechTranslator = this.columnInfo[n4] = dBTechTranslatorArray[n5];
                    String string = stringArray[n4];
                    dBTechTranslator.setColName(string);
                    dBTechTranslator.setColIndex(n4++);
                    this.columnMapping.put(string, dBTechTranslator);
                    int n6 = dBTechTranslator.getPhysicalLength() + dBTechTranslator.getBufpos() - 1;
                    this.recordSize = Math.max(this.recordSize, n6);
                }
                ++n5;
            }
        }
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public ReplyPacket executeFetchAbsolute(long l, int n) throws SQLException {
        String string = "FETCH ABSOLUTE " + l + " \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        ReplyPacket replyPacket = this.executeFetchCommand(string, n);
        return replyPacket;
    }

    public ReplyPacket executeFetchRelative(long l, int n) throws SQLException {
        String string = "FETCH RELATIVE " + l + " \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        return this.executeFetchCommand(string, n);
    }

    public ReplyPacket executeFetchFirst(int n) throws SQLException {
        String string = "FETCH FIRST \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        return this.executeFetchCommand(string, n);
    }

    public ReplyPacket executeFetchLast(int n) throws SQLException {
        String string = "FETCH LAST \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        return this.executeFetchCommand(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplyPacket executeFetchCommand(String string, int n) throws SQLException {
        ReplyPacket replyPacket;
        RequestPacket requestPacket = this.connection.getRequestPacket();
        int n2 = requestPacket.switchSqlMode(2);
        requestPacket.initDbsCommand(false, string);
        if (n > 1) {
            requestPacket.setMassCommand();
        } else {
            n = 1;
        }
        requestPacket.addResultCount(n);
        try {
            replyPacket = this.connection.execute(requestPacket, this, false);
            Object var7_6 = null;
            requestPacket.switchSqlMode(n2);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            requestPacket.switchSqlMode(n2);
            throw throwable;
        }
        return replyPacket;
    }

    private String getFetchParamString() {
        if (this._fetchparamstring == null) {
            StringBuffer stringBuffer = new StringBuffer("?");
            int n = 1;
            while (n < this.columnInfo.length) {
                stringBuffer.append(", ?");
                ++n;
            }
            this._fetchparamstring = stringBuffer.toString();
        }
        return this._fetchparamstring;
    }

    public final DBTechTranslator getColumnInfo(String string) {
        String string2;
        Object v = this.columnMapping.get(string);
        if (v == null && (v = this.columnMapping.get(string2 = string.toUpperCase())) != null) {
            this.columnMapping.put(string2, v);
        }
        return (DBTechTranslator)v;
    }

    public DBTechTranslator[] getColInfo() {
        return this.columnInfo;
    }

    int numberOfColumns() {
        return this.columnInfo.length;
    }

    int getRecordSize() {
        return this.recordSize;
    }
}

