/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.SuiteResult;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGHTMLReporter {
    public static final String METHODS = "methods.html";
    public static final String GROUPS = "groups.html";
    public static final String CLASSES = "classes.html";
    private Map<String, ITestClass> m_classes = new HashMap<String, ITestClass>();
    private List<ISuite> m_suites = new ArrayList<ISuite>();
    private String m_outputDirectory;
    private static final String SP = "&nbsp;";
    private static final String SP2 = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String SP3 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String SP4 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final String AFTER = "&lt;&lt;";
    public static final String BEFORE = "&gt;&gt;";

    public TestNGHTMLReporter(List<ISuite> suites, String outputDirectory) {
        this.m_suites = suites;
        this.m_outputDirectory = outputDirectory;
    }

    public void generate() {
        this.generateTableOfContents();
        this.generateSuites();
        this.generateIndex();
        this.generateMain();
        this.generateMethodsAndGroups();
        this.generateMethodsChronologically();
        this.generateClasses();
    }

    private void generateClasses() {
        StringBuffer sb = new StringBuffer();
        sb.append("<h2>Test classes</h2>");
        for (ITestClass tc : this.m_classes.values()) {
            sb.append(this.generateClass(tc));
        }
        Utils.writeFile(this.m_outputDirectory, CLASSES, sb);
    }

    private String generateClass(ITestClass cls) {
        StringBuffer sb = new StringBuffer();
        sb.append("<hr width=\"100%\"/>").append("<h3>").append(cls.getRealClass().getName()).append("</h3>");
        sb.append(SP3).append("Test methods<p>\n").append(this.dumpMethods(cls.getTestMethods())).append(SP3).append("beforeClass methods<p>\n").append(this.dumpMethods(cls.getBeforeClassMethods())).append(SP3).append("beforeTest methods<p>\n").append(this.dumpMethods(cls.getBeforeTestMethods())).append(SP3).append("afterTest methods<p>\n").append(this.dumpMethods(cls.getAfterTestMethods())).append(SP3).append("afterClass methods<p>\n").append(this.dumpMethods(cls.getAfterClassMethods()));
        String result = sb.toString();
        return result;
    }

    private String dumpMethods(ITestNGMethod[] testMethods) {
        StringBuffer sb = new StringBuffer();
        for (ITestNGMethod tm : testMethods) {
            sb.append(this.dumpGroups(tm.getGroups())).append(SP4).append(tm.getMethodName()).append("()<p>\n");
        }
        sb.append("</table>");
        String result = sb.toString();
        return result;
    }

    private String dumpGroups(String[] groups) {
        StringBuffer sb = new StringBuffer();
        if (null != groups && groups.length > 0) {
            sb.append(SP4).append("<em>[");
            for (String g : groups) {
                sb.append(g).append(" ");
            }
            sb.append("]</em><br>\n");
        }
        String result = sb.toString();
        return result;
    }

    private void generateMethodsChronologically() {
        StringBuffer sb = new StringBuffer();
        sb.append("<h2>Methods run, sorted chronologically</h2>");
        sb.append("<h3>&gt;&gt; means before, &lt;&lt; means after<p>");
        for (ISuite suite : this.m_suites) {
            HashMap<Long, StringBuffer> tables = new HashMap<Long, StringBuffer>();
            sb.append("<br><em>").append(suite.getName()).append("</em><p>");
            for (ITestNGMethod tm : suite.getInvokedMethods()) {
                String configurationTestMethod;
                String configurationClassMethod;
                boolean isSuite;
                Long id = new Long(0L);
                StringBuffer table = (StringBuffer)tables.get(id);
                if (null == table) {
                    table = new StringBuffer();
                    tables.put(id, table);
                    table.append("<table border=\"1\">\n").append("<tr>").append("<th>Time</th>").append("<th>Suite configuration</th>").append("<th>Class configuration</th>").append("<th>Method configuration</th>").append("<th>Test method</th>").append("<th>Thread</th>").append("<th>Instances</th>").append("</tr>\n");
                }
                String mn = tm.toString();
                boolean bc = tm.isBeforeClassConfiguration();
                boolean ac = tm.isAfterClassConfiguration();
                boolean bm = tm.isBeforeMethodConfiguration();
                boolean am = tm.isAfterMethodConfiguration();
                boolean bs = tm.isBeforeSuiteConfiguration();
                boolean as = tm.isAfterSuiteConfiguration();
                boolean isClass = bc || ac;
                boolean isMethod = bm || am;
                boolean bl = isSuite = bs || as;
                String string = isClass ? (bc ? BEFORE : AFTER) + mn : (configurationClassMethod = SP);
                String string2 = isMethod ? (bm ? BEFORE : AFTER) + mn : (configurationTestMethod = SP);
                String configurationSuiteMethod = isSuite ? (bs ? BEFORE : AFTER) + mn : SP;
                String testMethod = tm.isTest() ? mn : SP;
                StringBuffer instances = new StringBuffer();
                for (long o : tm.getInstanceHashCodes()) {
                    instances.append(o).append(" ");
                }
                table.append("<tr>").append("  <td>").append(tm.getDate()).append("</td> ").append(this.td(configurationSuiteMethod)).append(this.td(configurationClassMethod)).append(this.td(configurationTestMethod)).append(this.td(testMethod)).append("  <td>").append(tm.getId()).append("</td> ").append("  <td>").append(instances).append("</td> ").append("</tr>\n");
            }
            for (StringBuffer table : tables.values()) {
                table.append("</table>\n");
                sb.append(table.toString());
            }
        }
        Utils.writeFile(this.m_outputDirectory, METHODS, sb);
    }

    private String td(String s) {
        StringBuffer result = new StringBuffer();
        String prefix = "";
        if (s.startsWith(BEFORE)) {
            prefix = BEFORE;
        } else if (s.startsWith(AFTER)) {
            prefix = AFTER;
        }
        if (!s.equals(SP)) {
            result.append("<td title=\"").append(s).append("\">");
            int open = s.lastIndexOf("(");
            int start = s.substring(0, open).lastIndexOf(".");
            int end = s.lastIndexOf(")");
            if (start >= 0) {
                result.append(prefix + s.substring(start + 1, open));
            } else {
                result.append(prefix + s);
            }
            result.append("</td> \n");
        } else {
            result.append("<td>").append(SP).append("</td>");
        }
        return result.toString();
    }

    private void ppp(String s) {
        System.out.println("[SuiteHTMLReporter] " + s);
    }

    private void generateMethodsAndGroups() {
        StringBuffer sb = new StringBuffer();
        for (ISuite suite : this.m_suites) {
            Map<String, Collection<ITestNGMethod>> groups = suite.getMethodsByGroups();
            sb.append("<h2>Groups used for this test run</h2>");
            if (groups.size() > 0) {
                sb.append("<table border=\"1\">\n").append("<tr> <td align=\"center\"><b>Group name</b></td>").append("<td align=\"center\"><b>Methods</b></td>");
                Object[] groupNames = groups.keySet().toArray(new String[groups.size()]);
                Arrays.sort(groupNames);
                for (Object group : groupNames) {
                    Collection<ITestNGMethod> methods = groups.get(group);
                    sb.append("<tr><td>").append((String)group).append("</td>");
                    StringBuffer methodNames = new StringBuffer();
                    HashMap<ITestNGMethod, ITestNGMethod> uniqueMethods = new HashMap<ITestNGMethod, ITestNGMethod>();
                    for (ITestNGMethod tm : methods) {
                        uniqueMethods.put(tm, tm);
                    }
                    for (ITestNGMethod tm : uniqueMethods.values()) {
                        methodNames.append(tm.toString()).append("<br>");
                    }
                    sb.append("<td>" + methodNames.toString() + "</td></tr>\n");
                }
                sb.append("</table>\n");
            }
            Utils.writeFile(this.m_outputDirectory, GROUPS, sb);
        }
    }

    private void generateIndex() {
        StringBuffer titles = new StringBuffer();
        for (ISuite sr : this.m_suites) {
            titles.append(this.makeTitle(sr));
        }
        StringBuffer index = new StringBuffer().append("<html><head><title>" + titles + "</title></head>\n").append("<frameset cols=\"26%,74%\">\n").append("<frame src=\"toc.html\" name=\"navFrame\">\n").append("<frame src=\"main.html\" name=\"mainFrame\">\n").append("</frameset>\n").append("</html>\n");
        Utils.writeFile(this.m_outputDirectory, "index.html", index);
    }

    private String makeTitle(ISuite suite) {
        return "Results for<br><em>" + suite.getName() + "</em>";
    }

    private void generateMain() {
        StringBuffer titles = new StringBuffer();
        for (ISuite sr : this.m_suites) {
            titles.append(this.makeTitle(sr));
        }
        StringBuffer index = new StringBuffer().append("<html><head><title>" + titles + "</title></head>\n").append("Select a result on the left-hand pane.").append("</html>\n");
        Utils.writeFile(this.m_outputDirectory, "main.html", index);
    }

    private void generateTableOfContents() {
        StringBuffer tableOfContents = new StringBuffer();
        for (ISuite suite : this.m_suites) {
            Serializable tc;
            Map<String, ISuiteResult> suiteResults = suite.getResults();
            int groupCount = suite.getMethodsByGroups().size();
            int methodCount = 0;
            for (ISuiteResult sr : suiteResults.values()) {
                ITestNGMethod[] methods = sr.getTestContext().getAllTestMethods();
                methodCount += Utils.calculateInvokedMethodCount(methods);
                for (ITestNGMethod tm : methods) {
                    tc = tm.getTestClass();
                    this.m_classes.put(tc.getRealClass().getName(), (ITestClass)tc);
                }
            }
            String name = this.makeTitle(suite);
            tableOfContents.append("<html><head><title>" + name + "</title></head><body>\n").append("<h3><p align=\"center\">" + name + "</p></h3>\n").append("<p align=\"center\">").append(suiteResults.size() + " tests, ").append("<a href=\"").append(GROUPS).append("\" ").append("target=\"mainFrame\">" + groupCount + " groups</a>, ").append("<a href=\"").append(METHODS).append("\" ").append("target=\"mainFrame\">" + methodCount + " methods</a>, ").append("<a href=\"").append(CLASSES).append("\" ").append("target=\"mainFrame\">" + this.m_classes.size() + " classes</a>.");
            HashMap<String, ISuiteResult> redResults = new HashMap<String, ISuiteResult>();
            HashMap<String, ISuiteResult> yellowResults = new HashMap<String, ISuiteResult>();
            HashMap<String, ISuiteResult> greenResults = new HashMap<String, ISuiteResult>();
            for (String suiteName : suiteResults.keySet()) {
                ISuiteResult sr = suiteResults.get(suiteName);
                tc = sr.getTestContext();
                int failed = tc.getFailedTests().size();
                int skipped = tc.getSkippedTests().size();
                if (failed > 0) {
                    redResults.put(suiteName, sr);
                    continue;
                }
                if (skipped > 0) {
                    yellowResults.put(suiteName, sr);
                    continue;
                }
                greenResults.put(suiteName, sr);
            }
            String[] colors = new String[]{"#DD0000", "#CCCC00", "#00AA00"};
            ISuiteResult[][] results = new ISuiteResult[][]{this.sortResults(redResults.values()), this.sortResults(yellowResults.values()), this.sortResults(greenResults.values())};
            for (int i = 0; i < colors.length; ++i) {
                ISuiteResult[] r;
                for (ISuiteResult sr : r = results[i]) {
                    String suiteName = sr.getTestContext().getName();
                    this.generateSuiteResult(suiteName, sr, colors[i], tableOfContents, this.m_outputDirectory);
                }
            }
        }
        Utils.writeFile(this.m_outputDirectory, "toc.html", tableOfContents);
    }

    private ISuiteResult[] sortResults(Collection<ISuiteResult> r) {
        Object[] result = r.toArray(new ISuiteResult[r.size()]);
        Arrays.sort(result);
        return result;
    }

    private void generateSuiteResult(String suiteName, ISuiteResult sr, String color, StringBuffer tableOfContents, String outputDirectory) {
        ITestContext tc = sr.getTestContext();
        int passed = tc.getPassedTests().size();
        int failed = tc.getFailedTests().size();
        int skipped = tc.getSkippedTests().size();
        String baseFile = tc.getName();
        tableOfContents.append("<table width=\"100%\" bgcolor=\"").append(color).append("\">\n").append("<tr><td>").append("<table><tr>").append("<td valign=\"top\">").append(suiteName).append(" (").append(passed).append("/").append(failed).append("/").append(skipped).append(")").append("</td>").append("<td valign=\"top\" halign=\"right\">\n").append("  <a href=\"" + baseFile + ".html\" target=\"mainFrame\">Results</a>\n").append("</td>").append("</tr></table>").append("</td></tr><p>");
        tableOfContents.append("</table></body></html>\n");
    }

    private void generateSuites() {
        for (ISuite suite : this.m_suites) {
            Map<String, ISuiteResult> suiteResults = suite.getResults();
            String outputDir = this.m_outputDirectory;
            for (String propertyFileName : suiteResults.keySet()) {
                SuiteResult sr = (SuiteResult)suiteResults.get(propertyFileName);
                ITestContext testContext = sr.getTestContext();
                StringBuffer sb = new StringBuffer();
                for (String name : suiteResults.keySet()) {
                    ISuiteResult suiteResult = suiteResults.get(name);
                    sb.append(suiteResult.toString());
                }
                Utils.writeFile(outputDir, testContext.getName() + ".properties", sb);
            }
        }
    }
}

