/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Map;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.TestRunner;
import org.testng.internal.IInvoker;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMethodWorker
implements Runnable {
    private ITestNGMethod[] m_testMethods;
    private IInvoker m_invoker = null;
    private Map<String, String> m_parameters = null;
    private XmlSuite m_suite = null;
    private Map<ITestClass, ITestClass> m_invokedBeforeClassMethods = null;
    private Map<ITestClass, ITestClass> m_invokedAfterClassMethods = null;
    private ITestNGMethod[] m_allTestMethods;

    public TestMethodWorker(IInvoker invoker, ITestNGMethod[] testMethods, XmlSuite suite, Map<String, String> parameters, Map<ITestClass, ITestClass> invokedBeforeClassMethods, Map<ITestClass, ITestClass> invokedAfterClassMethods, ITestNGMethod[] allTestMethods) {
        this.m_invoker = invoker;
        this.m_testMethods = testMethods;
        this.m_suite = suite;
        this.m_parameters = parameters;
        this.m_invokedBeforeClassMethods = invokedBeforeClassMethods;
        this.m_invokedAfterClassMethods = invokedAfterClassMethods;
        this.m_allTestMethods = allTestMethods;
    }

    public long getMaxTimeOut() {
        long result = 0L;
        for (ITestNGMethod tm : this.m_testMethods) {
            if (tm.getTimeOut() <= result) continue;
            result = tm.getTimeOut();
        }
        return result;
    }

    public String toString() {
        return "[Worker on thread:" + Thread.currentThread().getId() + " " + this.m_testMethods[0] + "]";
    }

    @Override
    public void run() {
        for (ITestNGMethod tm : this.m_testMethods) {
            ITestClass testClass = tm.getTestClass();
            if (!this.m_invokedBeforeClassMethods.containsKey(testClass)) {
                this.m_invoker.invokeConfigurations(testClass, testClass.getBeforeClassMethods(), this.m_suite, this.m_parameters, null);
                this.m_invokedBeforeClassMethods.put(testClass, testClass);
            }
            this.m_invoker.invokeTestMethods(tm, this.m_suite, this.m_parameters, this.m_allTestMethods);
            if (!this.isLastTestMethodForClass(tm, this.m_allTestMethods) || this.m_invokedAfterClassMethods.containsKey(testClass)) continue;
            this.m_invoker.invokeConfigurations(testClass, testClass.getAfterClassMethods(), this.m_suite, this.m_parameters, null);
            this.m_invokedAfterClassMethods.put(testClass, testClass);
        }
    }

    private boolean isLastTestMethodForClass(ITestNGMethod tm, ITestNGMethod[] testMethods) {
        for (int i = testMethods.length - 1; i >= 0; --i) {
            ITestNGMethod thisMethod = testMethods[i];
            ITestClass testClass = tm.getTestClass();
            if (!thisMethod.getTestClass().equals(testClass)) continue;
            return thisMethod.equals(tm);
        }
        return false;
    }

    private void ppp(String s) {
        if (TestRunner.getVerbose() >= 2) {
            System.out.println("[TestMethodWorker " + ThreadUtil.currentThreadInfo() + "] " + s);
        }
    }

    public void setAllTestMethods(ITestNGMethod[] allTestMethods) {
        this.m_allTestMethods = allTestMethods;
    }
}

