/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.ISuite;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SuiteRunner;
import org.testng.TestClass;
import org.testng.internal.BaseClassFinder;
import org.testng.internal.ClassHelper;
import org.testng.internal.Constants;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MethodHelper;
import org.testng.internal.RunInfo;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.TestNGMethod;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.IPooledExecutor;
import org.testng.internal.thread.ThreadUtil;
import org.testng.junit.JUnitClassFinder;
import org.testng.junit.JUnitMethodFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner
implements ITestContext,
ITestResultNotifier {
    private static final long serialVersionUID = 4247820024988306670L;
    private ISuite m_suite;
    protected XmlTest m_xmlTest;
    private String m_testName;
    private transient List<XmlClass> m_testClassesFromXml = null;
    private transient List<XmlPackage> m_packageNamesFromXml = null;
    private transient IInvoker m_invoker = null;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient List<ITestListener> m_testListeners = new ArrayList<ITestListener>();
    private ITestNGMethod[] m_allTestMethods = new ITestNGMethod[0];
    private Date m_startDate = null;
    private Date m_endDate = null;
    private transient Map<Class, ITestClass> m_classMap = new HashMap<Class, ITestClass>();
    private String m_outputDirectory = Constants.getDefaultValueFor("testng.outputDir");
    private XmlMethodSelector m_xmlMethodSelector = new XmlMethodSelector();
    private static int m_verbose = 1;
    private ITestNGMethod[] m_beforeClassMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterClassMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeXmlTestMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterXmlTestMethods = new ITestNGMethod[0];
    private Map<String, List<String>> m_metaGroups = new HashMap<String, List<String>>();
    private Map<ITestNGMethod, ITestResult> m_passedTests = new HashMap<ITestNGMethod, ITestResult>();
    private Map<ITestNGMethod, ITestResult> m_failedTests = new HashMap<ITestNGMethod, ITestResult>();
    private Map<ITestNGMethod, ITestResult> m_failedButWithinSuccessPercentageTests = new HashMap<ITestNGMethod, ITestResult>();
    private Map<ITestNGMethod, ITestResult> m_skippedTests = new HashMap<ITestNGMethod, ITestResult>();
    private RunInfo m_runInfo = new RunInfo();
    private String m_host;
    private List<InvokedMethod> m_invokedMethods = new ArrayList<InvokedMethod>();

    public TestRunner(ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder finder) {
        this.init(suite, test, outputDirectory, finder);
    }

    public TestRunner(ISuite suite, XmlTest test, IAnnotationFinder finder) {
        this.init(suite, test, suite.getOutputDirectory(), finder);
    }

    public TestRunner(ISuite suite, XmlTest test) {
        this.init(suite, test, suite.getOutputDirectory(), SuiteRunner.getAnnotationFinder(test));
    }

    private void init(ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder annotationFinder) {
        this.m_xmlTest = test;
        this.m_suite = suite;
        this.m_testName = test.getName();
        this.m_testClassesFromXml = test.getXmlClasses();
        this.m_packageNamesFromXml = new ArrayList<XmlPackage>(test.getXmlPackages());
        this.m_packageNamesFromXml.addAll(test.getSuite().getXmlPackages());
        this.m_host = suite.getHost();
        if (null != this.m_packageNamesFromXml) {
            for (XmlPackage xp : this.m_packageNamesFromXml) {
                String pkg = xp.getName();
                try {
                    String[] classes;
                    for (String cls : classes = Utils.findClassesInPackage(pkg, xp.getInclude(), xp.getExclude())) {
                        XmlClass xc = new XmlClass(cls);
                        this.log("ADDING PACKAGE-FOUND CLASS " + xc);
                        this.m_testClassesFromXml.add(xc);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.m_annotationFinder = annotationFinder;
        this.m_invoker = new Invoker(this, this, this.m_annotationFinder);
        this.setVerbose(test.getVerbose());
        if (suite.isParallel()) {
            this.log(3, "Running the tests in parallel");
        }
        this.setOutputDirectory(outputDirectory);
        this.init();
    }

    public IInvoker getInvoker() {
        return this.m_invoker;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeXmlTestMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterXmlTestMethods;
    }

    private void init() {
        this.initMetaGroups(this.m_xmlTest);
        this.initRunInfo(this.m_xmlTest);
        this.initMethods();
    }

    private void initMetaGroups(XmlTest xmlTest) {
        Map<String, List<String>> metaGroups = xmlTest.getMetaGroups();
        for (String name : metaGroups.keySet()) {
            this.addMetaGroup(name, metaGroups.get(name));
        }
    }

    private void initRunInfo(XmlTest xmlTest) {
        this.m_xmlMethodSelector.setIncludedGroups(this.createGroups(this.m_xmlTest.getIncludedGroups()));
        this.m_xmlMethodSelector.setExcludedGroups(this.createGroups(this.m_xmlTest.getExcludedGroups()));
        this.m_xmlMethodSelector.setExpression(this.m_xmlTest.getExpression());
        this.m_xmlMethodSelector.setXmlClasses(this.m_xmlTest.getXmlClasses());
        this.m_runInfo.addMethodSelector(this.m_xmlMethodSelector, 10);
        if (null != xmlTest.getMethodSelectors()) {
            for (org.testng.xml.XmlMethodSelector selector : xmlTest.getMethodSelectors()) {
                if (selector.getClassName() == null) continue;
                IMethodSelector s = ClassHelper.createSelector(selector);
                this.m_runInfo.addMethodSelector(s, selector.getPriority());
            }
        }
    }

    private void initMethods() {
        IClass[] classes;
        ArrayList<ITestNGMethod> beforeClassMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> testMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> afterClassMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> beforeSuiteMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> afterSuiteMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> beforeXmlTestMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> afterXmlTestMethods = new ArrayList<ITestNGMethod>();
        ITestMethodFinder testMethodFinder = null;
        BaseClassFinder testClassFinder = null;
        if (this.m_xmlTest.isJUnit()) {
            testClassFinder = new JUnitClassFinder(Utils.xmlClassesToClasses(this.m_testClassesFromXml), this.m_xmlTest, this.m_annotationFinder);
            testMethodFinder = new JUnitMethodFinder(this.m_testName, this.m_annotationFinder);
        } else {
            testClassFinder = new TestNGClassFinder(Utils.xmlClassesToClasses(this.m_testClassesFromXml), null, this.m_xmlTest, this.m_annotationFinder);
            testMethodFinder = new TestNGMethodFinder(this.m_runInfo, this.m_annotationFinder);
        }
        for (IClass ic : classes = testClassFinder.findTestClasses()) {
            TestClass tc = new TestClass(ic, this.m_testName, testMethodFinder, this.m_annotationFinder, this.m_runInfo, this);
            this.m_classMap.put(ic.getRealClass(), tc);
        }
        for (ITestClass tc : this.m_classMap.values()) {
            this.fixMethodsWithClass(tc.getBeforeClassMethods(), tc, beforeClassMethods);
            this.fixMethodsWithClass(tc.getBeforeTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getTestMethods(), tc, testMethods);
            this.fixMethodsWithClass(tc.getAfterTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getAfterClassMethods(), tc, afterClassMethods);
            this.fixMethodsWithClass(tc.getBeforeSuiteMethods(), tc, beforeSuiteMethods);
            this.fixMethodsWithClass(tc.getAfterSuiteMethods(), tc, afterSuiteMethods);
            this.fixMethodsWithClass(tc.getBeforeTestConfigurationMethods(), tc, beforeXmlTestMethods);
            this.fixMethodsWithClass(tc.getAfterTestConfigurationMethods(), tc, afterXmlTestMethods);
        }
        this.m_runInfo.setTestMethods(testMethods);
        this.m_beforeSuiteMethods = MethodHelper.collectAndOrderMethods(beforeSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true);
        this.m_beforeXmlTestMethods = MethodHelper.collectAndOrderMethods(beforeXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder);
        this.m_beforeClassMethods = MethodHelper.collectAndOrderMethods(beforeClassMethods, false, this.m_runInfo, this.m_annotationFinder);
        this.m_allTestMethods = MethodHelper.collectAndOrderMethods(testMethods, true, this.m_runInfo, this.m_annotationFinder);
        this.m_afterClassMethods = MethodHelper.collectAndOrderMethods(afterClassMethods, false, this.m_runInfo, this.m_annotationFinder);
        this.m_afterXmlTestMethods = MethodHelper.collectAndOrderMethods(afterXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder);
        this.m_afterSuiteMethods = MethodHelper.collectAndOrderMethods(afterSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true);
    }

    private void fixMethodsWithClass(ITestNGMethod[] methods, ITestClass testCls, List<ITestNGMethod> methodList) {
        for (ITestNGMethod itm : methods) {
            itm.setTestClass(testCls);
            if (methodList == null) continue;
            methodList.add(itm);
        }
    }

    public Collection<ITestClass> getIClass() {
        return this.m_classMap.values();
    }

    private IClass findIClass(IClass[] classes, Class cls) {
        for (IClass c : classes) {
            if (!c.getRealClass().equals(cls)) continue;
            return c;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_testName;
    }

    @Override
    public String[] getIncludedGroups() {
        Map<String, String> ig = this.m_xmlMethodSelector.getIncludedGroups();
        String[] result = ig.values().toArray(new String[ig.size()]);
        return result;
    }

    @Override
    public String[] getExcludedGroups() {
        Map<String, String> eg = this.m_xmlMethodSelector.getExcludedGroups();
        String[] result = eg.values().toArray(new String[eg.size()]);
        return result;
    }

    public void setTestName(String name) {
        this.m_testName = name;
    }

    public void setOutputDirectory(String od) {
        File file = new File(od);
        file.mkdirs();
        this.m_outputDirectory = file.getAbsolutePath();
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    @Override
    public Date getEndDate() {
        return this.m_endDate;
    }

    @Override
    public Date getStartDate() {
        return this.m_startDate;
    }

    private void addMetaGroup(String name, List<String> groupNames) {
        this.m_metaGroups.put(name, groupNames);
    }

    private void collectGroups(String[] groups, List<String> unfinishedGroups, Map<String, String> result) {
        for (String gn : groups) {
            List<String> subGroups = this.m_metaGroups.get(gn);
            if (null == subGroups) continue;
            for (String sg : subGroups) {
                if (null != result.get(sg)) continue;
                result.put(sg, sg);
                unfinishedGroups.add(sg);
            }
        }
    }

    private Map<String, String> createGroups(List<String> groups) {
        return this.createGroups(groups.toArray(new String[groups.size()]));
    }

    private Map<String, String> createGroups(String[] groups) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String group : groups) {
            result.put(group, group);
        }
        ArrayList<String> unfinishedGroups = new ArrayList<String>();
        if (this.m_metaGroups.size() > 0) {
            this.collectGroups(groups, unfinishedGroups, result);
            while (unfinishedGroups.size() > 0) {
                String[] uGroups = unfinishedGroups.toArray(new String[unfinishedGroups.size()]);
                unfinishedGroups = new ArrayList();
                this.collectGroups(uGroups, unfinishedGroups, result);
            }
        }
        return result;
    }

    public ITestNGMethod[] collectAndOrderTestMethods(ITestNGMethod[] methods) {
        return MethodHelper.collectAndOrderMethods(methods, true, this.m_runInfo, this.m_annotationFinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.beforeRun();
        try {
            this.privateRun(this.getTest());
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        this.m_startDate = new Date(System.currentTimeMillis());
        this.logStart();
        this.fireEvent(true);
    }

    public void privateRun(XmlTest xmlTest) {
        Map params = xmlTest.getParameters();
        ArrayList<ITestNGMethod> sequentialList = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> parallelList = new ArrayList<ITestNGMethod>();
        this.computeTestLists(sequentialList, parallelList);
        this.log(3, "Found " + (sequentialList.size() + parallelList.size()) + " applicable methods");
        ArrayList<TestMethodWorker> workers = new ArrayList<TestMethodWorker>();
        HashMap<ITestClass, ITestClass> beforeClassMethods = new HashMap<ITestClass, ITestClass>();
        HashMap<ITestClass, ITestClass> afterClassMethods = new HashMap<ITestClass, ITestClass>();
        if (sequentialList.size() > 0) {
            workers.add(new TestMethodWorker(this.m_invoker, sequentialList.toArray(new ITestNGMethod[sequentialList.size()]), this.m_xmlTest.getSuite(), params, beforeClassMethods, afterClassMethods, this.m_allTestMethods));
        }
        if (parallelList.size() > 0) {
            for (ITestNGMethod tm : parallelList) {
                workers.add(new TestMethodWorker(this.m_invoker, new ITestNGMethod[]{tm}, this.m_xmlTest.getSuite(), params, beforeClassMethods, afterClassMethods, this.m_allTestMethods));
            }
        }
        if (xmlTest.isParallel()) {
            long maxTimeOut = 10000L;
            IPooledExecutor executor = ThreadUtil.createPooledExecutor(this.m_xmlTest.getSuite().getThreadCount());
            for (TestMethodWorker tmw : workers) {
                long mt = tmw.getMaxTimeOut();
                if (mt > maxTimeOut) {
                    maxTimeOut = mt;
                }
                executor.execute(tmw);
            }
            try {
                executor.shutdown();
                this.log("Waiting for termination, timeout:" + maxTimeOut);
                executor.awaitTermination(maxTimeOut);
                this.log("Successful termination");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (TestMethodWorker tmw : workers) {
                tmw.setAllTestMethods(this.m_allTestMethods);
                tmw.run();
            }
        }
    }

    private void afterRun() {
        this.m_endDate = new Date(System.currentTimeMillis());
        if (TestRunner.getVerbose() >= 3) {
            this.dumpInvokedMethods();
        }
        this.fireEvent(false);
    }

    private boolean containsString(Map<String, String> regexps, String group) {
        for (String regexp : regexps.values()) {
            boolean match = Pattern.matches(regexp, group);
            if (!match) continue;
            return true;
        }
        return false;
    }

    private void computeTestLists(List<ITestNGMethod> sequentialList, List<ITestNGMethod> parallelList) {
        HashMap<String, String> groupsDependedUpon = new HashMap<String, String>();
        HashMap<String, String> methodsDependedUpon = new HashMap<String, String>();
        for (int i = this.m_allTestMethods.length - 1; i >= 0; --i) {
            int i$;
            ITestNGMethod tm = this.m_allTestMethods[i];
            String[] currentGroups = tm.getGroups();
            String[] currentGroupsDependedUpon = tm.getGroupsDependedUpon();
            String[] currentMethodsDependedUpon = tm.getMethodsDependedUpon();
            String thisMethodName = tm.getMethod().getDeclaringClass().getName() + "." + tm.getMethod().getName();
            if (currentGroupsDependedUpon.length > 0) {
                String[] arr$ = currentGroupsDependedUpon;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String gdu = arr$[i$];
                    groupsDependedUpon.put(gdu, gdu);
                }
                sequentialList.add(0, tm);
                continue;
            }
            if (currentMethodsDependedUpon.length > 0) {
                String[] arr$ = currentMethodsDependedUpon;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String cmu = arr$[i$];
                    methodsDependedUpon.put(cmu, cmu);
                }
                sequentialList.add(0, tm);
                continue;
            }
            if (this.containsString(methodsDependedUpon, thisMethodName)) {
                sequentialList.add(0, tm);
                continue;
            }
            if (currentGroups.length > 0) {
                boolean isSequential = false;
                for (String group : currentGroups) {
                    if (!this.containsString(groupsDependedUpon, group)) continue;
                    sequentialList.add(0, tm);
                    isSequential = true;
                    break;
                }
                if (isSequential) continue;
                parallelList.add(0, tm);
                continue;
            }
            parallelList.add(0, tm);
        }
        Collections.sort(parallelList, TestNGMethod.SORT_BY_CLASS);
        if (TestRunner.getVerbose() >= 2) {
            this.log(3, "WILL BE RUN IN RANDOM ORDER:");
            for (ITestNGMethod tm : parallelList) {
                this.log(3, "  " + tm);
            }
            this.log(3, "WILL BE RUN SEQUENTIALLY:");
            for (ITestNGMethod tm : sequentialList) {
                this.log(3, "  " + tm);
            }
            this.log(3, "===");
        }
    }

    private void invokeClassConfigurations(ITestNGMethod[] classMethods, XmlTest xmlTest, boolean before) {
        for (ITestClass testClass : this.m_classMap.values()) {
            this.m_invoker.invokeConfigurations(testClass, classMethods, this.m_xmlTest.getSuite(), xmlTest.getParameters(), null);
            String msg = "Marking class " + testClass + " as " + (before ? "before" : "after") + "ConfigurationClass=true";
            this.log(3, msg);
        }
    }

    private void logStart() {
        this.log(3, "Running test " + this.m_testName + " on " + this.m_classMap.size() + " " + " classes, " + " included groups:[" + this.mapToString(this.m_xmlMethodSelector.getIncludedGroups()) + "] excluded groups:[" + this.mapToString(this.m_xmlMethodSelector.getExcludedGroups()) + "]");
        if (TestRunner.getVerbose() >= 3) {
            for (ITestClass tc : this.m_classMap.values()) {
                ((TestClass)tc).dump();
            }
        }
    }

    private void fireEvent(boolean isStart) {
        for (ITestListener itl : this.m_testListeners) {
            if (isStart) {
                itl.onStart(this);
                continue;
            }
            itl.onFinish(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPassedTest(ITestNGMethod tm, ITestResult tr) {
        Map<ITestNGMethod, ITestResult> map = this.m_passedTests;
        synchronized (map) {
            this.m_passedTests.put(tm, tr);
        }
    }

    @Override
    public ITestResult getPassedTest(ITestNGMethod tm) {
        return this.m_passedTests.get(tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSkippedTest(ITestNGMethod tm, ITestResult tr) {
        Map<ITestNGMethod, ITestResult> map = this.m_skippedTests;
        synchronized (map) {
            this.m_skippedTests.put(tm, tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInvokedMethod(InvokedMethod im) {
        List<InvokedMethod> list = this.m_invokedMethods;
        synchronized (list) {
            this.m_invokedMethods.add(im);
        }
    }

    @Override
    public void addFailedTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, false);
    }

    @Override
    public void addFailedButWithinSuccessPercentageTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, true);
    }

    @Override
    public XmlTest getTest() {
        return this.m_xmlTest;
    }

    @Override
    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    private IClass findTestClass(Class<?> declaringClass) {
        IClass result = this.m_classMap.get(declaringClass);
        if (null == result) {
            for (Class cls : this.m_classMap.keySet()) {
                if (!declaringClass.isAssignableFrom(cls)) continue;
                result = this.m_classMap.get(cls);
                assert (null != result) : "Should never happen";
            }
        }
        return result;
    }

    public ITestNGMethod[] getTestMethods() {
        return this.m_allTestMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logFailedTest(ITestNGMethod method, ITestResult tr, boolean withinSuccessPercentage) {
        if (withinSuccessPercentage) {
            Map<ITestNGMethod, ITestResult> map = this.m_failedButWithinSuccessPercentageTests;
            synchronized (map) {
                this.m_failedButWithinSuccessPercentageTests.put(method, tr);
            }
        }
        Map<ITestNGMethod, ITestResult> map = this.m_failedTests;
        synchronized (map) {
            this.m_failedTests.put(method, tr);
        }
    }

    private String mapToString(Map m) {
        StringBuffer result = new StringBuffer();
        for (Object o : m.values()) {
            result.append(o.toString()).append(" ");
        }
        return result.toString();
    }

    private void log(int level, String s) {
        Utils.log("TestRunner", level, s);
    }

    public static int getVerbose() {
        return m_verbose;
    }

    public void setVerbose(int n) {
        m_verbose = n;
    }

    private void log(String s) {
        Utils.log("TestRunner", 2, s);
    }

    @Override
    public Map<ITestNGMethod, ITestResult> getPassedTests() {
        return this.m_passedTests;
    }

    @Override
    public Map<ITestNGMethod, ITestResult> getSkippedTests() {
        return this.m_skippedTests;
    }

    public Map getFailedTests() {
        return this.m_failedTests;
    }

    public Map getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    public void addTestListener(ITestListener il) {
        this.m_testListeners.add(il);
    }

    @Override
    public ISuite getSuite() {
        return this.m_suite;
    }

    @Override
    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods;
    }

    private void dumpInvokedMethods() {
        System.out.println("\n*********** INVOKED METHODS\n");
        for (InvokedMethod im : this.m_invokedMethods) {
            if (im.isTestMethod()) {
                System.out.print("\t\t");
            } else {
                if (!im.isConfigurationMethod()) continue;
                System.out.print("\t");
            }
            System.out.println("" + im);
        }
        System.out.println("\n***********\n");
    }

    public List<ITestNGMethod> getInvokedMethods() {
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        for (InvokedMethod im : this.m_invokedMethods) {
            ITestNGMethod tm = im.getTestMethod();
            tm.setDate(im.getDate());
            result.add(tm);
        }
        return result;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }
}

