/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.viewer.MessageException;
import org.apache.fop.viewer.MessagesDialog;
import org.apache.fop.viewer.SecureResourceBundle;
import org.apache.fop.viewer.Translator;

public class UserMessage {
    private static Translator res = null;
    private static final int INFO = -1;
    private static final int WARNING = 2;
    private static final int QUESTION = 3;
    private static final int ERROR = 0;
    private static final int SYS_ERROR = 0;
    public static final int STYLE_NOBUTTON = -2;
    public static final int STYLE_Y = -1;
    public static final int STYLE_Y_N = 0;
    public static final int STYLE_Y_N_C = 1;
    private static final String PARAMETER_TAG = "&&&";
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    private static int buttonType = -1;
    private static int iconType = 2;
    private static String currentIconName = "";
    private static String actMessId = null;

    public static void setTranslator(Translator aRes) {
        res = aRes;
        if (res == null) {
            MessageHandler.logln("UserMessage: setTranslator(null) !");
            res = new SecureResourceBundle(null);
        }
        MessagesDialog.setTranslator(res);
    }

    static String prepareMessage(String rawText, String[] par) {
        MessageHandler.logln("prepareMessage(): " + rawText + ", parameter: " + par);
        int index = rawText.indexOf(PARAMETER_TAG);
        String composedMess = "";
        if (index == -1 && par == null) {
            return rawText;
        }
        if (index != -1 && par == null) {
            MessageHandler.logln("Message " + actMessId + " erwartet Parameter. Aufgerufen ohne Parameter");
            return rawText;
        }
        if (index == -1 && par != null) {
            MessageHandler.logln("Message " + actMessId + " erwartet keine Parameter. Aufgerufen mit folgenden Parametern:");
            for (int i = 0; i < par.length; ++i) {
                MessageHandler.logln(par[i].toString());
            }
            return rawText;
        }
        int tagCount = 0;
        while (rawText.indexOf(PARAMETER_TAG) != -1) {
            index = rawText.indexOf(PARAMETER_TAG);
            try {
                composedMess = composedMess + rawText.substring(0, index) + par[tagCount];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                MessageHandler.logln("Anzahl der \u9edaergebenen Parameter zu der Meldung " + actMessId + " ist weniger als erwartet.");
                ex.printStackTrace();
                return composedMess + rawText;
            }
            rawText = rawText.substring(index + PARAMETER_TAG.length());
            ++tagCount;
        }
        composedMess = composedMess + rawText;
        if (tagCount != par.length) {
            MessageHandler.logln("Die zu der Meldung " + actMessId + "  \u9edaergebenen Parameter sind mehr als die Meldung vorsieht.");
        }
        return composedMess;
    }

    static String getTitle(String strVal) {
        String title = null;
        int choice = UserMessage.getValue(strVal);
        switch (choice) {
            case -1: {
                title = "Info";
                currentIconName = "info.gif";
                break;
            }
            case 2: {
                title = "Warning";
                currentIconName = "warn.gif";
                break;
            }
            case 3: {
                title = "Question";
                currentIconName = "quest.gif";
                break;
            }
            case 0: {
                title = "Error";
                currentIconName = "error.gif";
                break;
            }
            default: {
                title = "Ung\u9eeetiger IonType f\u9ef5 diese Meldung. Pr\u9ee4en in \u8ea1ersetzungsdatei.";
            }
        }
        return title;
    }

    static int getValue(String fieldName) {
        int val = -1;
        if (fieldName.equals("INFO")) {
            return -1;
        }
        if (fieldName.equals("WARNING")) {
            return 2;
        }
        if (fieldName.equals("ERROR")) {
            return 0;
        }
        if (fieldName.equals("SYS_ERROR")) {
            return 0;
        }
        if (fieldName.equals("QUESTION")) {
            return 3;
        }
        if (fieldName.equals("STYLE_NOBUTTON")) {
            return -2;
        }
        if (fieldName.equals("STYLE_Y")) {
            return -1;
        }
        if (fieldName.equals("STYLE_Y_N")) {
            return 0;
        }
        if (fieldName.equals("STYLE_Y_N_C")) {
            return 1;
        }
        return val;
    }

    private static String getStackTrace(Exception exception) {
        if (exception == null) {
            return "null";
        }
        String stack = "";
        StringWriter strWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(strWriter));
        stack = strWriter.toString();
        stack = stack.replace('\r', ' ');
        stack = stack.replace('\t', ' ');
        return stack;
    }

    private static int display(String textID, String[] param, Exception exception, Frame frame) {
        String translatedMes = "";
        String preparedMes = "";
        String messageType = "";
        String optionType = "";
        String title = "";
        Object dialog = null;
        actMessId = textID;
        boolean messageFound = res.contains(textID);
        translatedMes = res.getString(textID);
        if (messageFound) {
            try {
                messageType = translatedMes.substring(0, translatedMes.indexOf(58));
                translatedMes = translatedMes.substring(translatedMes.indexOf(58) + 1);
                optionType = translatedMes.substring(0, translatedMes.indexOf(58));
                translatedMes = translatedMes.substring(translatedMes.indexOf(58) + 1);
            }
            catch (Exception ex) {
                MessageHandler.logln("FALSCHES FORMAT: MESSAGE: " + textID);
            }
        } else {
            MessageHandler.logln("UserMessage: textID '" + textID + "' not found. Return " + "value 'CANCEL' = " + 2);
            messageType = "ERROR";
            optionType = "STYLE_Y";
            translatedMes = "textID '" + textID + "' not found." + "\nIt is possible the message file not found.";
        }
        preparedMes = UserMessage.prepareMessage(translatedMes, param);
        title = res.getString(UserMessage.getTitle(messageType));
        int messageTypeIndex = UserMessage.getValue(messageType);
        int optionTypeIndex = UserMessage.getValue(optionType);
        int result = 2;
        if (exception != null) {
            MessageException ex;
            String str = UserMessage.getStackTrace(exception);
            if (exception instanceof MessageException && (ex = (MessageException)exception).getException() != null) {
                str = str + "\n" + UserMessage.getStackTrace(ex.getException());
            }
            result = MessagesDialog.showDetailDialog(null, preparedMes, title, optionTypeIndex, messageTypeIndex, null, str);
        } else {
            if (optionTypeIndex == -2) {
                MessageHandler.logln("UserMessage: STYLE_NOBUTTON wird nicht unterst\u9ef7zt");
                return result;
            }
            result = MessagesDialog.showConfirmDialog(null, preparedMes, title, optionTypeIndex, messageTypeIndex);
        }
        return result;
    }

    public static int show(String messageId, String[] parameterList, Exception anException, Frame parentFrame) {
        return UserMessage.display(messageId, parameterList, anException, parentFrame);
    }

    public static int show(String messageId, String[] parameterList, Exception anException) {
        return UserMessage.display(messageId, parameterList, anException, null);
    }

    public static int show(String messageId, String[] parameterList, Frame parentFrame) {
        return UserMessage.display(messageId, parameterList, null, parentFrame);
    }

    public static int show(String messageId, String[] parameterList) {
        return UserMessage.display(messageId, parameterList, null, null);
    }

    public static int show(String messageId, String parameter, Frame parentFrame) {
        return UserMessage.display(messageId, new String[]{parameter}, null, parentFrame);
    }

    public static int show(String messageId, String parameter) {
        return UserMessage.display(messageId, new String[]{parameter}, null, null);
    }

    public static int show(String messageId, Frame parentFrame) {
        return UserMessage.display(messageId, null, null, parentFrame);
    }

    public static int show(String messageId) {
        return UserMessage.display(messageId, null, null, null);
    }

    public static int show(String messageId, Exception anException, Frame aFrame) {
        return UserMessage.display(messageId, null, anException, aFrame);
    }

    public static int show(String messageId, Exception anException) {
        return UserMessage.display(messageId, null, anException, null);
    }

    public static int show(Exception anException, Frame aFrame) {
        if (anException instanceof MessageException) {
            MessageException ex = (MessageException)anException;
            return UserMessage.show(ex.getMessageId(), ex.getParameterList(), ex, aFrame);
        }
        return UserMessage.show("UNHANDLED_EXCEPTION", null, anException, aFrame);
    }
}

