/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class GIFReader
extends AbstractImageReader {
    protected static final int GIF_SIG_LENGTH = 10;
    protected byte[] header;

    public boolean verifySignature(String uri, BufferedInputStream fis) throws IOException {
        boolean supported;
        this.imageStream = fis;
        this.setDefaultHeader();
        boolean bl = supported = this.header[0] == 71 && this.header[1] == 73 && this.header[2] == 70 && this.header[3] == 56 && (this.header[4] == 55 || this.header[4] == 57) && this.header[5] == 97;
        if (supported) {
            this.setDimension();
            return true;
        }
        return false;
    }

    public String getMimeType() {
        return "image/gif";
    }

    protected void setDimension() {
        int byte1 = this.header[6] & 0xFF;
        int byte2 = this.header[7] & 0xFF;
        this.width = (byte2 << 8 | byte1) & 0xFFFF;
        byte1 = this.header[8] & 0xFF;
        byte2 = this.header[9] & 0xFF;
        this.height = (byte2 << 8 | byte1) & 0xFFFF;
    }

    protected void setDefaultHeader() throws IOException {
        this.header = new byte[10];
        try {
            this.imageStream.mark(11);
            this.imageStream.read(this.header);
            this.imageStream.reset();
        }
        catch (IOException ex) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }
}

