/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;

public class Character
extends FObj {
    public static final int OK = 0;
    public static final int DOESNOT_FIT = 1;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public Character(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:character";
    }

    public int layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            this.log.warn("currently Character can only be in a BlockArea");
            return 1;
        }
        BlockArea blockArea = (BlockArea)area;
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        HyphenationProps mHyphProps = this.propMgr.getHyphenationProps();
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        ColorType c = this.properties.get("color").getColorType();
        float red = c.red();
        float green = c.green();
        float blue = c.blue();
        int whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
        int wrapOption = this.parent.properties.get("wrap-option").getEnum();
        int tmp = this.properties.get("text-decoration").getEnum();
        boolean textDecoration = tmp == 121;
        char characterValue = this.properties.get("character").getCharacter();
        String id = this.properties.get("id").getString();
        try {
            blockArea.getIDReferences().initializeID(id, blockArea);
        }
        catch (FOPException e) {
            if (!e.isLocationSet()) {
                e.setLocation(this.systemId, this.line, this.column);
            }
            throw e;
        }
        LineArea la = blockArea.getCurrentLineArea();
        if (la == null) {
            return 2;
        }
        la.changeFont(this.propMgr.getFontState(area.getFontInfo()));
        la.changeColor(red, green, blue);
        la.changeWrapOption(wrapOption);
        la.changeWhiteSpaceCollapse(whiteSpaceCollapse);
        blockArea.setupLinkSet(this.getLinkSet());
        int result = la.addCharacter(characterValue, this.getLinkSet(), textDecoration);
        if (result == 1) {
            la = blockArea.createNextLineArea();
            if (la == null) {
                return 2;
            }
            la.changeFont(this.propMgr.getFontState(area.getFontInfo()));
            la.changeColor(red, green, blue);
            la.changeWrapOption(wrapOption);
            la.changeWhiteSpaceCollapse(whiteSpaceCollapse);
            blockArea.setupLinkSet(this.getLinkSet());
            la.addCharacter(characterValue, this.getLinkSet(), textDecoration);
        }
        return 1;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new Character(parent, propertyList, systemId, line, column);
        }
    }
}

