/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.xml.sax.SAXException;

public class FOPException
extends Exception {
    private static final String EXCEPTION_SEPARATOR = "\n---------\n";
    private Throwable _exception;
    private String systemId;
    private int line;
    private int column;

    public FOPException(String message) {
        super(message);
        this.systemId = null;
        this.line = -1;
        this.column = -1;
    }

    public FOPException(String message, String systemId, int line, int column) {
        super(message);
        this.systemId = systemId;
        this.line = line;
        this.column = column;
    }

    public FOPException(Throwable e) {
        super(e.getMessage());
        this.setException(e);
        this.systemId = null;
        this.line = -1;
        this.column = -1;
    }

    public FOPException(Throwable e, String systemId, int line, int column) {
        super(e.getMessage());
        this.setException(e);
        this.systemId = systemId;
        this.line = line;
        this.column = column;
    }

    public FOPException(String message, Throwable e) {
        super(message);
        this.setException(e);
        this.systemId = null;
        this.line = -1;
        this.column = -1;
    }

    public FOPException(String message, Throwable e, String systemId, int line, int column) {
        super(message);
        this.setException(e);
        this.systemId = systemId;
        this.line = line;
        this.column = column;
    }

    protected void setException(Throwable t) {
        this._exception = t;
    }

    public Throwable getException() {
        return this._exception;
    }

    public void setLocation(String systemId, int line, int column) {
        this.systemId = systemId;
        this.line = line;
        this.column = column;
    }

    public boolean isLocationSet() {
        return this.line >= 0;
    }

    protected Throwable getRootException() {
        Throwable result = this._exception;
        if (result instanceof SAXException) {
            result = ((SAXException)result).getException();
        }
        if (result instanceof InvocationTargetException) {
            result = ((InvocationTargetException)result).getTargetException();
        }
        if (result != this._exception) {
            return result;
        }
        return null;
    }

    public String getMessage() {
        if (this.line >= 0) {
            return this.systemId + ':' + this.line + ':' + this.column + ' ' + super.getMessage();
        }
        return super.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace();
            if (this._exception != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this._exception.printStackTrace();
            }
            if (this.getRootException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            super.printStackTrace(stream);
            if (this._exception != null) {
                stream.println(EXCEPTION_SEPARATOR);
                this._exception.printStackTrace(stream);
            }
            if (this.getRootException() != null) {
                stream.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter writer) {
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            super.printStackTrace(writer);
            if (this._exception != null) {
                writer.println(EXCEPTION_SEPARATOR);
                this._exception.printStackTrace(writer);
            }
            if (this.getRootException() != null) {
                writer.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(writer);
            }
        }
    }
}

