/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import org.apache.cactus.AbstractTestCase;
import org.apache.cactus.WebTestResult;
import org.apache.cactus.server.ServletUtil;
import org.apache.cactus.server.WebImplicitObjects;
import org.apache.cactus.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractWebTestCaller {
    protected static final String TEST_RESULTS = "ServletTestRedirector_TestResults";
    private static Log LOGGER = LogFactory.getLog((Class)(class$org$apache$cactus$server$AbstractWebTestCaller == null ? (class$org$apache$cactus$server$AbstractWebTestCaller = AbstractWebTestCaller.class$("org.apache.cactus.server.AbstractWebTestCaller")) : class$org$apache$cactus$server$AbstractWebTestCaller));
    protected WebImplicitObjects webImplicitObjects;
    static Class class$java$lang$String;
    static Class class$org$apache$cactus$server$AbstractWebTestCaller;

    public AbstractWebTestCaller(WebImplicitObjects theObjects) {
        this.webImplicitObjects = theObjects;
    }

    protected abstract void setTestCaseFields(AbstractTestCase var1) throws Exception;

    protected abstract Writer getResponseWriter() throws IOException;

    public void doTest() throws ServletException {
        WebTestResult result = null;
        try {
            AbstractTestCase testInstance = this.getTestClassInstance(this.getTestClassName(), this.getTestMethodName());
            this.setTestCaseFields(testInstance);
            testInstance.runBareServerTest();
            result = new WebTestResult();
        }
        catch (Throwable e) {
            result = new WebTestResult(e);
        }
        LOGGER.debug((Object)("Test result : [" + result + "]"));
        this.webImplicitObjects.getServletContext().setAttribute(TEST_RESULTS, (Object)result);
        LOGGER.debug((Object)"Result saved in context scope");
    }

    public void doGetResults() throws ServletException {
        WebTestResult result = (WebTestResult)this.webImplicitObjects.getServletContext().getAttribute(TEST_RESULTS);
        LOGGER.debug((Object)("Test Result = [" + result + "]"));
        try {
            Writer writer = this.getResponseWriter();
            writer.write(result.toXml());
            writer.close();
        }
        catch (IOException e) {
            String message = "Error writing WebTestResult instance to output stream";
            LOGGER.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
    }

    public void doRunTest() throws ServletException {
    }

    protected String getTestClassName() throws ServletException {
        String queryString = this.webImplicitObjects.getHttpServletRequest().getQueryString();
        String className = ServletUtil.getQueryStringParameter(queryString, "Cactus_TestClass");
        if (className == null) {
            String message = "Missing class name parameter [Cactus_TestClass] in HTTP request.";
            LOGGER.error((Object)message);
            throw new ServletException(message);
        }
        LOGGER.debug((Object)("Class to call = " + className));
        return className;
    }

    protected String getTestMethodName() throws ServletException {
        String queryString = this.webImplicitObjects.getHttpServletRequest().getQueryString();
        String methodName = ServletUtil.getQueryStringParameter(queryString, "Cactus_TestMethod");
        if (methodName == null) {
            String message = "Missing method name parameter [Cactus_TestMethod] in HTTP request.";
            LOGGER.error((Object)message);
            throw new ServletException(message);
        }
        LOGGER.debug((Object)("Method to call = " + methodName));
        return methodName;
    }

    protected boolean isAutoSession() {
        String queryString = this.webImplicitObjects.getHttpServletRequest().getQueryString();
        String autoSession = ServletUtil.getQueryStringParameter(queryString, "Cactus_AutomaticSession");
        boolean isAutomaticSession = Boolean.valueOf(autoSession);
        LOGGER.debug((Object)("Auto session is " + isAutomaticSession));
        return isAutomaticSession;
    }

    protected AbstractTestCase getTestClassInstance(String theClassName, String theTestCaseName) throws ServletException {
        Class testClass = this.getTestClassClass(theClassName);
        AbstractTestCase testInstance = null;
        try {
            Constructor constructor = testClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = AbstractWebTestCaller.class$("java.lang.String")) : class$java$lang$String);
            testInstance = (AbstractTestCase)((Object)constructor.newInstance(theTestCaseName));
        }
        catch (Exception e) {
            String message = "Error instantiating class [" + theClassName + "(" + theTestCaseName + ")]";
            LOGGER.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        return testInstance;
    }

    protected Class getTestClassClass(String theClassName) throws ServletException {
        Class testClass = null;
        try {
            testClass = ClassLoaderUtils.loadClass(theClassName, this.getClass());
        }
        catch (Exception e) {
            String message = "Error finding class [" + theClassName + "] using both the Context classloader and the webapp " + "classloader. Possible causes include:\r\n";
            message = message + "\t- Your webapp does not include your test classes,\r\n";
            message = message + "\t- The cactus.jar is not located in your WEB-INF/lib directory and your Container has not set the Context classloader to point to the webapp one";
            LOGGER.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        return testClass;
    }

    static Class class$(String name$) throws NoClassDefFoundError {
        try {
            return Class.forName(name$);
        }
        catch (ClassNotFoundException exn$) {
            throw new NoClassDefFoundError(exn$.getMessage());
        }
    }
}

