/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.client.authentication;

import java.text.StringCharacterIterator;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.authentication.AbstractAuthentication;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class BasicAuthentication
extends AbstractAuthentication {
    static Factory ajc$JPF = new Factory("BasicAuthentication.java", class$org$apache$cactus$client$authentication$BasicAuthentication == null ? (class$org$apache$cactus$client$authentication$BasicAuthentication = BasicAuthentication.class$("org.apache.cactus.client.authentication.BasicAuthentication")) : class$org$apache$cactus$client$authentication$BasicAuthentication);
    private static JoinPoint.StaticPart configure$ajcjp1 = ajc$JPF.makeSJP("method-execution", (Signature)ajc$JPF.makeMethodSig("1-configure-org.apache.cactus.client.authentication.BasicAuthentication-org.apache.cactus.WebRequest:-theRequest:--void-"), 208, 5);
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];
    static Class class$org$apache$cactus$client$authentication$BasicAuthentication;

    public BasicAuthentication(String theName, String thePassword) {
        super(theName, thePassword);
    }

    protected void validateName(String theName) {
        if (theName == null) {
            return;
        }
        String illegalChars = "()<>@,;:\\\"/[]?={} \t";
        StringCharacterIterator iter = new StringCharacterIterator(theName);
        char c = iter.first();
        while (c != '\uffff') {
            if (illegalChars.indexOf(c) != -1 || c >= '\u0000' && c <= '\u001f' || c == '\u007f') {
                throw new IllegalArgumentException("Given theName contains illegal characters.");
            }
            c = iter.next();
        }
    }

    protected void validatePassword(String thePassword) {
        if (thePassword == null) {
            return;
        }
        String exceptionChars = "\r\n \t";
        StringCharacterIterator iter = new StringCharacterIterator(thePassword);
        char c = iter.first();
        while (c != '\uffff') {
            if ((c >= '\u0000' && c <= '\u001f' || c == '\u007f') && exceptionChars.indexOf(c) == -1) {
                throw new IllegalArgumentException("Given thePassword contains illegal characters.");
            }
            c = iter.next();
        }
    }

    public void configure(WebRequest theRequest) {
        JoinPoint thisJoinPoint = Factory.makeJP((JoinPoint.StaticPart)configure$ajcjp1, (Object)this, (Object)this, (Object[])new Object[]{theRequest});
        this.around8_configure(null, thisJoinPoint, LogAspect.aspectInstance, theRequest);
    }

    private static char[] base64Encode(byte[] theData) {
        char[] out = new char[(theData.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < theData.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & theData[i];
            val <<= 8;
            if (i + 1 < theData.length) {
                val |= 0xFF & theData[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < theData.length) {
                val |= 0xFF & theData[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    final Object dispatch8_configure(WebRequest theRequest) {
        String basicCookie = this.getName() + ":" + this.getPassword();
        String basicCredentials = "Basic " + new String(BasicAuthentication.base64Encode(basicCookie.getBytes()));
        theRequest.addHeader("Authorization", basicCredentials);
        return null;
    }

    public final Object around8_configure(AroundClosure ajc$closure, JoinPoint thisJoinPoint, LogAspect this_, WebRequest theRequest) throws LogConfigurationException {
        Class<?> target = thisJoinPoint.getTarget().getClass();
        Log logger = LogFactory.getLog(target);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)('<' + this_.getFullSignature$ajc$backdoor(thisJoinPoint)));
            Object result = this.dispatch8_configure(theRequest);
            logger.debug((Object)('>' + thisJoinPoint.getSignature().getName()));
            return result;
        }
        return this.dispatch8_configure(theRequest);
    }

    static {
        int i = 0;
        while (i < 256) {
            BasicAuthentication.codes[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            BasicAuthentication.codes[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            BasicAuthentication.codes[i] = (byte)(26 + i - 97);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            BasicAuthentication.codes[i] = (byte)(52 + i - 48);
            ++i;
        }
        BasicAuthentication.codes[43] = 62;
        BasicAuthentication.codes[47] = 63;
    }

    static Class class$(String name$) throws NoClassDefFoundError {
        try {
            return Class.forName(name$);
        }
        catch (ClassNotFoundException exn$) {
            throw new NoClassDefFoundError(exn$.getMessage());
        }
    }
}

