/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.cactus.Request;
import org.apache.cactus.util.JUnitVersionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTestCase
extends TestCase {
    protected static final String TEST_METHOD_PREFIX = "test";
    protected static final String BEGIN_METHOD_PREFIX = "begin";
    protected static final String END_METHOD_PREFIX = "end";
    public static final String LOG_CLIENT_CONFIG = "log_client.properties";
    private String currentTestMethod;
    private Log logger;
    static Class class$org$apache$cactus$WebRequest;

    public AbstractTestCase(String theName) {
        super(theName);
        this.setCurrentTestMethod(JUnitVersionHelper.getTestCaseName((Test)this));
    }

    protected final Log getLogger() {
        return this.logger;
    }

    private String getBaseMethodName() {
        if (!this.getCurrentTestMethod().startsWith(TEST_METHOD_PREFIX)) {
            throw new RuntimeException("bad name [" + this.getCurrentTestMethod() + "]. It should start with [" + TEST_METHOD_PREFIX + "].");
        }
        return this.getCurrentTestMethod().substring(TEST_METHOD_PREFIX.length());
    }

    protected String getBeginMethodName() {
        return BEGIN_METHOD_PREFIX + this.getBaseMethodName();
    }

    protected String getEndMethodName() {
        return END_METHOD_PREFIX + this.getBaseMethodName();
    }

    public void runBare() throws Throwable {
        this.logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        this.getLogger().debug((Object)("------------- Test: " + this.getCurrentTestMethod()));
        try {
            this.runTest();
        }
        catch (Throwable t) {
            this.logger.debug((Object)"Exception in test", t);
            throw t;
        }
    }

    protected abstract void runTest() throws Throwable;

    public void runBareServerTest() throws Throwable {
        if (this.getLogger() == null) {
            this.logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        }
        this.setUp();
        try {
            this.runServerTest();
        }
        finally {
            Object var3_1 = null;
            this.tearDown();
        }
    }

    protected void callBeginMethod(Request theRequest) throws Throwable {
        Method[] methods = ((Object)((Object)this)).getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(this.getBeginMethodName())) {
                Class<?>[] parameters;
                if (!methods[i].getReturnType().getName().equals("void")) {
                    AbstractTestCase.fail((String)("The begin method [" + methods[i].getName() + "] should return void and not [" + methods[i].getReturnType().getName() + "]"));
                }
                if (!Modifier.isPublic(methods[i].getModifiers())) {
                    AbstractTestCase.fail((String)("Method [" + methods[i].getName() + "] should be declared public"));
                }
                if ((parameters = methods[i].getParameterTypes()).length != 1) {
                    AbstractTestCase.fail((String)("The begin method [" + methods[i].getName() + "] must accept a single parameter derived from " + "class [" + (class$org$apache$cactus$WebRequest == null ? (class$org$apache$cactus$WebRequest = AbstractTestCase.class$("org.apache.cactus.WebRequest")) : class$org$apache$cactus$WebRequest).getName() + "], " + "but " + parameters.length + " parameters were found"));
                } else if (!theRequest.getClass().isAssignableFrom(parameters[0])) {
                    AbstractTestCase.fail((String)("The begin method [" + methods[i].getName() + "] must accept a single parameter derived from " + "class [" + theRequest.getClass().getName() + "], " + "but found a [" + parameters[0].getName() + "] " + "parameter instead"));
                }
                try {
                    methods[i].invoke((Object)this, theRequest);
                    break;
                }
                catch (InvocationTargetException e) {
                    e.fillInStackTrace();
                    throw e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    e.fillInStackTrace();
                    throw e;
                }
            }
            ++i;
        }
    }

    protected void runServerTest() throws Throwable {
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(this.getCurrentTestMethod(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            AbstractTestCase.fail((String)("Method [" + this.getCurrentTestMethod() + "()] does not exist for class [" + ((Object)((Object)this)).getClass().getName() + "]."));
        }
        if (runMethod != null && !Modifier.isPublic(runMethod.getModifiers())) {
            AbstractTestCase.fail((String)("Method [" + this.getCurrentTestMethod() + "()] should be public"));
        }
        try {
            runMethod.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    protected String getCurrentTestMethod() {
        return this.currentTestMethod;
    }

    private void setCurrentTestMethod(String theCurrentTestMethod) {
        this.currentTestMethod = theCurrentTestMethod;
    }

    static Class class$(String name$) throws NoClassDefFoundError {
        try {
            return Class.forName(name$);
        }
        catch (ClassNotFoundException exn$) {
            throw new NoClassDefFoundError(exn$.getMessage());
        }
    }
}

