/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import com.sun.medialib.mlib.mediaLibImageColormap;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;

final class MlibOrderedDitherOpImage
extends PointOpImage {
    private static final int DMASK_SCALE_EXPONENT = 16;
    protected mediaLibImageColormap mlibColormap;
    protected int[][] dmask;
    protected int dmaskWidth;
    protected int dmaskHeight;
    protected int dmaskScale;

    static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, ColorCube colorCube) {
        ColorModel colorModel;
        Object object;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getNumBands();
        if (n != 1) {
            int n2 = imageLayout2.getSampleModel(renderedImage).getTransferType();
            SampleModel sampleModel2 = RasterFactory.createComponentSampleModel(sampleModel, n2, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel2);
            object = imageLayout2.getColorModel(null);
            if (object != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel2, (ColorModel)object)) {
                imageLayout2.unsetValid(512);
            }
        }
        if ((imageLayout == null || !imageLayout2.isValid(512)) && renderedImage.getSampleModel().getDataType() == 0 && imageLayout2.getSampleModel(null).getDataType() == 0 && colorCube.getDataType() == 0 && colorCube.getNumBands() == 3 && ((colorModel = renderedImage.getColorModel()) == null || colorModel != null && colorModel.getColorSpace().isCS_sRGB())) {
            int n3 = colorCube.getNumEntries();
            object = new byte[3][256];
            int n4 = 0;
            while (n4 < 3) {
                Object object2 = object[n4];
                byte[] byArray = colorCube.getByteData(n4);
                int n5 = colorCube.getOffset(n4);
                int n6 = n5 + n3;
                int n7 = 0;
                while (n7 < n5) {
                    object2[n7] = false;
                    ++n7;
                }
                int n8 = n5;
                while (n8 < n6) {
                    object2[n8] = byArray[n8 - n5];
                    ++n8;
                }
                int n9 = n6;
                while (n9 < 256) {
                    object2[n9] = -1;
                    ++n9;
                }
                ++n4;
            }
            imageLayout2.setColorModel(new IndexColorModel(8, 256, (byte[])object[0], (byte[])object[1], (byte[])object[2]));
        }
        return imageLayout2;
    }

    public MlibOrderedDitherOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, ColorCube colorCube, KernelJAI[] kernelJAIArray) {
        super(renderedImage, MlibOrderedDitherOpImage.layoutHelper(imageLayout, renderedImage, colorCube), map, true);
        this.mlibColormap = Image.ColorDitherInit((int[])colorCube.getDimension(), (int)1, (int)(ImageUtil.isBinary(this.sampleModel) ? 0 : 1), (int)colorCube.getNumBands(), (int)colorCube.getNumEntries(), (int)colorCube.getOffset(), (Object)colorCube.getByteData());
        this.dmaskWidth = kernelJAIArray[0].getWidth();
        this.dmaskHeight = kernelJAIArray[0].getHeight();
        this.dmaskScale = 65536;
        int n = kernelJAIArray.length;
        this.dmask = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            KernelJAI kernelJAI = kernelJAIArray[n2];
            if (kernelJAI.getWidth() != this.dmaskWidth || kernelJAI.getHeight() != this.dmaskHeight) {
                throw new IllegalArgumentException();
            }
            float[] fArray = kernelJAIArray[n2].getKernelData();
            int n3 = fArray.length;
            this.dmask[n2] = new int[n3];
            int[] nArray = this.dmask[n2];
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = (int)(fArray[n4] * (float)this.dmaskScale);
                ++n4;
            }
            ++n2;
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(rasterArray[0], rectangle, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        Image.ColorOrderedDitherMxN((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0], (int[][])this.dmask, (int)this.dmaskWidth, (int)this.dmaskHeight, (int)16, (mediaLibImageColormap)this.mlibColormap);
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

