/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model;

import com.sun.istack.NotNull;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.api.TypeReference;
import com.sun.xml.ws.api.model.ParameterBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.model.CheckedExceptionImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.model.ParameterImpl;
import com.sun.xml.ws.model.WrapperParameter;
import com.sun.xml.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.ws.model.wsdl.WSDLPartImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.resources.ModelerMessages;
import com.sun.xml.ws.util.Pool;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSEIModelImpl
implements SEIModel {
    private List<Class> additionalClasses = new ArrayList<Class>();
    private Pool.Marshaller marshallers;
    protected JAXBRIContext jaxbContext;
    private String wsdlLocation;
    private QName serviceName;
    private QName portName;
    private QName portTypeName;
    private Map<Method, JavaMethodImpl> methodToJM = new HashMap<Method, JavaMethodImpl>();
    private Map<QName, JavaMethodImpl> nameToJM = new HashMap<QName, JavaMethodImpl>();
    private List<JavaMethodImpl> javaMethods = new ArrayList<JavaMethodImpl>();
    private final Map<TypeReference, Bridge> bridgeMap = new HashMap<TypeReference, Bridge>();
    protected final QName emptyBodyName = new QName("");
    private String targetNamespace = "";
    private List<String> knownNamespaceURIs = null;
    private WSDLPortImpl port;

    void postProcess() {
        if (this.jaxbContext != null) {
            return;
        }
        this.populateMaps();
        this.createJAXBContext();
    }

    public void freeze(WSDLPortImpl port) {
        this.port = port;
        for (JavaMethodImpl m : this.javaMethods) {
            m.freeze(port);
        }
    }

    protected abstract void populateMaps();

    @Override
    public Pool.Marshaller getMarshallerPool() {
        return this.marshallers;
    }

    @Override
    public JAXBRIContext getJAXBContext() {
        return this.jaxbContext;
    }

    public List<String> getKnownNamespaceURIs() {
        return this.knownNamespaceURIs;
    }

    public final Bridge getBridge(TypeReference type) {
        Bridge b = this.bridgeMap.get(type);
        assert (b != null);
        return b;
    }

    private JAXBRIContext createJAXBContext() {
        final List<TypeReference> types = this.getAllTypeReferences();
        final Class[] cls = new Class[types.size() + this.additionalClasses.size()];
        int i = 0;
        for (Class additionalClass : this.additionalClasses) {
            cls[i++] = additionalClass;
        }
        for (TypeReference type : types) {
            cls[i++] = (Class)type.type;
        }
        try {
            this.jaxbContext = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBRIContext>(){

                @Override
                public JAXBRIContext run() throws Exception {
                    return JAXBRIContext.newInstance((Class[])cls, (Collection)types, null, (String)AbstractSEIModelImpl.this.targetNamespace, (boolean)false, null);
                }
            });
            this.createBridgeMap(types);
        }
        catch (PrivilegedActionException e) {
            throw new WebServiceException(ModelerMessages.UNABLE_TO_CREATE_JAXB_CONTEXT(), e);
        }
        this.knownNamespaceURIs = new ArrayList<String>();
        for (String namespace : this.jaxbContext.getKnownNamespaceURIs()) {
            if (namespace.length() <= 0 || namespace.equals("http://www.w3.org/2001/XMLSchema") || namespace.equals("http://www.w3.org/XML/1998/namespace")) continue;
            this.knownNamespaceURIs.add(namespace);
        }
        this.marshallers = new Pool.Marshaller((JAXBContext)this.jaxbContext);
        return this.jaxbContext;
    }

    private List<TypeReference> getAllTypeReferences() {
        ArrayList<TypeReference> types = new ArrayList<TypeReference>();
        Collection<JavaMethodImpl> methods = this.methodToJM.values();
        for (JavaMethodImpl m : methods) {
            m.fillTypes(types);
        }
        return types;
    }

    private void createBridgeMap(List<TypeReference> types) {
        for (TypeReference type : types) {
            Bridge bridge = this.jaxbContext.createBridge(type);
            this.bridgeMap.put(type, bridge);
        }
    }

    public Method getDispatchMethod(QName qname) {
        JavaMethodImpl jm;
        if (qname == null) {
            qname = this.emptyBodyName;
        }
        if ((jm = this.getJavaMethod(qname)) != null) {
            return jm.getMethod();
        }
        return null;
    }

    public boolean isKnownFault(QName name, Method method) {
        JavaMethodImpl m = this.getJavaMethod(method);
        for (CheckedExceptionImpl ce : m.getCheckedExceptions()) {
            if (!ce.getDetailType().tagName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckedException(Method m, Class ex) {
        JavaMethodImpl jm = this.getJavaMethod(m);
        for (CheckedExceptionImpl ce : jm.getCheckedExceptions()) {
            if (!ce.getExceptionClass().equals(ex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JavaMethodImpl getJavaMethod(Method method) {
        return this.methodToJM.get(method);
    }

    @Override
    public JavaMethodImpl getJavaMethod(QName name) {
        return this.nameToJM.get(name);
    }

    public QName getQNameForJM(JavaMethodImpl jm) {
        for (QName key : this.nameToJM.keySet()) {
            JavaMethodImpl jmethod = this.nameToJM.get(key);
            if (!jmethod.getOperationName().equals(jm.getOperationName())) continue;
            return key;
        }
        return null;
    }

    public final Collection<JavaMethodImpl> getJavaMethods() {
        return Collections.unmodifiableList(this.javaMethods);
    }

    void addJavaMethod(JavaMethodImpl jm) {
        if (jm != null) {
            this.javaMethods.add(jm);
        }
    }

    public void applyParameterBinding(WSDLBoundPortTypeImpl wsdlBinding) {
        if (wsdlBinding == null) {
            return;
        }
        for (JavaMethodImpl method : this.javaMethods) {
            if (method.isAsync()) continue;
            QName opName = new QName(wsdlBinding.getPortTypeName().getNamespaceURI(), method.getOperationName());
            WSDLBoundOperationImpl bo = wsdlBinding.get(opName);
            String action = bo.getSOAPAction();
            method.getBinding().setSOAPAction(action);
            boolean isRpclit = method.getBinding().isRpcLit();
            List<ParameterImpl> reqParams = method.requestParams;
            List<ParameterImpl> reqAttachParams = null;
            for (ParameterImpl param : reqParams) {
                ParameterBinding paramBinding;
                if (param.isWrapperStyle()) {
                    if (!isRpclit) continue;
                    WrapperParameter reqParam = (WrapperParameter)param;
                    if (bo.getRequestNamespace() != null) {
                        this.patchRpclitNamespace(bo.getRequestNamespace(), reqParam);
                    }
                    reqAttachParams = this.applyRpcLitParamBinding(method, (WrapperParameter)param, wsdlBinding, WebParam.Mode.IN);
                    continue;
                }
                String partName = param.getPartName();
                if (partName == null || (paramBinding = wsdlBinding.getBinding(opName, partName, WebParam.Mode.IN)) == null) continue;
                param.setInBinding(paramBinding);
            }
            List<ParameterImpl> resAttachParams = null;
            List<ParameterImpl> resParams = method.responseParams;
            for (ParameterImpl param : resParams) {
                ParameterBinding paramBinding;
                if (param.isWrapperStyle()) {
                    if (!isRpclit) continue;
                    WrapperParameter respParam = (WrapperParameter)param;
                    if (bo.getResponseNamespace() != null) {
                        this.patchRpclitNamespace(bo.getResponseNamespace(), respParam);
                    }
                    resAttachParams = this.applyRpcLitParamBinding(method, (WrapperParameter)param, wsdlBinding, WebParam.Mode.OUT);
                    continue;
                }
                String partName = param.getPartName();
                if (partName == null || (paramBinding = wsdlBinding.getBinding(opName, partName, WebParam.Mode.OUT)) == null) continue;
                param.setOutBinding(paramBinding);
            }
            if (reqAttachParams != null) {
                for (ParameterImpl p : reqAttachParams) {
                    method.addRequestParameter(p);
                }
            }
            if (resAttachParams == null) continue;
            for (ParameterImpl p : resAttachParams) {
                method.addResponseParameter(p);
            }
        }
    }

    private void patchRpclitNamespace(String namespace, WrapperParameter param) {
        TypeReference type = param.getTypeReference();
        TypeReference newType = new TypeReference(new QName(namespace, type.tagName.getLocalPart()), type.type, type.annotations);
        param.setTypeReference(newType);
    }

    private List<ParameterImpl> applyRpcLitParamBinding(JavaMethodImpl method, WrapperParameter wrapperParameter, WSDLBoundPortTypeImpl boundPortType, WebParam.Mode mode) {
        QName opName = new QName(boundPortType.getPortTypeName().getNamespaceURI(), method.getOperationName());
        WSDLBoundOperationImpl bo = boundPortType.get(opName);
        HashMap<Integer, ParameterImpl> bodyParams = new HashMap<Integer, ParameterImpl>();
        ArrayList<ParameterImpl> unboundParams = new ArrayList<ParameterImpl>();
        ArrayList<ParameterImpl> attachParams = new ArrayList<ParameterImpl>();
        for (ParameterImpl param : wrapperParameter.wrapperChildren) {
            ParameterBinding paramBinding;
            String partName = param.getPartName();
            if (partName == null || (paramBinding = boundPortType.getBinding(opName, partName, mode)) == null) continue;
            if (mode == WebParam.Mode.IN) {
                param.setInBinding(paramBinding);
            } else if (mode == WebParam.Mode.OUT || mode == WebParam.Mode.INOUT) {
                param.setOutBinding(paramBinding);
            }
            if (paramBinding.isUnbound()) {
                unboundParams.add(param);
                continue;
            }
            if (paramBinding.isAttachment()) {
                attachParams.add(param);
                continue;
            }
            if (!paramBinding.isBody()) continue;
            if (bo != null) {
                WSDLPartImpl p = bo.getPart(param.getPartName(), mode);
                if (p != null) {
                    bodyParams.put(p.getIndex(), param);
                    continue;
                }
                bodyParams.put(bodyParams.size(), param);
                continue;
            }
            bodyParams.put(bodyParams.size(), param);
        }
        wrapperParameter.clear();
        for (int i = 0; i < bodyParams.size(); ++i) {
            ParameterImpl p = (ParameterImpl)bodyParams.get(i);
            wrapperParameter.addWrapperChild(p);
        }
        for (ParameterImpl p : unboundParams) {
            wrapperParameter.addWrapperChild(p);
        }
        return attachParams;
    }

    void put(QName name, JavaMethodImpl jm) {
        this.nameToJM.put(name, jm);
    }

    void put(Method method, JavaMethodImpl jm) {
        this.methodToJM.put(method, jm);
    }

    @Override
    public String getWSDLLocation() {
        return this.wsdlLocation;
    }

    void setWSDLLocation(String location) {
        this.wsdlLocation = location;
    }

    @Override
    public QName getServiceQName() {
        return this.serviceName;
    }

    @Override
    public WSDLPort getPort() {
        return this.port;
    }

    @Override
    public QName getPortName() {
        return this.portName;
    }

    @Override
    public QName getPortTypeName() {
        return this.portTypeName;
    }

    void setServiceQName(QName name) {
        this.serviceName = name;
    }

    void setPortName(QName name) {
        this.portName = name;
    }

    void setPortTypeName(QName name) {
        this.portTypeName = name;
    }

    void setTargetNamespace(String namespace) {
        this.targetNamespace = namespace;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    @NotNull
    public QName getBoundPortTypeName() {
        assert (this.portName != null);
        return new QName(this.portName.getNamespaceURI(), this.portName.getLocalPart() + "Binding");
    }

    public void setAdditionalClasses(Class[] additionalClasses) {
        for (Class cls : additionalClasses) {
            this.additionalClasses.add(cls);
        }
    }
}

